/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.impl.QueryElement;
import com.vmware.vise.search.impl.QueryExpr;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class QueryExprBase
implements QueryExpr {
    private static QueryExpr[] emptyExprArray = new QueryExpr[0];
    private String _expr;
    private List<QueryExpr> _subExprs;
    private QueryElement _parent;
    private String _entityType;
    private String _resourceModel;
    private ConstraintConjoiner _conjoiner;

    public QueryExprBase() {
    }

    public QueryExprBase(QueryExpr queryExpr) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryExpr});
        this._expr = queryExpr.getExpr();
        this._subExprs = Arrays.asList(queryExpr.getChildren());
        this._parent = queryExpr.getParent();
        this._entityType = queryExpr.getEntityType();
        this._conjoiner = queryExpr.getConjoiner();
    }

    @Override
    public QueryElement getParent() {
        return this._parent;
    }

    @Override
    public void setParent(QueryElement queryElement) {
        this._parent = queryElement;
        if (this._parent != null && this._entityType == null) {
            this._entityType = queryElement.getEntityType();
        }
    }

    @Override
    public String getEntityType() {
        if (this._entityType == null && this._parent != null) {
            this._entityType = this._parent.getEntityType();
        }
        return this._entityType;
    }

    @Override
    public void setEntityType(String string) {
        this._entityType = string;
        if (this._entityType == null && this._parent != null) {
            this._entityType = this._parent.getEntityType();
        }
    }

    @Override
    public String getResourceModel() {
        return this._resourceModel;
    }

    @Override
    public void setResourceModel(String string) {
        this._resourceModel = string;
    }

    @Override
    public String getExpr() {
        return this._expr;
    }

    @Override
    public void setExpr(String string) {
        this._expr = string;
    }

    public String toString() {
        String string = null;
        return this.evaluate(string);
    }

    @Override
    public ConstraintConjoiner getConjoiner() {
        return this._conjoiner;
    }

    @Override
    public void setConjoiner(ConstraintConjoiner constraintConjoiner) {
        this._conjoiner = constraintConjoiner;
    }

    @Override
    public void addChild(QueryExpr queryExpr) {
        if (queryExpr == null) {
            return;
        }
        if (this._subExprs == null) {
            this._subExprs = new ArrayList<QueryExpr>(2);
        }
        queryExpr.setParent(this);
        this._subExprs.add(queryExpr);
    }

    public QueryExpr[] getChildren() {
        if (this._subExprs == null) {
            return emptyExprArray;
        }
        return this._subExprs.toArray(new QueryExpr[this._subExprs.size()]);
    }

    @Override
    public void removeChild(QueryExpr queryExpr) {
        if (this._subExprs == null || this._subExprs.size() == 0 || queryExpr == null || queryExpr.getParent() != this) {
            return;
        }
        queryExpr.setParent(null);
        this._subExprs.remove(queryExpr);
    }

    public void replaceChild(QueryExpr queryExpr, QueryExpr queryExpr2) {
        if (queryExpr == null || queryExpr2 == null) {
            throw new IllegalArgumentException();
        }
        int n = this._subExprs.indexOf(queryExpr);
        if (n >= 0) {
            queryExpr2.setParent(this);
            this._subExprs.set(n, queryExpr2);
        }
    }

    @Override
    public boolean isUnset() {
        return this.getExpr() == null && this.getChildren().length == 0;
    }

    @Override
    public void clear() {
        if (this._subExprs != null) {
            this._subExprs.clear();
        }
        this._expr = null;
        this._conjoiner = null;
    }
}

