/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.ConstraintFactory;
import com.vmware.vise.search.impl.OptimizeConstraintTransformer;
import com.vmware.vise.search.impl.QueryRequest;
import com.vmware.vise.search.impl.QueryTransformer;
import com.vmware.vise.search.impl.ResponseSpecificUnmarshallerDirectory;
import com.vmware.vise.search.impl.ResultSetProcessor;
import com.vmware.vise.search.impl.SearchPropertyConstraintTransformer;
import com.vmware.vise.search.impl.SearchServiceExtensionRegistryInternal;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.impl.Vmodl2ConstraintTransformer;
import com.vmware.vise.search.impl.XQueryGenerator;
import com.vmware.vise.search.metadata.CodeFlavor;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.util.QueryGenerator;
import com.vmware.vise.search.xquery.render.RendererFactory;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.transform.Transformer;

public final class QueryProcessorFactory {
    private static final Version QS_VERSION_VMODL2_SUPPORT = new Version("6.0");
    private final SearchServiceExtensionRegistryInternal _extensionRegistry;
    private final ConstraintFactory _constraintFactory;
    private final QueryGenerator _legacyGenerator;
    private final QueryGenerator _contemporaryGenerator;
    private final QueryTransformer _legacyTransformer;
    private final QueryTransformer _contemporaryTransformer;

    public QueryProcessorFactory(SearchServiceExtensionRegistryInternal searchServiceExtensionRegistryInternal, ConstraintFactory constraintFactory) {
        this._extensionRegistry = searchServiceExtensionRegistryInternal;
        this._constraintFactory = constraintFactory;
        this._legacyTransformer = this.createTransformerForFlavor(CodeFlavor.LEGACY);
        this._contemporaryTransformer = this.createTransformerForFlavor(CodeFlavor.VMODL2_SUPPORT);
        this._legacyGenerator = this.createGeneratorForFlavor(CodeFlavor.LEGACY);
        this._contemporaryGenerator = this.createGeneratorForFlavor(CodeFlavor.VMODL2_SUPPORT);
    }

    public QueryTransformer createTransformer(String string) {
        QueryTransformer queryTransformer = string == null || QueryProcessorFactory.serviceVersionSupportsVmodl2(string) ? this._contemporaryTransformer : this._legacyTransformer;
        return queryTransformer;
    }

    public QueryGenerator createGenerator(String string) {
        QueryGenerator queryGenerator = string == null || QueryProcessorFactory.serviceVersionSupportsVmodl2(string) ? this._contemporaryGenerator : this._legacyGenerator;
        return queryGenerator;
    }

    public ResultSetProcessor createResultSetProcessor(String string, ResponseSpecificUnmarshallerDirectory responseSpecificUnmarshallerDirectory, QueryRequest queryRequest) {
        CodeFlavor codeFlavor = string == null || QueryProcessorFactory.serviceVersionSupportsVmodl2(string) ? CodeFlavor.VMODL2_SUPPORT : CodeFlavor.LEGACY;
        MetadataDirectory metadataDirectory = this._extensionRegistry.getMetadataDirectory(codeFlavor);
        return new ResultSetProcessor(metadataDirectory, responseSpecificUnmarshallerDirectory, queryRequest);
    }

    private QueryTransformer createTransformerForFlavor(CodeFlavor codeFlavor) {
        Object object;
        MetadataDirectory metadataDirectory = this._extensionRegistry.getMetadataDirectory(codeFlavor);
        QueryTransformer queryTransformer = new QueryTransformer();
        if (codeFlavor == CodeFlavor.VMODL2_SUPPORT) {
            object = new Vmodl2ConstraintTransformer(this._constraintFactory);
            queryTransformer.registerConstraintTransformer((Transformer<Constraint>)object);
        }
        object = new SearchPropertyConstraintTransformer(metadataDirectory, this._constraintFactory);
        queryTransformer.registerConstraintTransformer((Transformer<Constraint>)object);
        OptimizeConstraintTransformer optimizeConstraintTransformer = new OptimizeConstraintTransformer(this._constraintFactory);
        queryTransformer.registerConstraintTransformer(optimizeConstraintTransformer);
        return queryTransformer;
    }

    private QueryGenerator createGeneratorForFlavor(CodeFlavor codeFlavor) {
        TypeRefDirectory typeRefDirectory = this._extensionRegistry.getTypeRefDirectory();
        MetadataDirectory metadataDirectory = this._extensionRegistry.getMetadataDirectory(codeFlavor);
        RendererFactory rendererFactory = new RendererFactory(typeRefDirectory, metadataDirectory, codeFlavor);
        return new XQueryGenerator(typeRefDirectory, metadataDirectory, rendererFactory);
    }

    private static boolean serviceVersionSupportsVmodl2(String string) {
        return QS_VERSION_VMODL2_SUPPORT.compareTo(new Version(string)) <= 0;
    }
}

