/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.OrderingCriteria;
import com.vmware.vise.search.PropertySpec;
import com.vmware.vise.search.QuerySpec;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.impl.ConstraintTree;
import com.vmware.vise.search.impl.QueryRequest;
import com.vmware.vise.search.impl.SpecUtil;
import com.vmware.vise.util.IdentityHashSet;
import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import com.vmware.vise.util.transform.TransformUtil;
import com.vmware.vise.util.transform.TransformationException;
import com.vmware.vise.util.transform.Transformer;
import com.vmware.vise.util.transform.TreeTransformer;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueryTransformer
implements Transformer<QueryRequest> {
    private static final Log _logger = LogFactory.getLog(QueryTransformer.class);
    private final Set<Transformer<Constraint>> _constraintTransformers = new IdentityHashSet();
    private Set<Transformer<PropertySpec[]>> _propertySpecTransformers = new IdentityHashSet();
    private Set<Transformer<OrderingCriteria>> _ocTransformers = new IdentityHashSet();

    public void registerConstraintTransformer(Transformer<Constraint> transformer) {
        this._constraintTransformers.add(transformer);
    }

    public void unregisterConstraintTransformer(Transformer<Constraint> transformer) {
        this._constraintTransformers.remove(transformer);
    }

    public void registerPropertySpecTransformer(Transformer<PropertySpec[]> transformer) {
        this._propertySpecTransformers.add(transformer);
    }

    public void unregisterPropertySpecTransformer(Transformer<PropertySpec[]> transformer) {
        this._propertySpecTransformers.remove(transformer);
    }

    public void registerOrderTransformer(Transformer<OrderingCriteria> transformer) {
        this._ocTransformers.add(transformer);
    }

    public void unregisterOrderTransformer(Transformer<OrderingCriteria> transformer) {
        this._ocTransformers.remove(transformer);
    }

    public Transformer.Result<QueryRequest> transform(QueryRequest queryRequest) {
        if (queryRequest.querySpec == null || queryRequest.responseSpec == null) {
            throw new IllegalArgumentException("Invalid input query.");
        }
        QueryRequest queryRequest2 = queryRequest;
        QuerySpecTransformer querySpecTransformer = new QuerySpecTransformer();
        Transformer.Result result = querySpecTransformer.transform(queryRequest.querySpec);
        ResponseSpecTransformer responseSpecTransformer = new ResponseSpecTransformer();
        Transformer.Result result2 = responseSpecTransformer.transform(queryRequest.responseSpec);
        TransformationException transformationException = TransformUtil.getCompositeError((Exception)result.getError(), (Exception)result2.getError());
        if (result.isTransformed() || result2.isTransformed()) {
            queryRequest2 = new QueryRequest((QuerySpec)result.getData(), (ResponseSpec)result2.getData());
        }
        boolean bl = queryRequest2 != queryRequest;
        return new Transformer.Result((Object)queryRequest2, bl, transformationException);
    }

    private final class ResponseSpecTransformer
    implements Transformer<ResponseSpec> {
        private ResponseSpecTransformer() {
        }

        public Transformer.Result<ResponseSpec> transform(ResponseSpec responseSpec) {
            if (responseSpec == null) {
                throw new IllegalArgumentException("Invalid input query.");
            }
            Transformer.Result result = TransformUtil.executeTransformers((Collection)QueryTransformer.this._propertySpecTransformers, (Object)responseSpec.propertiesToRetrieve);
            Transformer.Result result2 = TransformUtil.executeTransformers((Collection)QueryTransformer.this._ocTransformers, (Object)responseSpec.orderingCriteria);
            ResponseSpec responseSpec2 = responseSpec;
            boolean bl = result2.isTransformed() || result.isTransformed();
            TransformationException transformationException = TransformUtil.getCompositeError((Exception)result2.getError(), (Exception)result.getError());
            if (bl) {
                responseSpec2 = new ResponseSpec();
                responseSpec2.offset = responseSpec.offset;
                responseSpec2.maxResultsCount = responseSpec.maxResultsCount;
                responseSpec2.propertiesToRetrieve = (PropertySpec[])result.getData();
                responseSpec2.orderingCriteria = (OrderingCriteria)result2.getData();
                responseSpec2.facets = responseSpec.facets;
                if (_logger.isTraceEnabled()) {
                    String string = SpecUtil.toString(responseSpec);
                    String string2 = SpecUtil.toString(responseSpec2);
                    _logger.trace((Object)("A " + responseSpec.getClass().getSimpleName() + " was transformed. The original was:\n" + string + "\n\nand was transformed to:\n\n" + string2));
                }
            }
            return new Transformer.Result((Object)responseSpec2, bl, transformationException);
        }
    }

    private final class QuerySpecTransformer
    implements Transformer<QuerySpec> {
        private QuerySpecTransformer() {
        }

        public Transformer.Result<QuerySpec> transform(QuerySpec querySpec) {
            if (querySpec == null || querySpec.constraint == null) {
                throw new IllegalArgumentException("Invalid input query.");
            }
            ConstraintInternal constraintInternal = (ConstraintInternal)querySpec.constraint;
            ConstraintTree constraintTree = new ConstraintTree(constraintInternal);
            Transformer<Node<ConstraintInternal>> transformer = new Transformer<Node<ConstraintInternal>>(){

                public Transformer.Result<Node<ConstraintInternal>> transform(Node<ConstraintInternal> node) {
                    Transformer.Result result = TransformUtil.executeTransformers((Collection)QueryTransformer.this._constraintTransformers, (Object)node.getData());
                    ConstraintInternal constraintInternal = (ConstraintInternal)result.getData();
                    ConstraintTree.ConstraintNode constraintNode = new ConstraintTree.ConstraintNode(constraintInternal);
                    return new Transformer.Result((Object)constraintNode, result.isTransformed(), result.getError());
                }
            };
            TreeTransformer treeTransformer = new TreeTransformer((Transformer)transformer);
            Transformer.Result result = treeTransformer.transform((Tree)constraintTree);
            QuerySpec querySpec2 = querySpec;
            boolean bl = result.isTransformed();
            if (bl) {
                querySpec2 = new QuerySpec();
                querySpec2.constraint = (Constraint)((Tree)result.getData()).getRoot().getData();
                querySpec2.options = querySpec.options;
                querySpec2.name = querySpec.name;
                if (_logger.isTraceEnabled()) {
                    String string = SpecUtil.toString(querySpec);
                    String string2 = SpecUtil.toString(querySpec2);
                    _logger.trace((Object)("A " + querySpec.getClass().getSimpleName() + " was transformed. The original was:\n" + string + "\n\nand was transformed to:\n\n" + string2));
                }
            }
            return new Transformer.Result((Object)querySpec2, bl, result.getError());
        }
    }
}

