/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.metadata.CodeFlavor;
import com.vmware.vise.search.metadata.DefaultRelationDescriptorDirectory;
import com.vmware.vise.search.metadata.DefaultTypeDescriptorDirectory;
import com.vmware.vise.search.metadata.DescriptorDirectoryStoreAccess;
import com.vmware.vise.search.metadata.DescriptorSource;
import com.vmware.vise.search.metadata.FunctionDescriptor;
import com.vmware.vise.search.metadata.FunctionDescriptorDirectory;
import com.vmware.vise.search.metadata.FunctionDescriptorDirectoryImpl;
import com.vmware.vise.search.metadata.LegacyRelationDescriptorDirectory;
import com.vmware.vise.search.metadata.LegacyTypeDescriptorDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.PropertyDescriptorDirectory;
import com.vmware.vise.search.metadata.PropertyDescriptorDirectoryImpl;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptorDirectory;
import com.vmware.vise.search.metadata.SearchServiceMessageLocalizer;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.search.metadata.TypeDescriptorDirectory;
import com.vmware.vise.search.metadata.TypeDescriptorDirectoryBase;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class DirectoryContainer {
    private final TypeDescriptorDirectory _typeDirectory;
    private final PropertyDescriptorDirectory _propertyDirectory;
    private final RelationDescriptorDirectory _relationDirectory;
    private final FunctionDescriptorDirectory _functionDirectory;
    private final DescriptorDirectoryStoreAccess<TypeDescriptor> _typeDirectoryAccess;
    private final DescriptorDirectoryStoreAccess<PropertyDescriptor> _propertyDirectoryAccess;
    private final DescriptorDirectoryStoreAccess<RelationDescriptor> _relationDirectoryAccess;
    private final DescriptorDirectoryStoreAccess<FunctionDescriptor> _functionDirectoryAccess;
    private final boolean _readOnly;

    private DirectoryContainer(TypeDescriptorDirectory typeDescriptorDirectory, PropertyDescriptorDirectory propertyDescriptorDirectory, RelationDescriptorDirectory relationDescriptorDirectory, FunctionDescriptorDirectory functionDescriptorDirectory, DescriptorDirectoryStoreAccess<TypeDescriptor> descriptorDirectoryStoreAccess, DescriptorDirectoryStoreAccess<PropertyDescriptor> descriptorDirectoryStoreAccess2, DescriptorDirectoryStoreAccess<RelationDescriptor> descriptorDirectoryStoreAccess3, DescriptorDirectoryStoreAccess<FunctionDescriptor> descriptorDirectoryStoreAccess4, boolean bl) {
        this._typeDirectory = typeDescriptorDirectory;
        this._propertyDirectory = propertyDescriptorDirectory;
        this._relationDirectory = relationDescriptorDirectory;
        this._functionDirectory = functionDescriptorDirectory;
        this._typeDirectoryAccess = descriptorDirectoryStoreAccess;
        this._propertyDirectoryAccess = descriptorDirectoryStoreAccess2;
        this._relationDirectoryAccess = descriptorDirectoryStoreAccess3;
        this._functionDirectoryAccess = descriptorDirectoryStoreAccess4;
        this._readOnly = bl;
    }

    private static MessageLocalizer createMsgLocalizerFor(DescriptorSource descriptorSource) {
        ClassLoader classLoader = descriptorSource.getResourceClassLoader();
        SearchServiceMessageLocalizer searchServiceMessageLocalizer = new SearchServiceMessageLocalizer(classLoader, descriptorSource.getResourceBundleName());
        return searchServiceMessageLocalizer;
    }

    public void addSource(DescriptorSource descriptorSource) {
        if (this._readOnly) {
            throw new UnsupportedOperationException("Read-only directory");
        }
        Validate.notNull((Object)descriptorSource, (String)"source");
        MessageLocalizer messageLocalizer = DirectoryContainer.createMsgLocalizerFor(descriptorSource);
        this._typeDirectoryAccess.addAll(descriptorSource.getTypes(), messageLocalizer);
        this._propertyDirectoryAccess.addAll(descriptorSource.getProperties(), messageLocalizer);
        this._relationDirectoryAccess.addAll(descriptorSource.getTypeRelationships(), messageLocalizer);
        this._functionDirectoryAccess.addAll(descriptorSource.getLocalFunctions(), messageLocalizer);
    }

    public void clear() {
        this._typeDirectoryAccess.clearAll();
        this._propertyDirectoryAccess.clearAll();
        this._relationDirectoryAccess.clearAll();
        this._functionDirectoryAccess.clearAll();
    }

    public TypeDescriptorDirectory getTypeDirectory() {
        return this._typeDirectory;
    }

    public PropertyDescriptorDirectory getPropertyDirectory() {
        return this._propertyDirectory;
    }

    public RelationDescriptorDirectory getRelationDirectory() {
        return this._relationDirectory;
    }

    public FunctionDescriptorDirectory getFunctionDirectory() {
        return this._functionDirectory;
    }

    public static final class Factory {
        public static Map<CodeFlavor, DirectoryContainer> createContainersPerFlavour(TypeRefDirectory typeRefDirectory) {
            DefaultTypeDescriptorDirectory defaultTypeDescriptorDirectory = new DefaultTypeDescriptorDirectory();
            LegacyTypeDescriptorDirectory legacyTypeDescriptorDirectory = new LegacyTypeDescriptorDirectory(defaultTypeDescriptorDirectory);
            PropertyDescriptorDirectoryImpl propertyDescriptorDirectoryImpl = new PropertyDescriptorDirectoryImpl(typeRefDirectory);
            DefaultRelationDescriptorDirectory defaultRelationDescriptorDirectory = new DefaultRelationDescriptorDirectory(defaultTypeDescriptorDirectory, propertyDescriptorDirectoryImpl);
            LegacyRelationDescriptorDirectory legacyRelationDescriptorDirectory = new LegacyRelationDescriptorDirectory(defaultRelationDescriptorDirectory, legacyTypeDescriptorDirectory, propertyDescriptorDirectoryImpl);
            FunctionDescriptorDirectoryImpl functionDescriptorDirectoryImpl = new FunctionDescriptorDirectoryImpl();
            Factory.registerBuiltInProperties(propertyDescriptorDirectoryImpl);
            Factory.registerLegacyVcOverrides(legacyTypeDescriptorDirectory);
            DirectoryContainer directoryContainer = new DirectoryContainer(defaultTypeDescriptorDirectory, propertyDescriptorDirectoryImpl, defaultRelationDescriptorDirectory, functionDescriptorDirectoryImpl, defaultTypeDescriptorDirectory, propertyDescriptorDirectoryImpl, defaultRelationDescriptorDirectory, functionDescriptorDirectoryImpl, false);
            DirectoryContainer directoryContainer2 = new DirectoryContainer(legacyTypeDescriptorDirectory, propertyDescriptorDirectoryImpl, legacyRelationDescriptorDirectory, functionDescriptorDirectoryImpl, defaultTypeDescriptorDirectory, propertyDescriptorDirectoryImpl, defaultRelationDescriptorDirectory, functionDescriptorDirectoryImpl, true);
            EnumMap<CodeFlavor, DirectoryContainer> enumMap = new EnumMap<CodeFlavor, DirectoryContainer>(CodeFlavor.class);
            enumMap.put(CodeFlavor.LEGACY, directoryContainer2);
            enumMap.put(CodeFlavor.VMODL2_SUPPORT, directoryContainer);
            return enumMap;
        }

        private static void registerBuiltInProperties(PropertyDescriptorDirectoryImpl propertyDescriptorDirectoryImpl) {
            DescriptorSource descriptorSource = MetadataUtil.loadSearchBundleMetadata("builtin-properties");
            propertyDescriptorDirectoryImpl.addBuiltin(descriptorSource.getProperties(), DirectoryContainer.createMsgLocalizerFor(descriptorSource));
        }

        private static void registerLegacyVcOverrides(TypeDescriptorDirectoryBase typeDescriptorDirectoryBase) {
            DescriptorSource descriptorSource = MetadataUtil.loadSearchBundleMetadata("legacy-vc-overrides");
            typeDescriptorDirectoryBase.addAll((Collection<TypeDescriptor>)descriptorSource.getTypes(), DirectoryContainer.createMsgLocalizerFor(descriptorSource));
        }
    }
}

