/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.QueryExprInfo;
import com.vmware.vise.search.metadata.ChildNodeIndex;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class RelationDescriptorImpl
implements RelationDescriptor {
    private static final boolean OPTIONAL = true;
    private static final boolean REQUIRED = false;
    private static final Logger _logger = LoggerFactory.getLogger(RelationDescriptorImpl.class);
    private final String _id;
    private final String _type;
    private final String _propertyName;
    private final Map<String, String> _tags;
    private final List<QueryExprInfo> _queryExpressions;
    private final String _inverseId;
    private final String _status;

    public RelationDescriptorImpl(Node node) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{node});
        ChildNodeIndex childNodeIndex = new ChildNodeIndex(node);
        this._status = XMLUtil.getAttribute((Element)((Element)node), (String)"status");
        this._tags = MetadataUtil.extractTags(childNodeIndex);
        this._id = childNodeIndex.getStringValueFor("id", false);
        this._type = childNodeIndex.getStringValueFor("sourceType", true);
        this._propertyName = childNodeIndex.getStringValueFor("propertyName", false);
        this._inverseId = childNodeIndex.getStringValueFor("inverseId", false);
        List<QueryExprInfo> list = MetadataUtil.extractQueryExpressions(childNodeIndex);
        if ((this._status == null || !this._status.equalsIgnoreCase("unsupported")) && list.isEmpty()) {
            _logger.error("The relationship descriptor by the name of {} does not contain a valid query expression set to it", (Object)this._id);
        }
        this._queryExpressions = list;
    }

    RelationDescriptorImpl(String string, String string2, String string3, String string4) {
        this._id = string;
        this._inverseId = string2;
        this._propertyName = string3;
        this._type = null;
        this._tags = Collections.emptyMap();
        this._queryExpressions = MetadataUtil.getDefaultQueryInfo(string4);
        this._status = null;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getSourceType() {
        return this._type;
    }

    @Override
    public String getPropertyName() {
        return this._propertyName;
    }

    @Override
    public String getInverseId() {
        return this._inverseId;
    }

    @Override
    public Map<String, String> getTags() {
        return this._tags;
    }

    @Override
    public List<QueryExprInfo> getQueryExpressions() {
        return this._queryExpressions;
    }

    @Override
    public String getStatus() {
        return this._status;
    }
}

