/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.model;

import com.vmware.vise.search.model.ModelInfo;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ModelUtils {
    private static final Log _logger = LogFactory.getLog(ModelUtils.class);

    public static boolean isQualifiedWithResourceModel(String string) {
        if (string == null) {
            return false;
        }
        String string2 = ModelUtils.getResourceModel(string);
        return string2 != null;
    }

    public static String getResourceModel(String string) {
        if (string == null) {
            return null;
        }
        ModelInfo modelInfo = ModelUtils.getModelInfo(string);
        return modelInfo.getModel();
    }

    public static String getSimplePropertyName(String string) {
        if (string == null) {
            return null;
        }
        ModelInfo modelInfo = ModelUtils.getModelInfo(string);
        return modelInfo.getPropertyName();
    }

    public static String parseResourceModelCanonicalNameFromDocId(String string) {
        int n = string.lastIndexOf(":");
        if (n <= 0 || n == string.length() - 1) {
            _logger.warn((Object)("Invalid VMODL2 document id: " + string));
            return null;
        }
        String string2 = string.substring(n + 1);
        return string2;
    }

    public static ModelInfo getModelInfo(String string) {
        int n = ModelUtils.getModelPropertyDelimiterIndex(string);
        if (n == -1) {
            return new ModelInfo(string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (!ModelUtils.isVmodl2Name(string2)) {
            return new ModelInfo(string);
        }
        return new ModelInfo(string2, string3);
    }

    private static int getModelPropertyDelimiterIndex(String string) {
        int n = string.indexOf("/");
        if (n == 0 || n == string.length() - 1) {
            throw new IllegalArgumentException("Property name cannot start or end with: /");
        }
        return n;
    }

    public static boolean isVmodl2Name(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = string.contains(".");
        return bl;
    }

    public static boolean hasVmodl2Name(Collection<String> collection) {
        if (collection == null) {
            return false;
        }
        for (String string : collection) {
            if (!ModelUtils.isVmodl2Name(string)) continue;
            return true;
        }
        return false;
    }
}

