/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.util;

import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    public static final long QUERY_TIME_THRESHOLD_IN_MILLIS;
    public static final int MAXIMUM_NUMBER_OF_NESTED_CONSTRAINTS_PER_QUERY;

    public static long getLongProperty(Properties properties, String string, long l) {
        long l2 = l;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                l2 = Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                _logger.error((Object)("The property " + string + " cannot be parsed to long. Will use the default value: " + l), (Throwable)numberFormatException);
            }
        }
        return l2;
    }

    public static int getIntProperty(Properties properties, String string, int n) {
        int n2 = n;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                _logger.error((Object)("The property " + string + " cannot be parsed to int. Will use the default value: " + n), (Throwable)numberFormatException);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties properties = new Properties();
        ClassLoader classLoader = Config.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("search.properties");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                _logger.error((Object)"Failed to load the Search configuration properties", (Throwable)iOException);
            }
            finally {
                StreamUtil.close((Closeable)inputStream);
            }
        } else {
            _logger.warn((Object)"Search config.properties file not found. Will use defaults.");
        }
        QUERY_TIME_THRESHOLD_IN_MILLIS = Config.getLongProperty(properties, "queryTimeThreshold", 5000L);
        MAXIMUM_NUMBER_OF_NESTED_CONSTRAINTS_PER_QUERY = Config.getIntProperty(properties, "maximumNumberOfNestedConstraintPerQuery", 70);
    }
}

