/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.util;

public class KeyValuePair<K, V> {
    private final K _key;
    private final V _value;
    private final int _hashCode;

    public KeyValuePair(K k, V v) {
        if (k == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        if (v == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        this._key = k;
        this._value = v;
        this._hashCode = this.computeHashCode();
    }

    public K getKey() {
        return this._key;
    }

    public V getValue() {
        return this._value;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof KeyValuePair) {
            KeyValuePair keyValuePair = (KeyValuePair)object;
            bl = this._key.equals(keyValuePair._key) && this._value.equals(keyValuePair._value);
        }
        return bl;
    }

    private int computeHashCode() {
        int n = 17;
        n = 31 * n + this._key.hashCode();
        n = 31 * n + this._value.hashCode();
        return n;
    }

    public int hashCode() {
        return this._hashCode;
    }
}

