/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.vapi;

import com.vmware.vapi.bindings.DynamicStructClassResolver;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.is.common.XmlStreamReaderInputSource;
import com.vmware.vapi.is.Deserializer;
import com.vmware.vapi.is.SerializerFactory;
import com.vmware.vapi.is.ValueDeserializer;
import com.vmware.vapi.is.XmlInputSource;
import com.vmware.vapi.util.StructTypeUtil;
import com.vmware.vise.search.PropertyInfo;
import com.vmware.vise.search.PropertyUnmarshaller;
import com.vmware.vise.search.ValueEx;
import com.vmware.vise.search.impl.UnmarshallingUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.vapi.PropertyPathUtil;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.xml.XmlStreamUtils;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Vmodl2PropertyUnmarshaller
implements PropertyUnmarshaller {
    private static final Log _logger = LogFactory.getLog(Vmodl2PropertyUnmarshaller.class);
    private static final SerializerFactory _factory = new SerializerFactory();
    private static final ValueDeserializer _dynamicDeserializer;
    private static final ResourceModelTypeProvider _vapiBuiltinTypesProvider;
    private final Deserializer _staticDeserializer;
    ResourceModelTypeProvider _resourceModelTypeProvider;

    public Vmodl2PropertyUnmarshaller() {
        this(null);
    }

    public Vmodl2PropertyUnmarshaller(ResourceModelTypeProvider resourceModelTypeProvider) {
        this._resourceModelTypeProvider = resourceModelTypeProvider;
        DynamicStructClassResolver dynamicStructClassResolver = new DynamicStructClassResolver(){

            public Class<? extends StaticStructure> resolveTargetClass(StructValue structValue) {
                if (structValue == null) {
                    return null;
                }
                String string = structValue.getName();
                if (StringUtil.isNullOrWhitespace((String)string)) {
                    return null;
                }
                StructType structType = Vmodl2PropertyUnmarshaller.this._resourceModelTypeProvider.getResourceModelType(string);
                if (structType == null) {
                    return null;
                }
                Class clazz = structType.getBindingClass();
                if (clazz == null) {
                    return null;
                }
                if (clazz.isInstance(StaticStructure.class)) {
                    Class clazz2 = clazz;
                    return clazz2;
                }
                _logger.warn((Object)("The StructType for canonical name " + string + " contains a binding class which is not in instance of " + StaticStructure.class.getCanonicalName() + ". The actual type is: " + clazz.getCanonicalName()));
                return null;
            }
        };
        this._staticDeserializer = _factory.createDeserializer(dynamicStructClassResolver);
    }

    @Override
    public ValueEx<Object> getValue(PropertyInfo propertyInfo, XMLStreamReader xMLStreamReader) throws XMLStreamException {
        Object object = null;
        Class clazz = null;
        try {
            XmlStreamReaderInputSource xmlStreamReaderInputSource = new XmlStreamReaderInputSource(xMLStreamReader);
            String string = propertyInfo.getProviderResourceModelCanonicalName();
            StructType structType = this.determineResourceModelType(string, xMLStreamReader);
            Type type = null;
            if (structType != null) {
                String string2 = Vmodl2PropertyUnmarshaller.getPropertyPath(propertyInfo);
                type = PropertyPathUtil.getPropertyType(string2, structType);
                clazz = structType.getBindingClass();
            } else {
                String string3 = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.VAPI_NAME_ATTRIB_QNAME);
                if (!StringUtil.isNullOrEmpty((String)string3)) {
                    type = _vapiBuiltinTypesProvider.getResourceModelType(string3);
                }
            }
            object = type != null ? this._staticDeserializer.deserialize((XmlInputSource)xmlStreamReaderInputSource, type) : _dynamicDeserializer.deserialize((XmlInputSource)xmlStreamReaderInputSource);
        }
        catch (Exception exception) {
            _logger.error((Object)this.getErrorMessageFor(propertyInfo), (Throwable)exception);
            UnmarshallingUtil.moveReaderUntilStartOrEndElement(xMLStreamReader);
            return new ValueEx<Object>(object, (Class<?>)clazz, exception);
        }
        return new ValueEx<DataValue>((DataValue)object, clazz);
    }

    private static String getPropertyPath(PropertyInfo propertyInfo) {
        if (!(propertyInfo instanceof PropertyDescriptor)) {
            return propertyInfo.getSimpleName();
        }
        String string = ((PropertyDescriptor)propertyInfo).getPath();
        if (string == null || string.isEmpty()) {
            return propertyInfo.getSimpleName();
        }
        return string;
    }

    private StructType determineResourceModelType(String string, XMLStreamReader xMLStreamReader) {
        if (string == null) {
            try {
                string = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (QName)XQueryUtils.DOC_VAPI_NAME_ATTRIB_QNAME);
            }
            catch (Exception exception) {
                String string2 = String.format("Error while determining the type of resource model: %s", exception.getMessage());
                _logger.error((Object)string2, (Throwable)exception);
            }
            if (string == null) {
                return null;
            }
        }
        StructType structType = null;
        if (this._resourceModelTypeProvider != null) {
            structType = this._resourceModelTypeProvider.getResourceModelType(string);
        }
        return structType;
    }

    private String getErrorMessageFor(PropertyInfo propertyInfo) {
        return String.format("Error while deserializing the value of VMODL2 property: (providerType=%1$s, propertyName=%2$s).", propertyInfo.getProvider(), propertyInfo.getName());
    }

    static {
        _vapiBuiltinTypesProvider = new VapiBuiltinTypesProvider();
        _dynamicDeserializer = _factory.createValueDeserializer();
    }

    public static class VapiBuiltinTypesProvider
    implements ResourceModelTypeProvider {
        private static final Map<String, StructType> _typesByCanonicalName = new ConcurrentHashMap<String, StructType>();

        public StructType getResourceModelType(String string) {
            StructType structType = _typesByCanonicalName.get(string);
            return structType;
        }

        static {
            StructTypeUtil.populateCanonicalNameToStructTypeMap(_typesByCanonicalName);
        }
    }
}

