/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery;

import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.Expression;

public class LogicalExpression
implements Expression {
    private final Operator _operator;
    private final Expression[] _operands;

    public LogicalExpression(Expression expression, Operator operator, Expression expression2) {
        this._operator = operator;
        this._operands = new Expression[2];
        this._operands[0] = expression;
        this._operands[1] = expression2;
    }

    public LogicalExpression(Operator operator, Expression ... expressionArray) {
        this._operator = operator;
        this._operands = expressionArray;
    }

    @Override
    public String evaluate() {
        String[] stringArray = new String[this._operands.length];
        int n = 0;
        for (Expression expression : this._operands) {
            stringArray[n++] = expression.evaluate();
        }
        String string = String.format(" %1$s ", this._operator.toString());
        String string2 = Strings.join(string, stringArray);
        return String.format("%1$s", string2);
    }

    public static enum Operator {
        AND{

            public String toString() {
                return "and";
            }
        }
        ,
        OR{

            public String toString() {
                return "or";
            }
        };

    }
}

