/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery;

import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.metadata.FunctionDescriptor;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.ComparisonExpression;
import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.LogicalExpression;
import com.vmware.vise.search.xquery.PathExpression;
import com.vmware.vise.search.xquery.PredicatedExpression;
import com.vmware.vise.search.xquery.SetExpression;
import com.vmware.vise.search.xquery.StringLiteralExpression;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.util.ValidationUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class XQueryUtils {
    public static final String DEFAULT_TARGET_ID = "target";
    public static final String MATCHED_RESOURCE_IDS_SET = "matchedResourceIds";
    public static final String ALL_DOCS = "/*";
    public static final char FTS_ALL_CHARS = '*';
    public static final String PROPSPEC_SEPARATOR = "::";
    public static final String QUERY_NAMESPACE = "query";
    public static final String VAPI_NAMESPACE_ALIAS = "vapi";
    public static final String VAPI_NAMESPACE = "urn:vim25";
    public static final String RESULT_TAG = "result";
    public static final QName RESULT_QNAME = new QName("query", "result");
    public static final String ITEM_TAG = "item";
    public static final QName ITEM_QNAME = new QName("query", "item");
    public static final String ITEM_COUNT_TAG = "itemCount";
    public static final QName ITEM_COUNT_QNAME = new QName("query", "itemCount");
    public static final String SORTED_TAG = "resultSorted";
    public static final QName SORTED_QNAME = new QName("query", "resultSorted");
    public static final String SERVICE_UUID_ATTRIB_NAME = "serviceUuid";
    public static final String PROVIDER_ATTRIB_NAME = "provider";
    public static final String DOC_PROVIDER_ATTRIB_NAME = "docProvider";
    public static final String RESOURCE_ATTRIB_NAME = "resource";
    public static final String DOC_RESOURCE_TYPE_ATTRIB_NAME = "docResourceType";
    public static final String GENERATION_ATTRIB_NAME = "generation";
    public static final String REDIRECT_ATTRIB_NAME = "xlink:href";
    public static final String VAPI_NAME_ATTRIB_NAME = "name";
    public static final String DOC_VAPI_NAME_ATTRIB_NAME = "docVapiName";
    public static final QName PROVIDER_ATTRIB_QNAME = new QName("query", "provider");
    public static final QName DOC_PROVIDER_ATTRIB_QNAME = new QName("query", "docProvider");
    public static final QName RESOURCE_ATTRIB_QNAME = new QName("query", "resource");
    public static final QName DOC_RESOURCE_TYPE_ATTRIB_QNAME = new QName("query", "docResourceType");
    public static final QName VAPI_NAME_ATTRIB_QNAME = new QName("urn:vim25", "name");
    public static final QName DOC_VAPI_NAME_ATTRIB_QNAME = new QName("query", "docVapiName");
    public static final QName GENERATION_ATTRIB_QNAME = new QName("query", "generation");
    public static final String FACET_TAG = "facet";
    public static final QName FACET_QNAME = new QName("query", "facet");
    public static final String PROP_PATH_TAG = "propPath";
    public static final QName PROP_PATH_ATTRIB_QNAME = new QName("query", "propPath");
    public static final String FACET_VALUE_TAG = "facetValue";
    public static final QName FACET_VALUE_QNAME = new QName("query", "facetValue");
    public static final String FACET_TOTAL_COUNT_TAG = "totalCount";
    public static final VarRefExpression DEFAULT_TARGET_REF_EXPR = new VarRefExpression("target");
    private static final Log LOGGER = LogFactory.getLog(XQueryUtils.class);
    private static final Pattern XQUERY_FUNCTION_IDENTIFIER = Pattern.compile("local:[A-Za-z_]([A-Za-z_0-9]|-)*\\(");

    public static String toQualifiedXPath(String string, String string2) {
        if (Strings.isNullOrEmpty(string) || Strings.isNullOrEmpty(string2)) {
            return string2;
        }
        String string3 = DEFAULT_TARGET_REF_EXPR.evaluate();
        String string4 = string;
        if (!string.startsWith(Character.toString('$'))) {
            VarRefExpression varRefExpression = new VarRefExpression(string);
            string4 = varRefExpression.evaluate();
        }
        if (!string2.contains(string4)) {
            string2 = string2.contains(string3) ? XQueryUtils.replaceTargetIdWith(string2, string) : XQueryUtils.addQualifiedTargetIdFor(null, string, string2);
        }
        return string2;
    }

    public static String functionDefinitionsIfApplicable(MetadataDirectory metadataDirectory, String string) {
        CharSequence charSequence;
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataDirectory});
        HashMap<String, FunctionDescriptor> hashMap = new HashMap<String, FunctionDescriptor>();
        Matcher matcher = XQUERY_FUNCTION_IDENTIFIER.matcher(string);
        while (matcher.find()) {
            charSequence = XQueryUtils.getFunctionName(matcher.group());
            XQueryUtils.addFunction(metadataDirectory, (String)charSequence, hashMap);
        }
        charSequence = new StringBuilder();
        for (String string2 : hashMap.keySet()) {
            FunctionDescriptor functionDescriptor = hashMap.get(string2);
            ((StringBuilder)charSequence).append(functionDescriptor.getDefinition().trim());
            ((StringBuilder)charSequence).append("\n");
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String typeMatchingExpression(String string, MetadataDirectory metadataDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataDirectory});
        if (string == null) {
            return ALL_DOCS;
        }
        TypeDescriptor typeDescriptor = metadataDirectory.getTypeDescriptor(string);
        if (typeDescriptor == null) {
            return ALL_DOCS;
        }
        String string2 = MetadataUtil.getQueryExpression(typeDescriptor);
        if (Strings.isNullOrEmpty(string2)) {
            return ALL_DOCS;
        }
        return string2;
    }

    public static Expression createModelMatchingExpression(String string) {
        if (string == null) {
            return null;
        }
        ComparisonExpression comparisonExpression = new ComparisonExpression(new LiteralExpression("@qs:model"), ComparisonExpression.Operator.EQUALS, new StringLiteralExpression(string));
        return comparisonExpression;
    }

    public static Expression addModelMatchingExpression(String string, Expression expression) {
        Expression expression2 = XQueryUtils.createModelMatchingExpression(string);
        if (expression2 == null) {
            return expression;
        }
        LogicalExpression logicalExpression = new LogicalExpression(expression2, LogicalExpression.Operator.AND, expression);
        return logicalExpression;
    }

    public static String replaceTargetIdWith(String string, String string2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        String string3 = DEFAULT_TARGET_REF_EXPR.evaluate();
        VarRefExpression varRefExpression = new VarRefExpression(string2);
        String string4 = varRefExpression.evaluate();
        String string5 = string.replaceAll("\\" + string3, "\\" + string4);
        return string5;
    }

    public static String replaceCascadingClausesWithAnd(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        int n = 0;
        do {
            int n2;
            if ((n = string.indexOf("][")) < 0) {
                return string;
            }
            Stack<Character> stack = new Stack<Character>();
            int n3 = 0;
            int n4 = n;
            while (n4 >= 0) {
                if ((n2 = string.charAt(--n4)) == 93) {
                    stack.push(Character.valueOf((char)n2));
                    continue;
                }
                if (n2 != 91) continue;
                if (stack.empty()) {
                    n3 = n4;
                    break;
                }
                stack.pop();
            }
            n2 = 0;
            n4 = n + "][".length();
            while (n4 < string.length()) {
                char c;
                if ((c = string.charAt(++n4)) == '[') {
                    stack.push(Character.valueOf(c));
                    continue;
                }
                if (c != ']') continue;
                if (stack.empty()) {
                    n2 = n4;
                    break;
                }
                stack.pop();
            }
            String string2 = string.substring(0, n3 + 1);
            String string3 = string.substring(n3 + 1, n2);
            string3 = string3.replaceAll("]\\[", ") and (");
            String string4 = string.substring(n2);
            string = String.format("%1$s(%2$s)%3$s", string2, string3, string4);
        } while (n >= 0);
        return string;
    }

    public static SetExpression.Operator toSetXQueryOperator(ConstraintConjoiner constraintConjoiner) {
        switch (constraintConjoiner) {
            case EXCEPT: {
                return SetExpression.Operator.EXCEPT;
            }
            case OR: {
                return SetExpression.Operator.UNION;
            }
            case AND: {
                return SetExpression.Operator.INTERSECT;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static LogicalExpression.Operator toLogicalXQueryOperator(ConstraintConjoiner constraintConjoiner) {
        switch (constraintConjoiner) {
            case AND: {
                return LogicalExpression.Operator.AND;
            }
            case OR: {
                return LogicalExpression.Operator.OR;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static String getFunctionName(String string) {
        assert (string != null);
        int n = string.indexOf("(");
        if (n < 0) {
            throw new IllegalArgumentException(String.format("Invalid query. XQuery function with name {0} is not recognized.", string));
        }
        return string.substring(0, n);
    }

    private static void addFunction(MetadataDirectory metadataDirectory, String string, Map<String, FunctionDescriptor> map) {
        assert (metadataDirectory != null);
        assert (map != null);
        if (map.containsKey(string)) {
            return;
        }
        FunctionDescriptor functionDescriptor = metadataDirectory.getFunctionDescriptor(string);
        if (functionDescriptor == null) {
            LOGGER.warn((Object)String.format("Function: %1$s have to be defined in the functions.xml meta-data", string));
            return;
        }
        for (String string2 : functionDescriptor.getReferencedFunctionNames()) {
            XQueryUtils.addFunction(metadataDirectory, string2, map);
        }
        map.put(functionDescriptor.getName(), functionDescriptor);
    }

    public static String addQualifiedTargetIdFor(String string, String string2, String string3) {
        Expression expression;
        VarRefExpression varRefExpression;
        if (Strings.isNullOrEmpty(string2) || Strings.isNullOrEmpty(string3)) {
            return string3;
        }
        LiteralExpression literalExpression = new LiteralExpression(string3);
        Expression expression2 = varRefExpression = new VarRefExpression(string2);
        if (!Strings.isNullOrEmpty(string)) {
            expression = XQueryUtils.createModelMatchingExpression(string);
            expression2 = new PredicatedExpression(varRefExpression, expression);
        }
        expression = new PathExpression(expression2, literalExpression);
        String string4 = expression.evaluate();
        return string4;
    }
}

