/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.search.OrderingCriteria;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.search.xquery.render.ModelAwareReturnClauseGenerator;
import com.vmware.vise.search.xquery.render.RendererFactory;

public final class JoinModelsReturnClauseGenerator
extends ModelAwareReturnClauseGenerator {
    private static final String ORDERED_TARGET_SET_ITER_VAR = "id";

    public JoinModelsReturnClauseGenerator(MetadataDirectory metadataDirectory, RendererFactory rendererFactory, String string) {
        super(metadataDirectory, rendererFactory, string);
    }

    @Override
    protected String createOrderingIterationClause(OrderingCriteria orderingCriteria) {
        return String.format("for $%1$s in $%2$s \n  let $%3$s := //*[%4$s = $%1$s]", ORDERED_TARGET_SET_ITER_VAR, "matchedResourceIds", "target", "@qs:resource");
    }

    @Override
    protected String createOrderingReturnExpr() {
        return new VarRefExpression(ORDERED_TARGET_SET_ITER_VAR).evaluate();
    }

    @Override
    protected String createReturnIterationClause(ResponseSpec responseSpec) {
        boolean bl = responseSpec.orderingCriteria == null;
        String string = bl ? "matchedResourceIds" : this.qualifiedVarName("orderedTargetSet");
        String string2 = this.applyPagingToTargetSet(responseSpec, string);
        String string3 = String.format("let $%s := //*[%s = $%s]", "target", "@qs:resource", "resourceId");
        String string4 = String.format("let $%s := \"\"", "targetDocId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("for $").append("resourceId").append(" in ").append(string2).append("\n  ").append(string3).append("\n  ").append(string4);
        return stringBuilder.toString();
    }
}

