/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.search.QueryContextType;
import com.vmware.vise.search.TypeRef;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.PropertyDescriptorOption;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.FunctionExpression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.PrimaryExpression;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.search.xquery.render.PropertyRenderer;
import com.vmware.vise.util.ValidationUtil;

final class XQueryOrderingPropertyRenderer
implements PropertyRenderer {
    private final TypeRefDirectory _typeRefDirectory;
    private PropertyRenderer.PropertyRendererContext _propertyRendererContext;

    XQueryOrderingPropertyRenderer(TypeRefDirectory typeRefDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeRefDirectory});
        this._typeRefDirectory = typeRefDirectory;
    }

    @Override
    public String render() {
        PropertyDescriptor propertyDescriptor = this._propertyRendererContext.propertyDescriptor;
        String string = this._propertyRendererContext.targetId;
        String string2 = "";
        string2 = "name".equals(propertyDescriptor.getName()) ? MetadataUtil.getQueryExpression(propertyDescriptor, QueryContextType.CONTEXT_CURRENT) : MetadataUtil.getQueryExpression(propertyDescriptor, QueryContextType.CONTEXT_BOUNDED);
        string2 = XQueryUtils.toQualifiedXPath(string, string2);
        PrimaryExpression primaryExpression = new LiteralExpression(string2);
        TypeRef typeRef = this._typeRefDirectory.getTypeRef(propertyDescriptor.getType());
        if (TypeRefUtils.isNumericType(typeRef)) {
            primaryExpression = new FunctionExpression("fn:number", primaryExpression);
        } else if (!TypeRefUtils.isBooleanType(typeRef)) {
            boolean bl;
            String string3 = propertyDescriptor.getTags().get(PropertyDescriptorOption.CASE_SENSITIVE.toString());
            boolean bl2 = bl = string3 != null ? Boolean.parseBoolean(string3) : false;
            if (!bl) {
                primaryExpression = new FunctionExpression("lower-case", primaryExpression);
            }
        }
        return primaryExpression.evaluate();
    }

    @Override
    public PropertyRenderer.PropertyRendererContext getRendererContext() {
        return this._propertyRendererContext;
    }

    @Override
    public void setRendererContext(PropertyRenderer.PropertyRendererContext propertyRendererContext) {
        this._propertyRendererContext = propertyRendererContext;
        XQueryOrderingPropertyRenderer.verifyContext(this._propertyRendererContext);
    }

    private static void verifyContext(PropertyRenderer.PropertyRendererContext propertyRendererContext) {
        if (propertyRendererContext == null) {
            throw new IllegalArgumentException("Context has to be set.");
        }
        if (propertyRendererContext.propertyDescriptor == null) {
            throw new IllegalArgumentException("Context.propertyDescriptor has to be set.");
        }
        if (Strings.isNullOrEmpty(propertyRendererContext.targetId)) {
            throw new IllegalArgumentException("Context.targetId has to be set.");
        }
    }
}

