/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.customprovider;

import com.google.gson.Gson;
import com.vmware.samples.customprovider.ElevationData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoogleService {
    private static final Log _logger = LogFactory.getLog(GoogleService.class);
    private static final String GOOGLE_ELEVATION_URL_PREFIX = "http://maps.googleapis.com/maps/api/elevation/json?locations=";
    public static final String ELEVATION = "Elevation";
    public static final String LATITUDE = "Latitude";
    public static final String LONGITUDE = "Longitude";

    public ElevationData getElevationData(String string, String string2) throws Exception {
        Object object;
        String string3 = String.format("%s%s,%s&sensor=false", GOOGLE_ELEVATION_URL_PREFIX, string, string2);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            _logger.error((Object)malformedURLException);
            throw malformedURLException;
        }
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (Exception exception) {
            _logger.error((Object)("Error opening connection: " + exception));
            throw exception;
        }
        InputStreamReader inputStreamReader = null;
        ApiResult apiResult = null;
        ElevationData elevationData = null;
        try {
            inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            object = new BufferedReader(inputStreamReader);
            Gson gson = new Gson();
            apiResult = (ApiResult)gson.fromJson((Reader)object, ApiResult.class);
        }
        catch (Exception exception) {
            String string4 = "Error getting data from " + uRLConnection + ": " + exception.getMessage() + ". \n\n(A timeout usually means that you need to change your Proxy settings for this sample.)";
            _logger.error((Object)string4);
            throw new Exception(string4);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    _logger.error((Object)("Could not close the stream : " + iOException));
                }
            }
        }
        if (apiResult != null) {
            if (apiResult.status.equals("OK")) {
                elevationData = new ElevationData();
                object = apiResult.results.get(0);
                elevationData.elevation = Double.toString(((ElevationResult)object).elevation);
                elevationData.latitude = Double.toString(((ElevationResult)object).location.lat);
                elevationData.longitude = Double.toString(((ElevationResult)object).location.lng);
                int n = elevationData.elevation.indexOf(46);
                if (n > 0 && n < elevationData.elevation.length() - 2) {
                    elevationData.elevation = elevationData.elevation.substring(0, n + 2);
                }
            } else {
                object = "Error retrieving elevation data at " + string3 + ": " + apiResult.status;
                _logger.error(object);
                throw new Exception((String)object);
            }
        }
        return elevationData;
    }

    private class Location {
        public Double lat;
        public Double lng;

        Location() {
        }
    }

    private class ElevationResult {
        public Double elevation;
        public Location location;

        ElevationResult() {
        }
    }

    private class ApiResult {
        public List<ElevationResult> results;
        public String status;

        ApiResult() {
        }
    }
}

