/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.authn;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class SamlTokenSecurityContext
implements ExecutionContext.SecurityContext {
    public static final String SAML_TOKEN_ID = "samlToken";
    public static final String PRIVATE_KEY_ID = "privateKey";
    private final Map<String, Object> props = new HashMap<String, Object>();

    public SamlTokenSecurityContext(SamlToken token, PrivateKey privateKey) {
        Validate.notNull((Object)token);
        if (token.getConfirmationType() == ConfirmationType.HOLDER_OF_KEY) {
            Validate.notNull((Object)privateKey);
        }
        this.props.put(SAML_TOKEN_ID, token);
        this.props.put(PRIVATE_KEY_ID, privateKey);
        this.props.put("authn_scheme_id", privateKey != null ? "com.vmware.vapi.std.security.saml_hok_token" : "com.vmware.vapi.std.security.saml_bearer_token");
    }

    public SamlTokenSecurityContext(SamlToken token) {
        Validate.notNull((Object)token);
        this.props.put(SAML_TOKEN_ID, token);
        boolean isHok = token.getConfirmationType() == ConfirmationType.HOLDER_OF_KEY;
        this.props.put("authn_scheme_id", isHok ? "com.vmware.vapi.std.security.saml_hok_token" : "com.vmware.vapi.std.security.saml_bearer_token");
    }

    public Object getProperty(String key) {
        Validate.notNull((Object)key);
        return this.props.get(key);
    }

    public Map<String, Object> getAllProperties() {
        return Collections.unmodifiableMap(this.props);
    }
}

