/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.attribute.impl;

import com.vmware.vim.binding.vim.CustomFieldsManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.attribute.CustomAttributeData;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomAttributesFieldPropertyProviderAdapter
implements PropertyProviderAdapter {
    private Log _logger = LogFactory.getLog(CustomAttributesFieldPropertyProviderAdapter.class);
    private static final String CUSTOM_ATTRIBUTES_FIELDS_PROPERTY = "customAttributeFields";
    private static final String ANY_OBJECT_TYPE_PARAMETER = "anyObjectType";

    public CustomAttributesFieldPropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = "*";
        typeInfo.properties = new String[]{CUSTOM_ATTRIBUTES_FIELDS_PROPERTY};
        return new TypeInfo[]{typeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ResultSet resultSet;
        if (propertyRequestSpec == null || propertyRequestSpec.properties == null || propertyRequestSpec.objects == null || propertyRequestSpec.properties.length <= 0 || propertyRequestSpec.objects.length <= 0) {
            this._logger.error((Object)"Requested properties is empty");
            throw new IllegalArgumentException("Request properties is empty.");
        }
        PropertySpec[] propertySpecArray = propertyRequestSpec.properties;
        String[] stringArray = null;
        PropertySpec propertySpec = propertySpecArray[0];
        if (propertySpec.parameters != null && propertySpec.parameters.length > 0) {
            resultSet = propertySpec.parameters[0];
            stringArray = this.getObjectTypesAsStringArray(resultSet.parameter);
        }
        resultSet = new ResultSet();
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (Object object : propertyRequestSpec.objects) {
            Object object2;
            ResultItem resultItem;
            CustomAttributeData[] customAttributeDataArray = new CustomAttributeData[]{};
            if (object instanceof ManagedObjectReference && stringArray != null && stringArray.length > 0) {
                resultItem = (ManagedObjectReference)object;
                object2 = new HashSet();
                for (String string : stringArray) {
                    ArrayList<CustomAttributeData> arrayList2 = this.getCustomAttributeFields((ManagedObjectReference)resultItem, string);
                    object2.addAll(arrayList2);
                }
                customAttributeDataArray = object2.toArray(new CustomAttributeData[0]);
            }
            resultItem = new ResultItem();
            resultItem.resourceObject = object;
            object2 = new PropertyValue();
            ((PropertyValue)object2).resourceObject = object;
            ((PropertyValue)object2).propertyName = CUSTOM_ATTRIBUTES_FIELDS_PROPERTY;
            ((PropertyValue)object2).value = customAttributeDataArray;
            resultItem.properties = new PropertyValue[]{object2};
            arrayList.add(resultItem);
        }
        resultSet.items = arrayList.toArray(new ResultItem[0]);
        return resultSet;
    }

    private String[] getObjectTypesAsStringArray(Object object) {
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            return stringArray;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                String string;
                Object object2 = objectArray[i];
                if (!(object2 instanceof String)) {
                    return null;
                }
                stringArray[i] = string = (String)object2;
            }
            return stringArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        return null;
    }

    private ArrayList<CustomAttributeData> getCustomAttributeFields(ManagedObjectReference managedObjectReference, String string) {
        CustomFieldsManager customFieldsManager = MixedUtil.getCustomFieldManager((ManagedObjectReference)managedObjectReference);
        ArrayList<CustomAttributeData> arrayList = new ArrayList<CustomAttributeData>();
        if (customFieldsManager != null) {
            CustomFieldsManager.FieldDef[] fieldDefArray = customFieldsManager.getField();
            String string2 = customFieldsManager._getRef().getServerGuid();
            for (CustomFieldsManager.FieldDef fieldDef : fieldDefArray) {
                if (fieldDef.managedObjectType != null && fieldDef.managedObjectType.getName() != null && (string == null || !string.equals(ANY_OBJECT_TYPE_PARAMETER) && !fieldDef.managedObjectType.getName().contains(string))) continue;
                CustomAttributeData customAttributeData = new CustomAttributeData();
                customAttributeData.fieldDef = fieldDef;
                customAttributeData.serverGuid = string2;
                arrayList.add(customAttributeData);
            }
        }
        return arrayList;
    }
}

