/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error;

import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.TaskReasonAlarm;
import com.vmware.vim.binding.vim.TaskReasonSchedule;
import com.vmware.vim.binding.vim.TaskReasonUser;
import com.vmware.vim.binding.vim.event.EntityEventArgument;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vim.event.TaskEvent;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.common.error.ErrorReportArgs;
import com.vmware.vsphere.client.common.error.ErrorStack;
import com.vmware.vsphere.client.error.ApplicationException;
import com.vmware.vsphere.client.error.AssistanceData;
import com.vmware.vsphere.client.error.ErrorReportUtil;
import com.vmware.vsphere.client.error.ErrorStackUtil;
import com.vmware.vsphere.client.error.FaultData;
import com.vmware.vsphere.client.error.I18nUtil;
import com.vmware.vsphere.client.error.impl.ErrorStackResolverRegistrar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorReportPage {
    private static final Log _logger = LogFactory.getLog(ErrorReportPage.class);
    private AssistanceData _data = new AssistanceData();
    private final List<NameValuePair> _eventItemList = new ArrayList<NameValuePair>();
    private final List<NameValuePair> _eventDetailList = new ArrayList<NameValuePair>();
    private final List<NameValuePair> _taskItemList = new ArrayList<NameValuePair>();
    private final List<NameValuePair> _taskDetailList = new ArrayList<NameValuePair>();
    private final List<NameValuePair> _faultItemList = new ArrayList<NameValuePair>();
    private final List<NameValuePair> _faultDetailList = new ArrayList<NameValuePair>();
    private final List<String> _stackTrace = new ArrayList<String>();
    private final List<String> _stackTraceTabs = new ArrayList<String>();
    private ErrorStack _errorStack;
    private VcService _service;
    private String _dataXml;
    private ErrorStackResolverRegistrar _errorStackResolverRegistry;

    public ErrorReportPage(String string, ErrorStackResolverRegistrar errorStackResolverRegistrar) {
        this._service = ErrorReportUtil.getService(string);
        this._errorStackResolverRegistry = errorStackResolverRegistrar;
    }

    public List<NameValuePair> getEventItemList() {
        return Collections.unmodifiableList(this._eventItemList);
    }

    public List<NameValuePair> getEventDetailList() {
        return Collections.unmodifiableList(this._eventDetailList);
    }

    public List<NameValuePair> getTaskItemList() {
        return Collections.unmodifiableList(this._taskItemList);
    }

    public List<NameValuePair> getTaskDetailList() {
        return Collections.unmodifiableList(this._taskDetailList);
    }

    public List<NameValuePair> getFaultItemList() {
        return Collections.unmodifiableList(this._faultItemList);
    }

    public List<NameValuePair> getFaultDetailList() {
        return Collections.unmodifiableList(this._faultDetailList);
    }

    public List<String> getStackTrace() {
        return Collections.unmodifiableList(this._stackTrace);
    }

    public List<String> getStackTraceTabs() {
        return Collections.unmodifiableList(this._stackTraceTabs);
    }

    public String getDataXml() {
        if (this._dataXml == null) {
            this._dataXml = this._data.toXml();
        }
        return this._dataXml;
    }

    public String getUrlEncodedData() {
        return ErrorReportUtil.urlEncode(this.getDataXml());
    }

    public ErrorStack getErrorStack() {
        return this._errorStack;
    }

    public static ErrorStack toErrorStack(ErrorStackResolverRegistrar errorStackResolverRegistrar, ErrorReportArgs errorReportArgs) {
        Event event = null;
        int n = 0;
        if (!StringUtil.isNullOrEmpty((String)errorReportArgs.eventId)) {
            n = Integer.parseInt(errorReportArgs.eventId);
        }
        VcService vcService = ErrorReportUtil.getService(errorReportArgs.serverGuid);
        try {
            if (n >= 0) {
                event = ErrorReportUtil.getEvent(vcService, n);
            }
        }
        catch (Exception exception) {
            String string = "Unable to get event info for eventChainId " + errorReportArgs.eventId;
            _logger.error((Object)string, (Throwable)exception);
            throw new IllegalStateException(string, exception);
        }
        TaskInfo taskInfo = null;
        try {
            taskInfo = ErrorReportUtil.getTaskInfo(vcService, errorReportArgs.taskId, n, errorReportArgs.parentTaskId);
        }
        catch (Exception exception) {
            String string = "Unable to get task info for task " + errorReportArgs.taskId;
            _logger.error((Object)string, (Throwable)exception);
            throw new IllegalStateException(string, exception);
        }
        ErrorStack errorStack = ErrorStackUtil.toErrorStack(vcService, errorStackResolverRegistrar, event);
        if (errorStack == null || !errorStack.hasErrorStack()) {
            errorStack = ErrorStackUtil.toErrorStack(vcService, errorStackResolverRegistrar, taskInfo);
        }
        return errorStack;
    }

    public void populateFrom(ErrorReportArgs errorReportArgs) {
        ErrorStack errorStack = ErrorReportPage.toErrorStack(this._errorStackResolverRegistry, errorReportArgs);
        if (errorStack == null) {
            throw new ApplicationException(I18nUtil.text("ErrorMessages.noErrorStack", new String[0]));
        }
        this.populateFromErrorStack(errorStack, errorReportArgs.serverGuid);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Error Report Generated, data:\n" + this.getDataXml()));
        }
    }

    public void populateFromErrorStack(ErrorStack errorStack, String string) {
        this._errorStack = errorStack;
        if (errorStack == null) {
            return;
        }
        Object object = errorStack.source;
        if (object instanceof Event) {
            this.addEventData((Event)object);
        } else if (object instanceof TaskInfo) {
            this.addTaskData((TaskInfo)object);
        } else if (object instanceof MethodFault) {
            this.addFaultData((MethodFault)object);
        } else {
            throw new IllegalArgumentException("Unexpected object type passed to populateFromErrorStack");
        }
        this.addErrorStack(errorStack);
        this.beforeDisplay();
    }

    private void addEventData(Event event) {
        TaskEvent taskEvent = null;
        if (event instanceof TaskEvent) {
            taskEvent = (TaskEvent)event;
        }
        this._data.setSourceType("event");
        if (taskEvent == null) {
            this.addItem(this._eventItemList, I18nUtil.text("ErrorReportPage.event.description", new String[0]), "description", event.fullFormattedMessage);
        }
        this.addItem(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.typeName", new String[0]), "typeName", this.getWsdlName(event));
        this.addItem(this._eventItemList, I18nUtil.text("ErrorReportPage.event.time", new String[0]), "createdTime", event.createdTime);
        if (taskEvent != null) {
            this.addTaskEventData(taskEvent);
        } else {
            this.addServiceBuildInfo(this._eventDetailList);
        }
        if (event.computeResource != null) {
            this.addEntityEventArgument(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.target", new String[0]), "computeResource", (EntityEventArgument)event.computeResource, event.computeResource.computeResource);
        }
        if (event.datacenter != null) {
            this.addEntityEventArgument(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.dataCenter", new String[0]), "datacenter", (EntityEventArgument)event.datacenter, event.datacenter.datacenter);
        }
        if (event.ds != null) {
            this.addEntityEventArgument(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.datastore", new String[0]), "ds", (EntityEventArgument)event.ds, event.ds.datastore);
        }
        if (event.host != null) {
            this.addEntityEventArgument(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.host", new String[0]), "host", (EntityEventArgument)event.host, event.host.host);
            this.addHostBuildInfo(this._eventDetailList, event.host.host);
        }
        if (event.vm != null) {
            this.addEntityEventArgument(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.virtualMachine", new String[0]), "vm", (EntityEventArgument)event.vm, event.vm.vm);
        }
        if (event.dvs != null) {
            this.addEntityEventArgument(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.dvs", new String[0]), "dvs", (EntityEventArgument)event.dvs, event.dvs.dvs);
        }
        if (event.net != null) {
            this.addEntityEventArgument(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.network", new String[0]), "net", (EntityEventArgument)event.net, event.net.network);
        }
        this.addItem(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.chainId", new String[0]), "chainId", event.chainId);
        this.addItem(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.changeTag", new String[0]), "changeTag", event.changeTag);
        if (event instanceof ExtendedEvent) {
            ExtendedEvent extendedEvent = (ExtendedEvent)event;
            this._data.addSourceData("extendedEvent", "true");
            this._data.addSourceData("message", extendedEvent.message);
            this.addItem(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.typeId", new String[0]), "eventTypeId", extendedEvent.eventTypeId);
            if (extendedEvent.managedObject != null) {
                this._data.addSourceData("managedObject", this.formatMO(extendedEvent.managedObject));
            }
        } else if (event instanceof EventEx) {
            EventEx eventEx = (EventEx)event;
            this._data.addSourceData("eventEx", "true");
            this.addItem(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.typeId", new String[0]), "eventTypeId", eventEx.eventTypeId);
            this.addItem(this._eventDetailList, I18nUtil.text("ErrorReportPage.event.severity", new String[0]), "severity", eventEx.severity);
        }
    }

    private String formatMO(ManagedObjectReference managedObjectReference) {
        return managedObjectReference.getType();
    }

    private void addTaskData(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return;
        }
        this._data.setSourceType("task");
        this.addTaskDataImpl(taskInfo, false);
    }

    private void addServiceBuildInfo(List<NameValuePair> list) {
        ServiceInstanceContent serviceInstanceContent = this._service.getServiceInstanceContent();
        AboutInfo aboutInfo = serviceInstanceContent.about;
        this.addItem(list, I18nUtil.text("ErrorReportPage.vcBuild", new String[0]), "serverBuild", aboutInfo.build);
    }

    private void addHostBuildInfo(List<NameValuePair> list, ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            return;
        }
        HostSystem hostSystem = null;
        try {
            hostSystem = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error retrieving MO for " + managedObjectReference.toString()), (Throwable)exception);
        }
        if (hostSystem == null) {
            return;
        }
        AboutInfo aboutInfo = hostSystem.getConfig().getProduct();
        if (aboutInfo == null) {
            return;
        }
        this.addItem(list, I18nUtil.text("ErrorReportPage.hostBuild", new String[0]), "hostBuild", aboutInfo.build);
    }

    private void addTaskEventData(TaskEvent taskEvent) {
        this.addTaskDataImpl(taskEvent.info, true);
    }

    private void addTaskDataImpl(TaskInfo taskInfo, boolean bl) {
        String string;
        String string2 = "";
        if (taskInfo == null) {
            return;
        }
        if (bl) {
            string2 = "info.";
        }
        this.addServiceBuildInfo(this._taskDetailList);
        MethodName methodName = taskInfo.name;
        if (methodName != null) {
            this.addItem(this._taskItemList, I18nUtil.text("ErrorReportPage.task.name", new String[0]), string2 + "name", methodName.getName());
        }
        if (taskInfo.error != null) {
            string = this.getWsdlName(taskInfo.error);
            this.addItem(this._taskItemList, I18nUtil.text("ErrorReportPage.error.status", new String[0]), string2 + "error.message", taskInfo.error.getMessage());
            this.addItem(this._taskDetailList, I18nUtil.text("ErrorReportPage.error.type", new String[0]), string2 + "error.type", string);
        }
        string = taskInfo.description != null ? taskInfo.description.getMessage() : null;
        this.addItem(this._taskItemList, I18nUtil.text("ErrorReportPage.task.description", new String[0]), string2 + "description", string);
        this.addItem(this._taskItemList, I18nUtil.text("ErrorReportPage.task.startTime", new String[0]), string2 + "startTime", taskInfo.startTime);
        this.addItem(this._taskItemList, I18nUtil.text("ErrorReportPage.task.completedTime", new String[0]), string2 + "completeTime", taskInfo.completeTime);
        this.addTaskTarget(taskInfo);
        if (taskInfo.reason instanceof TaskReasonUser) {
            this._data.addSourceData("reason.source", "user");
            if (!bl) {
                // empty if block
            }
        } else if (taskInfo.reason instanceof TaskReasonAlarm) {
            TaskReasonAlarm taskReasonAlarm = (TaskReasonAlarm)taskInfo.reason;
            this._data.addSourceData("reason.source", "alarm");
            this.addManagedObject(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.alarmName", new String[0]), string2 + "reason.alarm", taskReasonAlarm.alarmName, taskReasonAlarm.alarm);
            this.addManagedObject(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.alarmEntity", new String[0]), string2 + "reason.entity", taskReasonAlarm.entityName, taskReasonAlarm.entity);
        } else if (taskInfo.reason instanceof TaskReasonSchedule) {
            TaskReasonSchedule taskReasonSchedule = (TaskReasonSchedule)taskInfo.reason;
            this._data.addSourceData("reason.source", "scheduledTask");
            this.addManagedObject(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.scheduledTask", new String[0]), string2 + "reason.scheduledTask", taskReasonSchedule.name, taskReasonSchedule.scheduledTask);
        }
        if (!bl) {
            this.addItem(this._taskItemList, I18nUtil.text("ErrorReportPage.task.state", new String[0]), string2 + "state", taskInfo.state);
        }
        if (taskInfo.task != null) {
            this.addItem(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.id", new String[0]), string2 + "task", this.formatMO(taskInfo.task));
        }
        this.addItem(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.cancelable", new String[0]), string2 + "cancelable", taskInfo.cancelable);
        this.addItem(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.canceled", new String[0]), string2 + "cancelled", taskInfo.cancelled);
        this.addItem(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.changeTag", new String[0]), string2 + "changeTag", taskInfo.changeTag);
        this.addItem(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.descriptionId", new String[0]), string2 + "descriptionId", taskInfo.descriptionId);
        this.addItem(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.eventChainId", new String[0]), string2 + "eventChainId", taskInfo.eventChainId);
        if (taskInfo.progress != null) {
            this.addItem(this._taskDetailList, I18nUtil.text("ErrorReportPage.task.progress", new String[0]), string2 + "progress", taskInfo.progress);
        }
    }

    private void addTaskTarget(TaskInfo taskInfo) {
        if (taskInfo.entity != null) {
            this._data.addSourceData("entity.managedEntity", this.formatMO(taskInfo.entity));
        }
    }

    private void addFaultData(MethodFault methodFault) {
        if (methodFault == null) {
            return;
        }
        this._data.setSourceType("fault");
        this.addServiceBuildInfo(this._faultDetailList);
        String string = this.getWsdlName(methodFault);
        this.addItem(this._faultItemList, I18nUtil.text("ErrorReportPage.error.status", new String[0]), "error.message", methodFault.getMessage());
        this.addItem(this._faultDetailList, I18nUtil.text("ErrorReportPage.error.type", new String[0]), "error.type", string);
    }

    private String getWsdlName(Object object) {
        wsdlName wsdlName2 = object.getClass().getAnnotation(wsdlName.class);
        return wsdlName2.value();
    }

    private void addErrorStack(ErrorStack errorStack) {
        String string = "";
        this.addErrorMessages(string, errorStack);
        this.addErrorCause(string, errorStack);
        this._data.setFaultData(new FaultData(errorStack));
    }

    private void addErrorCause(String string, ErrorStack errorStack) {
        if (errorStack.cause == null) {
            return;
        }
        string = string + "&nbsp;&nbsp;";
        for (ErrorStack errorStack2 : errorStack.cause) {
            MethodFault methodFault = errorStack.fault;
            if (methodFault != null) {
                this._stackTrace.add(methodFault.getMessage());
                this._stackTraceTabs.add(string);
            }
            this.addErrorMessages(string, errorStack2);
            this.addErrorCause(string, errorStack2);
        }
    }

    private void addErrorMessages(String string, ErrorStack errorStack) {
        if (errorStack.messages == null) {
            return;
        }
        for (LocalizableMessage localizableMessage : errorStack.messages) {
            this._stackTrace.add(localizableMessage.getMessage());
            this._stackTraceTabs.add(string);
        }
    }

    private void addItem(List<NameValuePair> list, String string, String string2, Object object) {
        this.addItem(list, string, string2, object, null);
    }

    private void addItem(List<NameValuePair> list, String string, String string2, Object object, String string3) {
        if (object == null) {
            return;
        }
        String string4 = ErrorReportUtil.formatForDisplay(object);
        if (string4.isEmpty()) {
            return;
        }
        if (StringUtil.isNullOrEmpty((String)string3)) {
            string3 = string4;
        }
        NameValuePair nameValuePair = new NameValuePair();
        nameValuePair.name = string;
        nameValuePair.value = string3;
        list.add(nameValuePair);
        this._data.addSourceData(string2, object);
    }

    private void addEntityEventArgument(List<NameValuePair> list, String string, String string2, EntityEventArgument entityEventArgument, ManagedObjectReference managedObjectReference) {
        if (entityEventArgument == null) {
            return;
        }
        if (StringUtil.isNullOrEmpty((String)entityEventArgument.name)) {
            return;
        }
        this.addManagedObject(list, string, string2, entityEventArgument.name, managedObjectReference);
    }

    private void addManagedObject(List<NameValuePair> list, String string, String string2, String string3, ManagedObjectReference managedObjectReference) {
        if (StringUtil.isNullOrEmpty((String)string3)) {
            return;
        }
        if (managedObjectReference != null) {
            this.addItem(list, I18nUtil.formatPageGuid(string), string2 + ".managedEntity", this.formatMO(managedObjectReference));
        }
    }

    protected void beforeDisplay() {
        _logger.debug((Object)("Submit Error Report - VOB Dump: " + this._data.toLogString()));
    }
}

