/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error;

import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vsphere.client.common.error.ErrorStack;
import com.vmware.vsphere.client.error.StackMessage;
import com.vmware.vsphere.client.error.xml.XmlArray;
import com.vmware.vsphere.client.error.xml.XmlElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XmlElement(value="FaultData")
public class FaultData {
    private List<StackMessage> _messageInfo = new ArrayList<StackMessage>();
    private String _faultTypeName;
    private List<FaultData> _cause = new ArrayList<FaultData>();

    public FaultData() {
    }

    public FaultData(ErrorStack errorStack) {
        if (errorStack == null) {
            return;
        }
        if (errorStack.fault != null) {
            this._faultTypeName = errorStack.fault.getClass().getName();
        }
        if (errorStack.messages != null) {
            for (LocalizableMessage localizableMessage : errorStack.messages) {
                this.addMessage(localizableMessage);
            }
        }
        if (errorStack.cause != null) {
            for (LocalizableMessage localizableMessage : errorStack.cause) {
                this.addCause((ErrorStack)localizableMessage);
            }
        }
    }

    @XmlElement(value="FaultTypeName")
    public String getFaultTypeName() {
        return this._faultTypeName;
    }

    @XmlArray(value="MessageInfo")
    public List<StackMessage> getMessageInfo() {
        return Collections.unmodifiableList(this._messageInfo);
    }

    public void addMessage(LocalizableMessage localizableMessage) {
        if (localizableMessage == null) {
            return;
        }
        this._messageInfo.add(new StackMessage(localizableMessage));
    }

    @XmlArray(value="Cause")
    public List<FaultData> getCause() {
        return Collections.unmodifiableList(this._cause);
    }

    public void addCause(ErrorStack errorStack) {
        if (errorStack == null) {
            return;
        }
        this._cause.add(new FaultData(errorStack));
    }

    public void toLogDataString(String string, StringBuilder stringBuilder) {
        for (StackMessage object : this._messageInfo) {
            stringBuilder.append(string);
            object.toLogDataString(stringBuilder);
        }
        String string2 = string + "  ";
        for (FaultData faultData : this._cause) {
            stringBuilder.append(string + "Cause:" + "\n");
            faultData.toLogDataString(string2, stringBuilder);
        }
    }
}

