/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error.impl;

import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.common.error.ErrorReportArgs;
import com.vmware.vsphere.client.common.error.ErrorReportData;
import com.vmware.vsphere.client.common.error.ErrorReportService;
import com.vmware.vsphere.client.common.error.ErrorStack;
import com.vmware.vsphere.client.error.ErrorReportPage;
import com.vmware.vsphere.client.error.ErrorStackUtil;
import com.vmware.vsphere.client.error.impl.ErrorStackResolverRegistrar;

public class ErrorReportServiceImpl
implements ErrorReportService {
    private ErrorStackResolverRegistrar _errorStackResolvers;

    public ErrorReportServiceImpl(ErrorStackResolverRegistrar errorStackResolverRegistrar) {
        this._errorStackResolvers = errorStackResolverRegistrar;
    }

    public ErrorReportData getReportData(ErrorReportArgs errorReportArgs) {
        ErrorReportPage errorReportPage = new ErrorReportPage(errorReportArgs.serverGuid, this._errorStackResolvers);
        errorReportPage.populateFrom(errorReportArgs);
        ErrorReportData errorReportData = new ErrorReportData();
        errorReportData.eventItemList = errorReportPage.getEventItemList().toArray(new NameValuePair[0]);
        errorReportData.eventDetailList = errorReportPage.getEventDetailList().toArray(new NameValuePair[0]);
        errorReportData.taskItemList = errorReportPage.getTaskItemList().toArray(new NameValuePair[0]);
        errorReportData.taskDetailList = errorReportPage.getTaskDetailList().toArray(new NameValuePair[0]);
        errorReportData.faultItemList = errorReportPage.getFaultItemList().toArray(new NameValuePair[0]);
        errorReportData.faultDetailList = errorReportPage.getFaultDetailList().toArray(new NameValuePair[0]);
        errorReportData.errorStack = errorReportPage.getErrorStack();
        errorReportData.stackTrace = errorReportPage.getStackTrace().toArray(new String[0]);
        errorReportData.stackTraceTabs = errorReportPage.getStackTraceTabs().toArray(new String[0]);
        errorReportData.urlEncodedData = errorReportPage.getUrlEncodedData();
        return errorReportData;
    }

    public ErrorStack getErrorStack(ErrorReportArgs errorReportArgs) {
        return ErrorReportPage.toErrorStack(this._errorStackResolvers, errorReportArgs);
    }

    public ErrorStack toErrorStack(VcService vcService, Object object) {
        return ErrorStackUtil.toErrorStack(vcService, this._errorStackResolvers, object);
    }
}

