/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error.xml;

import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.error.xml.XmlArray;
import com.vmware.vsphere.client.error.xml.XmlAttribute;
import com.vmware.vsphere.client.error.xml.XmlElement;
import com.vmware.vsphere.client.error.xml.XmlRoot;
import com.vmware.vsphere.client.error.xml.XmlText;
import java.io.StringWriter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XmlSerializer {
    private Document _xmlDoc;

    public XmlSerializer() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this._xmlDoc = documentBuilder.newDocument();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toXML() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            try {
                transformerFactory.setAttribute("indent-number", new Integer(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException(transformerConfigurationException);
        }
        transformer.setOutputProperty("indent", "yes");
        DOMSource dOMSource = new DOMSource(this._xmlDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        return stringWriter.toString();
    }

    public static String toXML(Object object) {
        XmlSerializer xmlSerializer = new XmlSerializer();
        xmlSerializer.encode(object, "root");
        return xmlSerializer.toXML();
    }

    public Element encode(Object object, String string) {
        return this.encodeValue(object, string, null);
    }

    private Element encodeValue(Object object, String string, Element element) {
        Element element2 = null;
        if (object == null) {
            return null;
        }
        TypeCode typeCode = this.getDataTypeFromObject(object);
        XmlRoot xmlRoot = object.getClass().getAnnotation(XmlRoot.class);
        if (xmlRoot != null && !StringUtil.isNullOrEmpty((String)xmlRoot.value())) {
            string = xmlRoot.value();
        }
        element2 = this._xmlDoc.createElement(string);
        if (element == null) {
            this._xmlDoc.appendChild(element2);
        } else {
            element.appendChild(element2);
        }
        if (typeCode == TypeCode.ObjectType) {
            this.encodeObjectProperties(object, element2);
        } else if (typeCode == TypeCode.ArrayType) {
            this.encodeListElements(object, element2, null);
        } else {
            String string2 = object.toString();
            Text text = this._xmlDoc.createTextNode(string2);
            element2.appendChild(text);
        }
        return element2;
    }

    private void encodeListElements(Object object, Element element, String string) {
        Object object2;
        Object object3;
        if (string == null) {
            string = "item";
        }
        if (object == null) {
            return;
        }
        Object object4 = null;
        if (object instanceof List) {
            object4 = (List)object;
        } else if (object.getClass().isArray()) {
            object3 = new ArrayList();
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                object2 = Array.get(object, i);
                object3.add(object2.toString());
            }
            object4 = object3;
        } else {
            throw new RuntimeException("Unexpected type " + object.getClass().getName());
        }
        object3 = object4.iterator();
        while (object3.hasNext()) {
            Object e = object3.next();
            if (e == null) continue;
            XmlElement xmlElement = e.getClass().getAnnotation(XmlElement.class);
            object2 = string;
            if (xmlElement != null && !StringUtil.isNullOrEmpty((String)xmlElement.value())) {
                object2 = xmlElement.value();
            }
            this.encodeValue(e, (String)object2, element);
        }
    }

    private void encodeObjectProperties(Object object, Element element) {
        Method[] methodArray;
        for (Method method : methodArray = object.getClass().getMethods()) {
            String string = method.getName();
            if (!string.startsWith("get") || string.equals("getClass")) continue;
            boolean bl = method.getAnnotations().length > 0;
            String string2 = String.format("%c%s", Character.valueOf(Character.toLowerCase(string.charAt(3))), string.substring(4));
            Object object2 = null;
            try {
                object2 = method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error invoking " + string + " on " + object.getClass().getName(), exception);
            }
            if (object2 == null) continue;
            if (!bl) {
                this.encodeValue(object2, string2, element);
                continue;
            }
            this.encodeObjectProperty(method, string2, object2, element);
        }
    }

    private void encodeObjectProperty(AnnotatedElement annotatedElement, String string, Object object, Element element) {
        TypeCode typeCode = this.getDataTypeFromObject(object);
        XmlElement xmlElement = annotatedElement.getAnnotation(XmlElement.class);
        if (xmlElement != null && !StringUtil.isNullOrEmpty((String)xmlElement.value())) {
            string = xmlElement.value();
        }
        if (typeCode == TypeCode.ArrayType) {
            if (xmlElement != null) {
                this.encodeListElements(object, element, string);
                return;
            }
            XmlArray xmlArray = annotatedElement.getAnnotation(XmlArray.class);
            if (xmlArray != null && !StringUtil.isNullOrEmpty((String)xmlArray.value())) {
                string = xmlArray.value();
            }
        } else if (typeCode == TypeCode.StringType || typeCode == TypeCode.NumberType || typeCode == TypeCode.BooleanType || typeCode == TypeCode.IntegerType) {
            boolean bl;
            String string2 = object.toString();
            boolean bl2 = bl = annotatedElement.getAnnotation(XmlText.class) != null;
            if (bl) {
                Text text = this._xmlDoc.createTextNode(string2);
                element.appendChild(text);
                return;
            }
            XmlAttribute xmlAttribute = annotatedElement.getAnnotation(XmlAttribute.class);
            String string3 = null;
            if (xmlAttribute != null) {
                string3 = xmlAttribute.value();
            }
            if (!StringUtil.isNullOrEmpty(string3)) {
                element.setAttribute(string3, string2);
                return;
            }
        }
        this.encodeValue(object, string, element);
    }

    private TypeCode getDataTypeFromObject(Object object) {
        if (object instanceof Number) {
            return TypeCode.NumberType;
        }
        if (object instanceof Integer) {
            return TypeCode.IntegerType;
        }
        if (object instanceof Boolean) {
            return TypeCode.BooleanType;
        }
        if (object instanceof String) {
            return TypeCode.StringType;
        }
        if (object instanceof Date || object instanceof Calendar) {
            return TypeCode.DateType;
        }
        if (object instanceof List) {
            return TypeCode.ArrayType;
        }
        if (object.getClass().isArray()) {
            return TypeCode.ArrayType;
        }
        if (object instanceof Object) {
            return TypeCode.ObjectType;
        }
        return TypeCode.StringType;
    }

    private static enum TypeCode {
        NumberType,
        IntegerType,
        BooleanType,
        StringType,
        ObjectType,
        DateType,
        XMLType,
        ArrayType;

    }
}

