/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.mixed.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedEntityParentLocatorImpl
implements ManagedEntityParentLocator {
    private static final Log _logger = LogFactory.getLog(ManagedEntityParentLocatorImpl.class);
    private static final String PARENT = "parent";
    private static final String PARENT_NAME = "parentName";
    private static final String[] PARENT_INFO_PROPERTIES = new String[]{"parent", "parentName"};
    private final DataService _dataService;
    private final QuerySpecBuilder _querySpecBuilder;

    public ManagedEntityParentLocatorImpl(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        Validate.notNull((Object)dataService);
        Validate.notNull((Object)querySpecBuilder);
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
    }

    @Override
    public Map<ManagedObjectReference, OperationResult> locateCustomParents(ManagedObjectReference ... managedObjectReferenceArray) {
        if (ArrayUtils.isEmpty((Object[])managedObjectReferenceArray)) {
            return Collections.emptyMap();
        }
        Set<ManagedObjectReference> set = ManagedEntityParentLocatorImpl.retainEntitiesWithType(managedObjectReferenceArray, Folder.class, ResourcePool.class);
        if (set.isEmpty()) {
            return Collections.emptyMap();
        }
        List<ResultItem> list = this.getResults(set);
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<ManagedObjectReference, OperationResult> map = ManagedEntityParentLocatorImpl.processResult(list);
        return map;
    }

    private List<ResultItem> getResults(Set<ManagedObjectReference> set) {
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(set.toArray(), PARENT_INFO_PROPERTIES);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        Object[] objectArray = response.resultSet;
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return Collections.emptyList();
        }
        Object object = objectArray[0];
        if (object == null) {
            return Collections.emptyList();
        }
        if (((ResultSet)object).error != null) {
            _logger.error((Object)"Error while retrieving non-host parent items.", (Throwable)((ResultSet)object).error);
        }
        if (ArrayUtils.isEmpty((Object[])((ResultSet)object).items)) {
            return Collections.emptyList();
        }
        return Arrays.asList(((ResultSet)object).items);
    }

    private static Map<ManagedObjectReference, OperationResult> processResult(List<ResultItem> list) {
        HashMap<ManagedObjectReference, OperationResult> hashMap = new HashMap<ManagedObjectReference, OperationResult>();
        for (ResultItem resultItem : list) {
            OperationResult operationResult;
            OperationResult operationResult2 = new OperationResult();
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)resultItem.resourceObject;
            Object object = ManagedEntityParentLocatorImpl.extractValueFrom(resultItem, PARENT);
            if (object != null) {
                operationResult2.entity = object;
                operationResult2.result = ManagedEntityParentLocatorImpl.extractValueFrom(resultItem, PARENT_NAME);
            } else {
                operationResult2.entity = managedObjectReference;
            }
            if ((operationResult = hashMap.put(managedObjectReference, operationResult2)) == null) continue;
            _logger.warn((Object)("Ambiguous parent results for morRef: " + managedObjectReference));
        }
        return hashMap;
    }

    @Override
    public boolean customParentRelated(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) {
        if (managedObjectReference == null || managedObjectReference2 == null) {
            return false;
        }
        if (ManagedEntityParentLocatorImpl.isOfType(managedObjectReference, Folder.class) && ManagedEntityParentLocatorImpl.isOfType(managedObjectReference2, Datacenter.class)) {
            return true;
        }
        return ManagedEntityParentLocatorImpl.isOfType(managedObjectReference, ResourcePool.class) && (ManagedEntityParentLocatorImpl.isOfType(managedObjectReference2, ClusterComputeResource.class) || ManagedEntityParentLocatorImpl.isOfType(managedObjectReference2, ComputeResource.class));
    }

    private static Object extractValueFrom(ResultItem resultItem, String string) {
        for (PropertyValue propertyValue : resultItem.properties) {
            if (!propertyValue.propertyName.equals(string)) continue;
            return propertyValue.value;
        }
        return null;
    }

    private static Set<ManagedObjectReference> retainEntitiesWithType(ManagedObjectReference[] managedObjectReferenceArray, Class<?> ... classArray) {
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        for (ManagedObjectReference managedObjectReference : managedObjectReferenceArray) {
            for (Class<?> clazz : classArray) {
                if (!ManagedEntityParentLocatorImpl.isOfType(managedObjectReference, clazz)) continue;
                hashSet.add(managedObjectReference);
            }
        }
        return hashSet;
    }

    private static boolean isOfType(ManagedObjectReference managedObjectReference, Class<?> clazz) {
        boolean bl = ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, (String)clazz.getAnnotation(wsdlName.class).value());
        return bl;
    }
}

