/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.mixed.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParentPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(ParentPropertyProviderAdapter.class);
    private static final String PARENT_RELATIONSHIP = "parent";
    private static final String PARENT_NAME_PROPERTY = "parentName";
    private static final String PRIMARY_ICON_FOR_PARENT_PROPERTY = "parentPrimaryIconId";
    private static final String MANAGED_OBJECT_NAME_PROPERTY = "name";
    private static final String MANAGED_OBJECT_PRIMARY_ICON_PROPERTY = "primaryIconId";
    private final DataService _dataService;

    public ParentPropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, DataService dataService) {
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = Datacenter.class.getSimpleName();
        typeInfo.properties = new String[]{PARENT_NAME_PROPERTY, PRIMARY_ICON_FOR_PARENT_PROPERTY};
        return new TypeInfo[]{typeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ResultSet resultSet = new ResultSet();
        try {
            ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
            Object[] objectArray = propertyRequestSpec.objects;
            Object[] objectArray2 = propertyRequestSpec.properties;
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || ArrayUtil.isNullOrEmpty((Object[])objectArray2)) {
                throw new IllegalArgumentException("Request should contain at least one object and at least one property!");
            }
            List<ResultItem> list = this.getAliasedProperties(objectArray, (PropertySpec[])objectArray2);
            resultSet.items = (ResultItem[])ArrayUtil.toArray(list, ResultItem.class);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            resultSet.error = exception;
        }
        return resultSet;
    }

    private final List<ResultItem> getAliasedProperties(Object[] objectArray, PropertySpec[] propertySpecArray) throws Exception {
        PropertyValue[] propertyValueArray = QueryUtil.getProperty((DataService)this._dataService, (Object[])objectArray, (String)PARENT_RELATIONSHIP);
        Map<Object, Set<Object>> map = ParentPropertyProviderAdapter.mapChildrenToParent(propertyValueArray);
        ResultSet resultSet = this.getParentProps(map.keySet().toArray(), propertySpecArray);
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        if (resultSet == null || ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            return arrayList;
        }
        for (ResultItem resultItem : resultSet.items) {
            if (resultItem == null || resultItem.resourceObject == null) {
                _logger.warn((Object)"Data for some parent properties may not be retrieved!");
                continue;
            }
            Set<Object> set = map.get(resultItem.resourceObject);
            for (Object object : set) {
                ResultItem resultItem2 = new ResultItem();
                resultItem2.resourceObject = object;
                resultItem2.properties = ParentPropertyProviderAdapter.createChildPropValues(resultItem.properties, object);
                arrayList.add(resultItem2);
            }
        }
        return arrayList;
    }

    private static final Map<Object, Set<Object>> mapChildrenToParent(PropertyValue[] propertyValueArray) {
        HashMap<Object, Set<Object>> hashMap = new HashMap<Object, Set<Object>>(propertyValueArray.length);
        for (PropertyValue propertyValue : propertyValueArray) {
            Set<Object> set;
            if (propertyValue == null || propertyValue.resourceObject == null || propertyValue.value == null) {
                _logger.warn((Object)"Some parent objects may not be retrieved!");
                continue;
            }
            Object object = propertyValue.value;
            Object object2 = propertyValue.resourceObject;
            if (!hashMap.containsKey(object)) {
                set = new HashSet();
                hashMap.put(object, set);
            } else {
                set = (Set)hashMap.get(object);
            }
            set.add(object2);
        }
        return hashMap;
    }

    private final ResultSet getParentProps(Object[] objectArray, PropertySpec[] propertySpecArray) throws Exception {
        PropertySpec propertySpec;
        int constraint;
        HashSet<String> hashSet = new HashSet<String>();
        PropertySpec[] objectArray2 = propertySpecArray;
        int constraintArray = objectArray2.length;
        for (constraint = 0; constraint < constraintArray; ++constraint) {
            propertySpec = objectArray2[constraint];
            for (String string : propertySpec.propertyNames) {
                hashSet.add(ParentPropertyProviderAdapter.findPropertyForAlias(string));
            }
        }
        String[] stringArray = (String[])ArrayUtil.toArray(new ArrayList(hashSet), String.class);
        Constraint[] constraintArray2 = new Constraint[objectArray.length];
        for (constraint = 0; constraint < objectArray.length; ++constraint) {
            propertySpec = QueryUtil.createObjectIdentityConstraint((Object)objectArray[constraint]);
            constraintArray2[constraint] = propertySpec;
        }
        Constraint constraint2 = QueryUtil.combineIntoSingleConstraint((Constraint[])constraintArray2, (Conjoiner)Conjoiner.OR);
        propertySpec = QueryUtil.buildQuerySpec((Constraint)constraint2, (String[])stringArray);
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)propertySpec);
        return resultSet;
    }

    private static final PropertyValue[] createChildPropValues(PropertyValue[] propertyValueArray, Object object) {
        PropertyValue[] propertyValueArray2 = new PropertyValue[propertyValueArray.length];
        for (int i = 0; i < propertyValueArray.length; ++i) {
            PropertyValue propertyValue = propertyValueArray[i];
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.resourceObject = object;
            propertyValue2.propertyName = ParentPropertyProviderAdapter.findAliasForProperty(propertyValue.propertyName);
            propertyValue2.value = propertyValue.value;
            propertyValueArray2[i] = propertyValue2;
        }
        return propertyValueArray2;
    }

    private static final String findAliasForProperty(String string) {
        if (MANAGED_OBJECT_NAME_PROPERTY.equals(string)) {
            return PARENT_NAME_PROPERTY;
        }
        if (MANAGED_OBJECT_PRIMARY_ICON_PROPERTY.equals(string)) {
            return PRIMARY_ICON_FOR_PARENT_PROPERTY;
        }
        return string;
    }

    private static final String findPropertyForAlias(String string) {
        if (PARENT_NAME_PROPERTY.equals(string)) {
            return MANAGED_OBJECT_NAME_PROPERTY;
        }
        if (PRIMARY_ICON_FOR_PARENT_PROPERTY.equals(string)) {
            return MANAGED_OBJECT_PRIMARY_ICON_PROPERTY;
        }
        return string;
    }
}

