/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.navigator.impl;

import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.messaging.CdcProcessor;
import com.vmware.vise.vim.commons.messaging.NavTreeUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import com.vmware.vsphere.client.iconslabels.IconsLabelsPropertyProviderAdapter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavTreeUpdatesProcessor
implements CdcProcessor<NavTreeUpdate> {
    private static final Log _logger = LogFactory.getLog(NavTreeUpdatesProcessor.class);
    private IconsLabelsPropertyProviderAdapter iconLabelAdapter;
    private static final String CHILD_ENTITY = "childEntity";
    private static final String VM_PROP = "vm";
    private static final String NAME_PROPERTY = "name";
    private static final String RESOURCE_POOL_PROPERTY = "resourcePool";
    private static final String HOST_PROPERTY = "host";
    private static final String PORTGROUP_PROPERTY = "portgroup";
    private static final String PARENT_PROPERTY = "parent";
    private static final String PARENT_FOLDER_PROPERTY = "parentFolder";
    private static final String VM_TEMPLATE_PROPERTY = "config.template";
    private static final String ESCAPED_BRACKET = "\\[";
    private static final String COMPUTE_RESOURCE = ComputeResource.class.getSimpleName();
    private static final String VIRTUAL_MACHINE = VirtualMachine.class.getSimpleName();
    private Map<String, Map<String, String>> iconProps;
    private Map<String, Map<String, String>> labelProps;

    public NavTreeUpdatesProcessor(IconsLabelsPropertyProviderAdapter iconsLabelsPropertyProviderAdapter) {
        this.iconLabelAdapter = iconsLabelsPropertyProviderAdapter;
        this.iconProps = new HashMap<String, Map<String, String>>();
        this.labelProps = new HashMap<String, Map<String, String>>();
        this.initProperties();
    }

    private void initProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("runtime", "runtime.inMaintenanceMode");
        this.labelProps.put("HostSystem", hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("config.ftinfo.role", "ftRole");
        this.iconProps.put("VirtualMachine", hashMap2);
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        hashMap3.put("runtime", "runtime.inMaintenanceMode");
        this.iconProps.put("HostSystem", hashMap3);
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        hashMap4.put("summary.vAppState", "powerState");
        hashMap4.put("summary.suspended", "isSuspended");
        hashMap4.put("summary", "isSuspended");
        hashMap4.put("summary", "powerState");
        this.iconProps.put("VirtualApp", hashMap4);
        HashMap<String, String> hashMap5 = new HashMap<String, String>();
        hashMap5.put("isUplinkPortgroup", "tag");
        this.iconProps.put("DistributedVirtualPortgroup", hashMap5);
        this.iconProps = Collections.unmodifiableMap(this.iconProps);
    }

    public PartialUpdate<NavTreeUpdate> process(List<ResourceChange> list) {
        PartialUpdate partialUpdate = PartialUpdate.empty();
        if (list == null || list.isEmpty()) {
            return partialUpdate;
        }
        HashMap<ManagedObjectReference, Set<String>> hashMap = new HashMap<ManagedObjectReference, Set<String>>();
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> hashSet2 = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> hashSet3 = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> hashSet4 = new HashSet<ManagedObjectReference>();
        for (ResourceChange object : list) {
            Object object2 = object.getResource();
            ManagedObjectReference managedObjectReference = null;
            if (object2 instanceof String) {
                object2 = VapiUriSchemeUtil.createUri((String)object.getResourceType(), (String)((String)object.getResource()));
            } else if (object2 instanceof ManagedObjectReference) {
                managedObjectReference = (ManagedObjectReference)object2;
            }
            if (object.getKind() == ResourceChange.Kind.CREATE) {
                if (managedObjectReference != null) {
                    if (COMPUTE_RESOURCE.equals(managedObjectReference.getType())) continue;
                    hashSet.add(managedObjectReference);
                    continue;
                }
                partialUpdate.updates.add(this.createParentUpdate(object2));
                continue;
            }
            if (object.getKind() == ResourceChange.Kind.DELETE) {
                partialUpdate.updates.add(this.createObjectDeleted(object2));
                continue;
            }
            if (object.getKind() == ResourceChange.Kind.UPDATE) {
                if (!(object2 instanceof ManagedObjectReference)) continue;
                this.addUpdates((PartialUpdate<NavTreeUpdate>)partialUpdate, object, (ManagedObjectReference)object2, hashMap, hashSet, hashSet2, hashSet3, hashSet4);
                continue;
            }
            _logger.error((Object)("[LiveRefresh] NavTree error: Unknown kind: " + object.getKind()));
        }
        for (ManagedObjectReference managedObjectReference : hashSet) {
            partialUpdate.updates.add(this.createParentUpdate(managedObjectReference));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            partialUpdate.updates.add(this.createChildrenUpdate(entry));
        }
        for (ManagedObjectReference managedObjectReference : hashSet2) {
            partialUpdate.updates.add(this.createPropertiesUpdate(managedObjectReference, hashSet3, hashSet4));
        }
        return partialUpdate;
    }

    private PartialUpdateItem<NavTreeUpdate> createParentUpdate(Object object) {
        return PartialUpdateItem.of((Object)new NavTreeUpdate(2), (Object)object);
    }

    private PartialUpdateItem<NavTreeUpdate> createChildrenUpdate(Map.Entry<ManagedObjectReference, Set<String>> entry) {
        NavTreeUpdate navTreeUpdate = new NavTreeUpdate(1);
        navTreeUpdate.childrenProperties = entry.getValue().toArray(new String[0]);
        return PartialUpdateItem.of((Object)navTreeUpdate, (Object)entry.getKey());
    }

    private PartialUpdateItem<NavTreeUpdate> createObjectDeleted(Object object) {
        return PartialUpdateItem.of((Object)new NavTreeUpdate(3), (Object)object);
    }

    private PartialUpdateItem<NavTreeUpdate> createPropertiesUpdate(Object object, Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2) {
        if (set.contains(object)) {
            return PartialUpdateItem.of((Object)new NavTreeUpdate.Builder(0).isNameUpdate(true).build(), (Object)object);
        }
        if (set2.contains(object)) {
            return PartialUpdateItem.of((Object)new NavTreeUpdate.Builder(0).isTemplate(true).build(), (Object)object);
        }
        return PartialUpdateItem.of((Object)new NavTreeUpdate(0), (Object)object);
    }

    private void addUpdates(PartialUpdate<NavTreeUpdate> partialUpdate, ResourceChange resourceChange, ManagedObjectReference managedObjectReference, Map<ManagedObjectReference, Set<String>> map, Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2, Set<ManagedObjectReference> set3, Set<ManagedObjectReference> set4) {
        if (resourceChange.getProperties() == null || resourceChange.getProperties().isEmpty()) {
            return;
        }
        String string = resourceChange.getResourceType();
        for (String string2 : resourceChange.getProperties()) {
            Object object;
            boolean bl;
            String string3;
            if (NAME_PROPERTY.equals(string2)) {
                set2.add(managedObjectReference);
                set3.add(managedObjectReference);
            } else if (VM_TEMPLATE_PROPERTY.equals(string2)) {
                set2.add(managedObjectReference);
                set4.add(managedObjectReference);
            } else {
                string3 = this.translateLabel(string, string2);
                if (this.iconLabelAdapter.isLabelProperty(string, string3)) {
                    set2.add(managedObjectReference);
                } else {
                    String string4 = this.translateIcon(string, string2);
                    if (this.iconLabelAdapter.isIconProperty(string, string4)) {
                        set2.add(managedObjectReference);
                    }
                }
            }
            string3 = managedObjectReference.getType();
            boolean bl2 = bl = VIRTUAL_MACHINE.equals(string3) || COMPUTE_RESOURCE.equals(string3);
            if (!bl && (string2.startsWith(RESOURCE_POOL_PROPERTY) || string2.startsWith(VM_PROP) || string2.startsWith(CHILD_ENTITY) || string2.startsWith(HOST_PROPERTY) || string2.startsWith(PORTGROUP_PROPERTY))) {
                object = map.get(managedObjectReference);
                if (object == null) {
                    object = new HashSet();
                    map.put(managedObjectReference, (Set<String>)object);
                }
                object.add(string2.split(ESCAPED_BRACKET)[0]);
            }
            if (!PARENT_PROPERTY.equals(string2) && !PARENT_FOLDER_PROPERTY.equals(string2) && (!RESOURCE_POOL_PROPERTY.equals(string2) || !VIRTUAL_MACHINE.equals(managedObjectReference.getType())) || (object = this.extractUpdatedObject(managedObjectReference, string2)) == null) continue;
            set.add((ManagedObjectReference)object);
        }
    }

    private ManagedObjectReference extractUpdatedObject(ManagedObjectReference managedObjectReference, String string) {
        ManagedObjectReference managedObjectReference2 = managedObjectReference;
        if (COMPUTE_RESOURCE.equals(managedObjectReference.getType())) {
            if (PARENT_PROPERTY.equals(string)) {
                try {
                    ComputeResource computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
                    ManagedObjectReference[] managedObjectReferenceArray = computeResource.getHost();
                    if (managedObjectReferenceArray != null && managedObjectReferenceArray.length > 0) {
                        managedObjectReference2 = managedObjectReferenceArray[0];
                    }
                }
                catch (Exception exception) {
                    _logger.error((Object)"Error getting host:", (Throwable)exception);
                    managedObjectReference2 = null;
                }
            } else {
                managedObjectReference2 = null;
            }
        }
        return managedObjectReference2;
    }

    private String translateLabel(String string, String string2) {
        return this.translateFrom(string, string2, this.labelProps);
    }

    private String translateIcon(String string, String string2) {
        return this.translateFrom(string, string2, this.iconProps);
    }

    private String translateFrom(String string, String string2, Map<String, Map<String, String>> map) {
        Map<String, String> map2 = map.get(string);
        if (map2 == null) {
            return string2;
        }
        String string3 = map2.get(string2);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }
}

