/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.rp.impl;

import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.rp.ResourcePoolSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourcePoolMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ResourcePoolMutationProvider.class);
    private DataService _dataService;

    public ResourcePoolMutationProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public OperationResult applyMultiSpec(ManagedObjectReference managedObjectReference, ResourceConfigSpec[] resourceConfigSpecArray) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            ResourcePool resourcePool = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            resourcePool.updateChildResourceConfiguration(resourceConfigSpecArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"Could not update the child configuration of the resource pool", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, ResourcePoolSpec resourcePoolSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            ResourcePool resourcePool = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            resourcePool.updateConfig(resourcePoolSpec.name, resourcePoolSpec.configSpec);
            return operationResult;
        }
        catch (Exception exception) {
            _logger.error((Object)"Could not update the configuration of the resource pool", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            return operationResult;
        }
    }

    public OperationResult applyDeferred(ManagedObjectReference managedObjectReference, ResourcePoolSpec resourcePoolSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduledTaskSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            ManagedObjectReference managedObjectReference2 = null;
            managedObjectReference2 = scheduledTaskSpec.scheduledTask != null ? this.applyDeferredExisting(managedObjectReference, resourcePoolSpec, scheduledTaskSpec) : this.applyDeferredNew(managedObjectReference, resourcePoolSpec, scheduledTaskSpec);
            operationResult.entity = managedObjectReference2;
        }
        catch (Exception exception) {
            _logger.error((Object)"Could not update the scheduled task of the resource pool", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            return operationResult;
        }
        return operationResult;
    }

    private ManagedObjectReference applyDeferredExisting(ManagedObjectReference managedObjectReference, ResourcePoolSpec resourcePoolSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduledTaskSpec) throws Exception {
        ScheduledTaskSpec scheduledTaskSpec2 = this.createScheduledTaskSpec(resourcePoolSpec, scheduledTaskSpec);
        return SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduledTaskSpec, (ScheduledTaskSpec)scheduledTaskSpec2);
    }

    private ManagedObjectReference applyDeferredNew(ManagedObjectReference managedObjectReference, ResourcePoolSpec resourcePoolSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduledTaskSpec) throws Exception {
        ScheduledTaskSpec scheduledTaskSpec2 = this.createScheduledTaskSpec(resourcePoolSpec, scheduledTaskSpec);
        return SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)managedObjectReference, (ScheduledTaskSpec)scheduledTaskSpec2);
    }

    public OperationResult add(ResourcePoolSpec resourcePoolSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = resourcePoolSpec.parent;
        try {
            ResourcePool resourcePool = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)resourcePoolSpec.parent);
            ManagedObjectReference managedObjectReference = resourcePool.createResourcePool(resourcePoolSpec.name, resourcePoolSpec.configSpec);
            operationResult.result = managedObjectReference;
            QueryUtil.waitUntilSearchable((DataService)this._dataService, (Object)managedObjectReference, (String[])new String[]{"parent"});
            return operationResult;
        }
        catch (Exception exception) {
            _logger.error((Object)"Could not create new resource pool.", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            return operationResult;
        }
    }

    private ScheduledTaskSpec createScheduledTaskSpec(ResourcePoolSpec resourcePoolSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduledTaskSpec) {
        ScheduledTaskSpec scheduledTaskSpec2 = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduledTaskSpec);
        MethodAction methodAction = SchedulingUtil.newMethodAction((String)"UpdateConfig", (Object[])new Object[]{resourcePoolSpec.name, resourcePoolSpec.configSpec});
        scheduledTaskSpec2.action = methodAction;
        return scheduledTaskSpec2;
    }
}

