/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.impl;

import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.TaskReason;
import com.vmware.vim.binding.vim.TaskReasonAlarm;
import com.vmware.vim.binding.vim.TaskReasonSchedule;
import com.vmware.vim.binding.vim.TaskReasonSystem;
import com.vmware.vim.binding.vim.TaskReasonUser;
import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.task.TaskSearchHelper;
import com.vmware.vsphere.client.task.impl.TaskUtil;
import java.util.ArrayList;

public class TaskSearchHelperImpl
implements TaskSearchHelper {
    private final String TASK_INFO = "info";
    private final String RECENT_TASK = "recentTask";
    private final int PROGRESS_INDETERMINATE = -1;
    private final Exception[] EMPTY_EXCEPTION_ARRAY = new Exception[0];
    private final ObjectReferenceService _objectReferenceService;
    private final PropertySpec[] TASK_INFO_PROP_SPEC_ARRAY = new PropertySpec[1];

    public TaskSearchHelperImpl(ObjectReferenceService objectReferenceService) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{"info"};
        propertySpec.type = Task.class.getSimpleName();
        this.TASK_INFO_PROP_SPEC_ARRAY[0] = propertySpec;
        this._objectReferenceService = objectReferenceService;
    }

    @Override
    public QuerySpec getRecentTasksQuerySpec(ManagedObjectReference managedObjectReference) {
        QuerySpec querySpec = new QuerySpec();
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)managedObjectReference);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"recentTask", (Constraint)objectIdentityConstraint, (Boolean)true, (String)Task.class.getSimpleName());
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = relationalConstraint;
        resourceSpec.propertySpecs = this.TASK_INFO_PROP_SPEC_ARRAY;
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }

    @Override
    public QuerySpec makeReplacementQuerySpec(QuerySpec querySpec, ManagedObjectReference managedObjectReference, int n) {
        QuerySpec querySpec2 = (QuerySpec)ObjectUtil.shallowCopy((Object)querySpec, QuerySpec.class);
        if (querySpec2.resourceSpec.constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)querySpec2.resourceSpec.constraint;
            for (Constraint constraint : compositeConstraint.nestedConstraints) {
                if (!(constraint instanceof PropertyConstraint)) continue;
                PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
                if (propertyConstraint.propertyName.equals("info.entity")) {
                    propertyConstraint.comparableValue = managedObjectReference;
                    continue;
                }
                if (!propertyConstraint.propertyName.equals("info.maxResultsPerSource")) continue;
                propertyConstraint.comparableValue = n;
            }
        }
        return querySpec2;
    }

    @Override
    public ClientTaskInfo getClientTaskInfo(TaskInfo taskInfo) {
        return this.getClientTaskInfo(taskInfo, null);
    }

    @Override
    public ClientTaskInfo getClientTaskInfo(TaskInfo taskInfo, LinkedVcGroupRegistry linkedVcGroupRegistry) {
        ClientTaskInfo clientTaskInfo = new ClientTaskInfo();
        clientTaskInfo.key = taskInfo.key;
        clientTaskInfo.taskRef = taskInfo.task;
        clientTaskInfo.source = TaskUtil.getLocalizedString("source.vCenter");
        if (taskInfo.task != null) {
            clientTaskInfo.taskUid = this._objectReferenceService.getUid((Object)taskInfo.task);
        }
        if (taskInfo.entity != null) {
            clientTaskInfo.entityUid = this._objectReferenceService.getUid((Object)taskInfo.entity);
            clientTaskInfo.rootFolderUid = this._objectReferenceService.getUid((Object)ManagedObjectUtil.getRootFolder((String)taskInfo.entity.getServerGuid()));
        }
        if (taskInfo.result != null) {
            clientTaskInfo.resultEntityUid = this._objectReferenceService.getUid(taskInfo.result);
        }
        clientTaskInfo.description = this.getTaskDescription(taskInfo);
        clientTaskInfo.entity = taskInfo.entity;
        clientTaskInfo.entityName = taskInfo.entityName;
        String string = clientTaskInfo.entityType = taskInfo.entity != null ? taskInfo.entity.getType() : null;
        if (taskInfo.result != null) {
            clientTaskInfo.result = taskInfo.result;
            if (taskInfo.result instanceof ManagedObjectReference) {
                clientTaskInfo.resultType = ((ManagedObjectReference)taskInfo.result).getType();
            }
        }
        if (taskInfo.descriptionId != null && taskInfo.descriptionId.endsWith(".destroy") && 0 == taskInfo.state.compareTo((Enum)TaskInfo.State.success)) {
            clientTaskInfo.entity = null;
        }
        clientTaskInfo.state = this.getState(taskInfo);
        if (clientTaskInfo.state == TaskState.ERROR) {
            clientTaskInfo.error = taskInfo.error;
        }
        clientTaskInfo.initiator = this.getInitiator(taskInfo);
        clientTaskInfo.service = this.getServiceName(taskInfo, linkedVcGroupRegistry);
        clientTaskInfo.cancelable = taskInfo.cancelable;
        clientTaskInfo.pausable = false;
        clientTaskInfo.progress = taskInfo.progress != null ? taskInfo.progress : -1;
        if (taskInfo.description != null) {
            clientTaskInfo.details = taskInfo.description.getMessage();
        }
        if (taskInfo.queueTime != null) {
            clientTaskInfo.queueTime = taskInfo.queueTime.getTime();
        }
        if (taskInfo.startTime != null) {
            clientTaskInfo.startTime = taskInfo.startTime.getTime();
        }
        if (taskInfo.queueTime != null && taskInfo.startTime != null) {
            clientTaskInfo.queuedForMilliseconds = taskInfo.startTime.getTimeInMillis() - taskInfo.queueTime.getTimeInMillis();
            clientTaskInfo.timeInQueueString = FormatUtil.getTimeSpanFormatted((Number)clientTaskInfo.queuedForMilliseconds, (long)FormatUtil.MILLISECOND);
        }
        if (taskInfo.completeTime != null) {
            clientTaskInfo.completionTime = taskInfo.completeTime.getTime();
        }
        if (clientTaskInfo.startTime != null && clientTaskInfo.completionTime != null) {
            clientTaskInfo.timeInExecution = clientTaskInfo.completionTime.getTime() - clientTaskInfo.startTime.getTime();
            clientTaskInfo.timeInExecutionString = FormatUtil.getTimeSpanFormatted((Number)clientTaskInfo.timeInExecution, (long)FormatUtil.MILLISECOND);
        }
        clientTaskInfo.eventChainId = taskInfo.eventChainId;
        clientTaskInfo.parentTaskKey = taskInfo.parentTaskKey;
        clientTaskInfo.rootTaskKey = taskInfo.rootTaskKey;
        clientTaskInfo.serverGuid = taskInfo.task.getServerGuid();
        clientTaskInfo.taskTypeId = taskInfo.descriptionId;
        return clientTaskInfo;
    }

    @Override
    public String getSessionUser(ManagedObjectReference managedObjectReference) {
        UserSession userSession;
        String string = "";
        VcService vcService = VimSessionUtil.getService((String)managedObjectReference.getServerGuid());
        if (vcService != null && (userSession = vcService.getConnectionInfo().getUserSession()) != null) {
            string = userSession.userName;
        }
        return string;
    }

    private String getServiceName(TaskInfo taskInfo, LinkedVcGroupRegistry linkedVcGroupRegistry) {
        ManagedObjectReference managedObjectReference;
        if (taskInfo.entity != null) {
            managedObjectReference = taskInfo.entity;
        } else if (taskInfo.task != null) {
            managedObjectReference = taskInfo.task;
        } else {
            return null;
        }
        String string = managedObjectReference.getServerGuid();
        if (linkedVcGroupRegistry == null) {
            return VcServiceUtil.getServiceName((String)string);
        }
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
        if (linkedVcGroup == null) {
            return null;
        }
        ServiceEndpointEx serviceEndpointEx = linkedVcGroup.getServiceEndpoint(string, ServiceDirectory.ServiceProtocol.vimApi);
        if (serviceEndpointEx != null) {
            return serviceEndpointEx.instanceName;
        }
        return null;
    }

    private String getInitiator(TaskInfo taskInfo) {
        String string = "";
        TaskReason taskReason = taskInfo.reason;
        if (taskReason instanceof TaskReasonUser) {
            string = ((TaskReasonUser)taskReason).userName;
        } else if (taskReason instanceof TaskReasonSystem) {
            string = "System";
        } else if (taskReason instanceof TaskReasonAlarm) {
            string = ((TaskReasonAlarm)taskReason).alarmName;
        } else if (taskReason instanceof TaskReasonSchedule) {
            string = ((TaskReasonSchedule)taskReason).name;
        }
        return string;
    }

    private TaskState getState(TaskInfo taskInfo) {
        if (taskInfo.state == null) {
            return null;
        }
        switch (taskInfo.state) {
            case error: {
                return TaskState.ERROR;
            }
            case queued: {
                return TaskState.QUEUED;
            }
            case running: {
                if (taskInfo.isCancelled()) {
                    return TaskState.CANCELED;
                }
                return TaskState.RUNNING;
            }
            case success: {
                return TaskState.SUCCESS;
            }
        }
        return null;
    }

    @Override
    public boolean taskBelongsToUser(TaskInfo taskInfo, String string) {
        if (string != null && (taskInfo == null || taskInfo.reason == null)) {
            return false;
        }
        if (string != null && taskInfo.reason instanceof TaskReasonUser) {
            TaskReasonUser taskReasonUser = (TaskReasonUser)taskInfo.reason;
            if (taskReasonUser.userName != null) {
                return taskReasonUser.userName.equalsIgnoreCase(string);
            }
        }
        return true;
    }

    @Override
    public String getTaskDescription(TaskInfo taskInfo) {
        String string = taskInfo.descriptionId + ".label";
        String string2 = LocalizationUtil.getLocalizedMessage((String)string, null);
        if (string2 != null) {
            return string2;
        }
        return taskInfo.descriptionId;
    }

    @Override
    public Exception filterPermissionExceptions(Exception exception) {
        if (!(exception instanceof MethodFault)) {
            return exception;
        }
        MethodFault methodFault = (MethodFault)exception;
        Throwable throwable = methodFault.getCause();
        if (throwable instanceof NoPermission) {
            return null;
        }
        if (throwable instanceof CompositeException) {
            CompositeException compositeException = (CompositeException)throwable;
            Exception[] exceptionArray = compositeException.getExceptions();
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            boolean bl = false;
            for (Exception exception2 : exceptionArray) {
                if (exception2 instanceof NoPermission) {
                    bl = true;
                    continue;
                }
                arrayList.add(exception2);
            }
            if (bl) {
                if (arrayList.size() == 0) {
                    return null;
                }
                Exception[] exceptionArray2 = arrayList.toArray(this.EMPTY_EXCEPTION_ARRAY);
                compositeException.setExceptions(exceptionArray2);
                methodFault.setFaultCause((Exception)compositeException);
            }
        }
        return exception;
    }
}

