/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.StringFilter;
import com.vmware.vise.util.io.StreamUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public class ExceptionUtil {
    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter(500);
            printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
        }
        catch (Throwable throwable2) {
            StreamUtil.close(printWriter);
            StreamUtil.close(stringWriter);
            throw throwable2;
        }
        StreamUtil.close(printWriter);
        StreamUtil.close(stringWriter);
        String string = stringWriter.toString();
        return string;
    }

    public static String convertStackTraceElementsToString(@Nullable StackTraceElement[] stackTraceElementArray) {
        return ExceptionUtil.convertStackTraceElementsToString(stackTraceElementArray, 0, null);
    }

    private static String convertStackTraceElementsToString(@Nullable StackTraceElement[] stackTraceElementArray, int n, @Nullable StringFilter stringFilter) {
        if (stackTraceElementArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2000);
        String string = ExceptionUtil.class.getCanonicalName();
        int n2 = stackTraceElementArray.length;
        for (int i = n; i < n2; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string2 = stackTraceElement.getClassName();
            String string3 = stackTraceElement.getMethodName();
            if (string.equals(string2) && "getCurrentStackTrace".equals(string3) || stringFilter != null && !stringFilter.accept(string2)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append("\tat ").append(stackTraceElement);
        }
        return stringBuilder.toString();
    }

    public static String getCurrentStackTrace() {
        return ExceptionUtil.getCurrentStackTrace(null);
    }

    public static String getCurrentStackTrace(StringFilter stringFilter) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = ExceptionUtil.convertStackTraceElementsToString(stackTraceElementArray, 2, stringFilter);
        return string;
    }

    public static boolean isCausedBy(Throwable throwable, Class<? extends Throwable> clazz) {
        if (throwable == null || clazz == null) {
            return false;
        }
        while (throwable != null) {
            if (clazz.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    @SafeVarargs
    public static boolean isCausedByAnyOf(Throwable throwable, Class<?> ... classArray) {
        if (throwable == null || classArray == null || classArray.length == 0) {
            return false;
        }
        while (throwable != null) {
            Class<?> clazz = throwable.getClass();
            for (Class<?> clazz2 : classArray) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static <T extends Throwable> T replaceMessage(T t, String string) {
        Throwable throwable;
        StackTraceElement[] stackTraceElementArray;
        if (t == null) {
            return null;
        }
        try {
            try {
                Throwable throwable2;
                Constructor<?> constructor = t.getClass().getConstructor(String.class, Throwable.class);
                stackTraceElementArray = t.getCause();
                throwable = throwable2 = (Throwable)constructor.newInstance(string, stackTraceElementArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Throwable throwable3;
                Constructor<?> constructor = t.getClass().getConstructor(String.class);
                throwable = throwable3 = (Throwable)constructor.newInstance(string);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't instantiate a new Throwable", exception);
        }
        stackTraceElementArray = t.getStackTrace();
        throwable.setStackTrace(stackTraceElementArray);
        return (T)throwable;
    }

    public static Throwable unwrap(@Nullable Throwable throwable) {
        Throwable throwable2;
        if (throwable == null) {
            return null;
        }
        while ((throwable instanceof InvocationTargetException || throwable instanceof ExecutionException) && (throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
        }
        if (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Exception limitStackTrace(Exception exception) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return exception;
        }
        StackTraceElement[] stackTraceElementArray2 = exception.getStackTrace();
        if (stackTraceElementArray2 == null || stackTraceElementArray2.length == 0) {
            return exception;
        }
        StackTraceElement stackTraceElement = stackTraceElementArray[2];
        String string = stackTraceElement.getClassName();
        String string2 = stackTraceElement.getMethodName();
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
        for (StackTraceElement stackTraceElement2 : stackTraceElementArray2) {
            arrayList.add(stackTraceElement2);
            if (!string.equals(stackTraceElement2.getClassName()) || !string2.equals(stackTraceElement2.getMethodName())) continue;
            arrayList.add(new StackTraceElement("...stripped.on.purpose.here.by.com.vmware.vise.util.ExceptionUtil...", "", null, -1));
            break;
        }
        exception.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        return exception;
    }
}

