/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormatUtil {
    public static final long AUTO = -1L;
    public static final long B = 1L;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static long Hz = 1L;
    public static long KHz = 1000L;
    public static long MHz = KHz * KHz;
    public static long GHz = MHz * KHz;
    public static long THz = GHz * KHz;
    public static long BPS = 1L;
    public static long KBPS = 1000L;
    public static long MBPS = KBPS * KBPS;
    public static long GBPS = MBPS * KBPS;
    public static long TBPS = GBPS * KBPS;
    public static long MILLISECOND = 1L;
    public static long SECOND = 1000L;
    public static long MINUTE = 60000L;
    public static long HOUR = 3600000L;
    public static long DAY = 86400000L;
    private static final Log _logger = LogFactory.getLog(FormatUtil.class);

    public static String getDataSizeFormatted(Number number, int n, long l, long l2, boolean bl) {
        if (number == null || l == -1L) {
            return null;
        }
        if (l2 != -1L && l2 != 1L && l2 != 1024L && l2 != 0x100000L && l2 != 0x40000000L && l2 != 0x10000000000L) {
            l2 = -1L;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(number.doubleValue()).multiply(BigDecimal.valueOf(l));
        BigDecimal bigDecimal2 = bigDecimal.abs();
        if (l2 == -1L) {
            l2 = bigDecimal2.compareTo(BigDecimal.valueOf(0x10000000000L)) >= 0 ? 0x10000000000L : (bigDecimal2.compareTo(BigDecimal.valueOf(0x40000000L)) >= 0 ? 0x40000000L : (bigDecimal2.compareTo(BigDecimal.valueOf(0x100000L)) >= 0 ? 0x100000L : (bigDecimal2.compareTo(BigDecimal.valueOf(1024L)) >= 0 ? 1024L : 1L)));
        }
        BigDecimal bigDecimal3 = BigDecimal.valueOf(l2);
        BigDecimal bigDecimal4 = bigDecimal.divide(bigDecimal3, n, RoundingMode.HALF_UP);
        String string = FormatUtil.getLocalizedNumber(bigDecimal4);
        String string2 = string + (bl ? " " + FormatUtil.getStorageUnit(l2) : "");
        return string2;
    }

    public static String getStorageFormatted(Long l, long l2, long l3) {
        String string = FormatUtil.getDataSizeFormatted(l, 2, l2, l3, true);
        return string;
    }

    public static String getStorageUnit(long l) {
        if (l == 1024L) {
            return FormatUtil.getProperty("MEM_KB");
        }
        if (l == 0x100000L) {
            return FormatUtil.getProperty("MEM_MB");
        }
        if (l == 0x40000000L) {
            return FormatUtil.getProperty("MEM_GB");
        }
        if (l == 0x10000000000L) {
            return FormatUtil.getProperty("MEM_TB");
        }
        return FormatUtil.getProperty("MEM_B");
    }

    public static String getFrequencyUnit(long l) {
        if (l == KHz) {
            return FormatUtil.getProperty("FREQ_KHZ");
        }
        if (l == MHz) {
            return FormatUtil.getProperty("FREQ_MHZ");
        }
        if (l == GHz) {
            return FormatUtil.getProperty("FREQ_GHZ");
        }
        if (l == THz) {
            return FormatUtil.getProperty("FREQ_THZ");
        }
        return FormatUtil.getProperty("FREQ_HZ");
    }

    public static String getBitRateUnit(long l) {
        if (l == KBPS) {
            return FormatUtil.getProperty("BR_KBPS");
        }
        if (l == MBPS) {
            return FormatUtil.getProperty("BR_MBPS");
        }
        if (l == GBPS) {
            return FormatUtil.getProperty("BR_GBPS");
        }
        if (l == TBPS) {
            return FormatUtil.getProperty("BR_TBPS");
        }
        return FormatUtil.getProperty("BR_BPS");
    }

    public static String getFrequencyFormatted(Number number, int n, long l, long l2, boolean bl) {
        if (number == null || l == -1L) {
            return null;
        }
        if (l2 != -1L && l2 != Hz && l2 != KHz && l2 != MHz && l2 != GHz && l2 != THz) {
            l2 = -1L;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(number.doubleValue()).multiply(BigDecimal.valueOf(l));
        BigDecimal bigDecimal2 = bigDecimal.abs();
        if (l2 == -1L) {
            l2 = bigDecimal2.compareTo(BigDecimal.valueOf(THz)) >= 0 ? THz : (bigDecimal2.compareTo(BigDecimal.valueOf(GHz)) >= 0 ? GHz : (bigDecimal2.compareTo(BigDecimal.valueOf(MHz)) >= 0 ? MHz : (bigDecimal2.compareTo(BigDecimal.valueOf(KHz)) >= 0 ? KHz : Hz)));
        }
        BigDecimal bigDecimal3 = BigDecimal.valueOf(l2);
        BigDecimal bigDecimal4 = bigDecimal.divide(bigDecimal3, n, RoundingMode.HALF_UP);
        String string = FormatUtil.getLocalizedNumber(bigDecimal4);
        String string2 = string + (bl ? " " + FormatUtil.getFrequencyUnit(l2) : "");
        return string2;
    }

    public static String getBitRateFormatted(Number number, int n, long l, long l2, boolean bl) {
        if (number == null || l == -1L) {
            return null;
        }
        if (l2 != -1L && l2 != BPS && l2 != KBPS && l2 != MBPS && l2 != GBPS && l2 != TBPS) {
            l2 = -1L;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(number.doubleValue()).multiply(BigDecimal.valueOf(l));
        BigDecimal bigDecimal2 = bigDecimal.abs();
        if (l2 == -1L) {
            l2 = bigDecimal2.compareTo(BigDecimal.valueOf(TBPS)) >= 0 ? TBPS : (bigDecimal2.compareTo(BigDecimal.valueOf(GBPS)) >= 0 ? GBPS : (bigDecimal2.compareTo(BigDecimal.valueOf(MBPS)) >= 0 ? MBPS : (bigDecimal2.compareTo(BigDecimal.valueOf(KBPS)) >= 0 ? KBPS : BPS)));
        }
        BigDecimal bigDecimal3 = BigDecimal.valueOf(l2);
        BigDecimal bigDecimal4 = bigDecimal.divide(bigDecimal3, n, RoundingMode.HALF_UP);
        String string = FormatUtil.getLocalizedNumber(bigDecimal4);
        String string2 = string + (bl ? " " + FormatUtil.getBitRateUnit(l2) : "");
        return string2;
    }

    public static String getTimeSpanFormatted(Number number, long l) {
        ValidationUtil.paramsNotNull(number, l);
        String string = "";
        long l2 = number.longValue() * l;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (l2 >= DAY) {
            n = (int)(l2 / DAY);
            l2 %= DAY;
        }
        if (l2 >= HOUR) {
            n2 = (int)(l2 / HOUR);
            l2 %= HOUR;
        }
        if (l2 >= MINUTE) {
            n3 = (int)(l2 / MINUTE);
            l2 %= MINUTE;
        }
        n4 = (int)(l2 / 1000L);
        string = n > 0 ? n + " " + FormatUtil.getProperty("TIME_DAY_SHORT") + " " + n2 + " " + FormatUtil.getProperty("TIME_HOUR_SHORT") + " " + n3 + " " + FormatUtil.getProperty("TIME_MINUTE_SHORT") + " " + n4 + " " + FormatUtil.getProperty("TIME_SECOND_SHORT") : (n2 > 0 ? n2 + " " + FormatUtil.getProperty("TIME_HOUR_SHORT") + " " + n3 + " " + FormatUtil.getProperty("TIME_MINUTE_SHORT") + " " + n4 + " " + FormatUtil.getProperty("TIME_SECOND_SHORT") : (n3 > 0 ? n3 + " " + FormatUtil.getProperty("TIME_MINUTE_SHORT") + " " + n4 + " " + FormatUtil.getProperty("TIME_SECOND_SHORT") : (n4 > 0 ? n4 + " " + FormatUtil.getProperty("TIME_SECOND_SHORT") : l2 + " " + FormatUtil.getProperty("TIME_MILLISECOND_SHORT"))));
        return string;
    }

    public static String getTimeSpanFormattedToClosestUnit(Number number, long l) {
        if (number == null || l == -1L) {
            return null;
        }
        long l2 = number.longValue() * l / 1000L;
        if (l2 < 0L) {
            return FormatUtil.getProperty("TIME_UNKNOWN");
        }
        long l3 = l2 % 60L;
        l2 = (l2 - l3) / 60L;
        long l4 = l2 % 60L;
        l2 = (l2 - l4) / 60L;
        long l5 = l2 % 24L;
        long l6 = l2 = (l2 - l5) / 24L;
        String string = null;
        if (l4 < 2L && l5 < 1L && l6 < 1L) {
            if ((l3 += l4 * 60L) > 1L) {
                string = l3 + " " + FormatUtil.getProperty("TIME_SECONDS");
                return string;
            }
            string = l3 + " " + FormatUtil.getProperty("TIME_SECOND");
            return string;
        }
        if (l5 < 2L && l6 < 1L) {
            string = l4 + l5 * 60L + " " + FormatUtil.getProperty("TIME_MINUTES");
            return string;
        }
        if (l6 < 1L) {
            string = l5 + l6 * 24L + " " + FormatUtil.getProperty("TIME_HOURS");
            return string;
        }
        string = l6 + " " + FormatUtil.getProperty("TIME_DAYS");
        return string;
    }

    private static Date populateDate(Object object, DateFormat dateFormat) {
        ValidationUtil.paramsNotNull(object, dateFormat);
        Date date = null;
        try {
            if (object instanceof Date) {
                date = (Date)object;
            } else if (object instanceof Calendar) {
                date = ((Calendar)object).getTime();
            } else if (object instanceof String) {
                date = dateFormat.parse((String)object);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            return null;
        }
        return date;
    }

    public static String getDateFormatted(Object object) {
        ValidationUtil.paramsNotNull(object);
        DateFormat dateFormat = DateFormat.getDateInstance(2, ResourceUtil.getLocale());
        Date date = FormatUtil.populateDate(object, dateFormat);
        if (date == null) {
            return object.toString();
        }
        String string = dateFormat.format(date);
        return string;
    }

    public static String getTimeFormatted(Object object) {
        ValidationUtil.paramsNotNull(object);
        DateFormat dateFormat = DateFormat.getTimeInstance(3, ResourceUtil.getLocale());
        Date date = FormatUtil.populateDate(object, dateFormat);
        if (date == null) {
            return object.toString();
        }
        String string = dateFormat.format(date);
        return string;
    }

    public static String getDateTimeFormatted(Object object) {
        return FormatUtil.getDateTimeFormattedInternal(object, 2, 3);
    }

    public static String getDateTimeWithTimezoneFormatted(Object object) {
        return FormatUtil.getDateTimeFormattedInternal(object, 2, 0);
    }

    private static String getDateTimeFormattedInternal(Object object, int n, int n2) {
        ValidationUtil.paramsNotNull(object);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n2, ResourceUtil.getLocale());
        Date date = FormatUtil.populateDate(object, dateFormat);
        if (date == null) {
            return object.toString();
        }
        String string = dateFormat.format(date);
        return string;
    }

    private static String getProperty(String string) {
        return ResourceUtil.getString("commonutil", string, FormatUtil.class.getClassLoader());
    }

    private static String getLocalizedNumber(BigDecimal bigDecimal) {
        String string = NumberFormat.getInstance(ResourceUtil.getLocale()).format(bigDecimal.doubleValue());
        return string;
    }
}

