/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class IdentityHashSet<E>
extends AbstractSet<E>
implements Cloneable {
    static final long serialVersionUID = -1L;
    private static final Object DEFAULT_VALUE = new Object();
    private transient IdentityHashMap<E, Object> _map;

    public IdentityHashSet() {
        this._map = new IdentityHashMap();
    }

    public IdentityHashSet(int n) {
        this._map = new IdentityHashMap(n);
    }

    public IdentityHashSet(Collection<? extends E> collection) {
        int n = Math.max((int)((double)collection.size() * 1.33) + 1, 32);
        this._map = new IdentityHashMap(n);
        this.addAll(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Object clone() {
        try {
            IdentityHashSet identityHashSet = (IdentityHashSet)super.clone();
            identityHashSet._map = (IdentityHashMap)this._map.clone();
            return identityHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public boolean add(E e) {
        return this._map.put(e, DEFAULT_VALUE) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this._map.remove(object) == DEFAULT_VALUE;
    }

    @Override
    public void clear() {
        this._map.clear();
    }
}

