/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InArrayPredicate<T>
implements Predicate<T> {
    private final Equivalence<Object> _equivalence;
    private final T[] _targets;

    @SafeVarargs
    public InArrayPredicate(@Nonnull Equivalence<Object> equivalence, T ... TArray) {
        Preconditions.checkArgument((equivalence != null ? 1 : 0) != 0, (Object)"equivalence is null");
        Preconditions.checkArgument((TArray != null ? 1 : 0) != 0, (Object)"targets is null");
        this._targets = TArray;
        this._equivalence = equivalence;
    }

    public boolean apply(@Nullable T t) {
        for (T t2 : this._targets) {
            if (!this._equivalence.equivalent(t, t2)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof InArrayPredicate) {
            InArrayPredicate inArrayPredicate = (InArrayPredicate)object;
            return this._equivalence.equals(inArrayPredicate._equivalence) && Objects.equal(this._targets, inArrayPredicate._targets);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._equivalence, this._targets});
    }

    public String toString() {
        return this._equivalence + ".equivalentTo(" + Arrays.toString(this._targets) + ")";
    }
}

