/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.internal.Config;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class OpIdUtil {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_OP_ID_PREFIX;
    private static final String OP_ID_SUFFIX;
    private static final AtomicLong _opCount;
    private static final ThreadLocal<String> _customOpIdPrefix;

    public static String generateOpId() {
        String string = _customOpIdPrefix.get();
        if (string == null) {
            string = OpIdUtil.getOpIdPrefixFromRequest();
        }
        if (string == null) {
            string = DEFAULT_OP_ID_PREFIX;
        }
        StringBuilder stringBuilder = new StringBuilder().append(string).append('-').append(_opCount.incrementAndGet()).append(OP_ID_SUFFIX);
        OpIdUtil.appendHashedRequestId(stringBuilder);
        return stringBuilder.toString();
    }

    public static String generateOpId(String string) {
        Assert.notNull((Object)string, (String)"suffix must not be null");
        return OpIdUtil.generateOpId() + string;
    }

    public static String generateOpIdPrefixForRequest() {
        StringBuilder stringBuilder = new StringBuilder().append(DEFAULT_OP_ID_PREFIX).append('-').append(_opCount.incrementAndGet()).append("-auto");
        return stringBuilder.toString();
    }

    public static String getOpIdPrefixFromRequest() {
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        if (httpServletRequest == null) {
            return null;
        }
        return OpIdUtil.getOpIdPrefixFromRequest(httpServletRequest);
    }

    public static String getOpIdPrefixFromRequest(HttpServletRequest httpServletRequest) {
        Validate.notNull((Object)httpServletRequest);
        try {
            Object object = httpServletRequest.getAttribute("opId");
            return (String)object;
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to retrieve opId prefix from the request. Will assume it's null.", (Throwable)exception);
            return null;
        }
    }

    public static void setOpIdPrefixIntoRequest(String string) {
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        if (httpServletRequest != null) {
            OpIdUtil.setOpIdPrefixIntoRequest(httpServletRequest, string);
        }
    }

    public static void setOpIdPrefixIntoRequest(HttpServletRequest httpServletRequest, String string) {
        Validate.notNull((Object)httpServletRequest);
        httpServletRequest.setAttribute("opId", (Object)string);
    }

    public static String getOrGenerateOpIdPrefix(HttpServletRequest httpServletRequest) {
        String string = OpIdUtil.getOpIdPrefixFromRequest(httpServletRequest);
        if (string == null) {
            string = OpIdUtil.generateOpIdPrefixForRequest();
            OpIdUtil.setOpIdPrefixIntoRequest(httpServletRequest, string);
        }
        return string;
    }

    public static void setCustomOpIdPrefix(String string) {
        _customOpIdPrefix.set(string);
    }

    public static String getCustomOpIdPrefix() {
        String string = _customOpIdPrefix.get();
        return string;
    }

    public static LogUtil.LogLevel determineLogLevelFor(Log log, Method method) {
        if (log == null) {
            return LogUtil.LogLevel.OFF;
        }
        Validate.notNull((Object)method);
        String string = method.getDeclaringClass().getName();
        String string2 = method.getName();
        Pair<String, String> pair = new Pair<String, String>(string, string2);
        if (Config.OP_ID_LOGGING_METHODS_TRACE_LEVEL.contains(pair)) {
            if (log.isTraceEnabled()) {
                return LogUtil.LogLevel.TRACE;
            }
            return LogUtil.LogLevel.OFF;
        }
        if (log.isDebugEnabled()) {
            return LogUtil.LogLevel.DEBUG;
        }
        return LogUtil.LogLevel.OFF;
    }

    public static boolean shouldSlowInvocationBeLogged(Method method) {
        Validate.notNull((Object)method);
        String string = method.getDeclaringClass().getName();
        String string2 = method.getName();
        Pair<String, String> pair = new Pair<String, String>(string, string2);
        boolean bl = !Config.OP_ID_LOGGING_METHODS_WHITELIST_SLOW.contains(pair);
        return bl;
    }

    private static void appendHashedRequestId(@Nonnull StringBuilder stringBuilder) {
        String string = SessionUtil.getHashedRequestId();
        if (!StringUtil.isNullOrWhitespace(string)) {
            stringBuilder.append(':').append(string);
        }
    }

    static {
        _opCount = new AtomicLong();
        _customOpIdPrefix = new ThreadLocal();
        DEFAULT_OP_ID_PREFIX = UUID.randomUUID().toString();
        _logger.info((Object)("Generated DEFAULT_OP_ID_PREFIX: " + DEFAULT_OP_ID_PREFIX));
        OP_ID_SUFFIX = BuildProperties.isH5Client() ? "-h5c" : "-ngc";
    }
}

