/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class StringUtil {
    public static final String NEW_LINE = "\n";
    public static final String EMPTY = "";
    public static final String DEFAULT_PAD_CHAR = " ";
    public static final int DEFAULT_INDENTATION_SIZE = 3;
    public static final String[] EMPTY_STRING_ARR = new String[0];
    public static final char[] EMPTY_CHAR_ARR = new char[0];
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    public static boolean isNullOrEmpty(String string) {
        boolean bl = string == null || string.length() == 0;
        return bl;
    }

    public static boolean isNullOrWhitespace(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String returnNullIfEmpty(String string) {
        if (StringUtil.isNullOrWhitespace(string)) {
            return null;
        }
        return string;
    }

    public static Pair<String, String> removeLastWord(String string, char c) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(c);
        if (n == -1) {
            Pair<String, String> pair = new Pair<String, String>(EMPTY, string);
            return pair;
        }
        if (n == string.length() - 1) {
            String string2 = string.substring(0, n);
            Pair<String, String> pair = new Pair<String, String>(string2, EMPTY);
            return pair;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        Pair<String, String> pair = new Pair<String, String>(string3, string4);
        return pair;
    }

    public static String stripExcessWhitespace(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim().replaceAll("[\\s]+", DEFAULT_PAD_CHAR);
        return string2;
    }

    public static String[] splitAndTrim(String string, String string2) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public static String replaceWord(String string, int n, String string2, String string3) {
        ValidationUtil.paramsNotNull(string, string2, string3);
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + string2.length());
        String string6 = string4 + string3 + string5;
        return string6;
    }

    public static String getIndexedString(ArrayList<String> arrayList, String string, String string2) {
        if (StringUtil.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("Default name cannot be null or empty.");
        }
        if (ArrayUtil.isNullOrEmpty(arrayList)) {
            return string;
        }
        if (string2 == null) {
            string2 = EMPTY;
        }
        String string3 = string;
        Boolean bl = false;
        int n = 1;
        block0: while (!bl.booleanValue()) {
            bl = true;
            for (String string4 : arrayList) {
                if (!string4.equalsIgnoreCase(string3)) continue;
                string3 = string + string2 + n;
                ++n;
                bl = false;
                continue block0;
            }
        }
        return string3;
    }

    public static String escape(String string, char c, final char c2, final char c3) {
        if (c == c2) {
            throw new IllegalArgumentException("escapeChar should not be the same as targetChar.");
        }
        if (c == c3) {
            throw new IllegalArgumentException("escapeChar should not be the same as escapeForTargetChar.");
        }
        if (string == null) {
            return null;
        }
        String string2 = StringUtil.escape(string, c, new CharacterMapper(){

            @Override
            public char map(char c) {
                if (c == c2) {
                    return c3;
                }
                return '\u0000';
            }
        });
        return string2;
    }

    public static String escape(String string, char c, CharacterMapper characterMapper) {
        if (characterMapper == null) {
            throw new IllegalArgumentException("charMapper should not be null.");
        }
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 10);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuilder.append(c).append(c);
                continue;
            }
            char c3 = characterMapper.map(c2);
            if (c3 != '\u0000') {
                stringBuilder.append(c).append(c3);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string, char c, final char c2, final char c3) throws ParseException {
        if (string == null) {
            return null;
        }
        String string2 = StringUtil.unescape(string, c, new CharacterMapper(){

            @Override
            public char map(char c) {
                if (c == c3) {
                    return c2;
                }
                return '\u0000';
            }
        });
        return string2;
    }

    public static String unescape(String string, char c, CharacterMapper characterMapper) throws ParseException {
        if (characterMapper == null) {
            throw new IllegalArgumentException("The CharacterMapper should not be null.");
        }
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = n2 - 1;
        StringBuilder stringBuilder = new StringBuilder(n2);
        while (n < n2) {
            char c2 = string.charAt(n);
            if (c2 == c && n < n3) {
                char c3 = string.charAt(n + 1);
                if (c3 == c) {
                    stringBuilder.append(c);
                } else {
                    char c4 = characterMapper.map(c3);
                    if (c4 != '\u0000') {
                        stringBuilder.append(c4);
                    } else {
                        throw new ParseException("Unrecognized escape sequence: " + c + c3, n);
                    }
                }
                n += 2;
                continue;
            }
            stringBuilder.append(c2);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String trimQuotes(String string) {
        if (string == null || string.length() <= 1) {
            return string;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String pad(PadType padType, String string, int n, LengthType lengthType, String string2) {
        int n2;
        int n3;
        if (string == null) {
            return null;
        }
        if (StringUtil.isNullOrEmpty(string2)) {
            string2 = DEFAULT_PAD_CHAR;
        }
        if (padType == null) {
            padType = PadType.PAD_RIGHT;
        }
        if (lengthType == null) {
            lengthType = LengthType.OVERALL_LENGTH;
        }
        int n4 = string.length();
        if (lengthType == LengthType.OVERALL_LENGTH) {
            if (n <= n4) {
                return string;
            }
            n3 = n - n4;
            n2 = n;
        } else {
            n3 = n;
            n2 = n4 + n3;
        }
        if (n3 == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (padType == PadType.PAD_LEFT) {
            StringUtil.appendPadding(stringBuilder, n3, string2);
            stringBuilder.append(string);
        } else {
            stringBuilder.append(string);
            StringUtil.appendPadding(stringBuilder, n3, string2);
        }
        return stringBuilder.toString();
    }

    public static void appendPadding(StringBuilder stringBuilder, int n, String string) {
        if (stringBuilder == null || n <= 0) {
            return;
        }
        if (StringUtil.isNullOrEmpty(string)) {
            string = DEFAULT_PAD_CHAR;
        }
        char[] cArray = new char[n];
        if (string.length() == 1) {
            char c = string.charAt(0);
            Arrays.fill(cArray, c);
        } else {
            int n2 = string.length();
            for (int i = 0; i < n; ++i) {
                cArray[i] = string.charAt(i % n2);
            }
        }
        stringBuilder.append(cArray);
    }

    public static String getPadding(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("The padding length should be >= 0");
        }
        if (n == 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        StringUtil.appendPadding(stringBuilder, n, string);
        return stringBuilder.toString();
    }

    @CheckForNull
    public static Boolean parseBoolean(@Nullable String string) {
        if (string == null) {
            return null;
        }
        if ("true".equals(string = string.toLowerCase()) || "yes".equals(string) || "y".equals(string)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string) || "no".equals(string) || "n".equals(string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static boolean parseBoolean(@Nullable String string, boolean bl) {
        Boolean bl2 = StringUtil.parseBoolean(string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public static String appendStrings(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            if (object == null) continue;
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static DecimalFormat getGroupByThreeDecimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingSize(3);
        return decimalFormat;
    }

    public static interface CharacterMapper {
        public char map(char var1);
    }

    public static enum LengthType {
        OVERALL_LENGTH,
        PADDING_LENGTH;

    }

    public static enum PadType {
        PAD_LEFT,
        PAD_RIGHT;

    }
}

