/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Version {
    private static final Log _logger = LogFactory.getLog(Version.class);
    public final int major;
    public final int minor;
    public final int revision;
    public final int buildNumber;

    public Version(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            this.major = 0;
            this.minor = 0;
            this.revision = 0;
            this.buildNumber = 0;
            return;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 4) {
            throw new IllegalArgumentException("Invalid version: " + string);
        }
        int n = Integer.parseInt(stringArray[0]);
        if (n < 0) {
            n = 0;
        }
        this.major = n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (stringArray.length > 1) {
            n2 = Integer.parseInt(stringArray[1]);
            if (n2 < 0) {
                n2 = 0;
            }
            if (stringArray.length > 2) {
                n3 = Integer.parseInt(stringArray[2]);
                if (n3 < 0) {
                    n3 = 0;
                }
                if (stringArray.length > 3 && (n4 = Integer.parseInt(stringArray[3])) < 0) {
                    n4 = 0;
                }
            }
        }
        this.minor = n2;
        this.revision = n3;
        this.buildNumber = n4;
    }

    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        if (this.major != version.major) {
            if (this.major > version.major) {
                return 1;
            }
            return -1;
        }
        if (this.minor != version.minor) {
            if (this.minor > version.minor) {
                return 1;
            }
            return -1;
        }
        if (this.revision != version.revision) {
            if (this.revision > version.revision) {
                return 1;
            }
            return -1;
        }
        if (this.buildNumber == version.buildNumber) {
            return 0;
        }
        if (this.buildNumber > version.buildNumber) {
            return 1;
        }
        return -1;
    }

    public static int compare(Version version, Version version2) {
        if (version == null && version2 == null) {
            return 0;
        }
        if (version == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        return version.compareTo(version2);
    }

    public static boolean isValidVersion(String string) {
        Version version = null;
        try {
            version = new Version(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version != null;
    }

    public static boolean isSupportedVersion(String[] stringArray, String string) {
        if (stringArray == null) {
            return false;
        }
        Version version = new Version(string);
        for (String string2 : stringArray) {
            if (!Version.matchMajorMinorVersions(string2, version)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchMajorMinorVersions(String string, Version version) {
        try {
            Version version2 = new Version(string);
            return version2.major == version.major && version2.minor == version.minor;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when comparing versions", (Throwable)exception);
            return false;
        }
    }

    public String toString() {
        return String.format("%s.%s.%s.%s", this.major, this.minor, this.revision, this.buildNumber);
    }
}

