/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.google.common.base.Preconditions;
import com.vmware.vise.util.RuntimeExecutionException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ConcurrencyUtil {
    public static final long TASK_WAIT_TIME_THRESHOLD_IN_NANOS = TimeUnit.SECONDS.toNanos(5L);
    public static final String PROP_NAME__THREAD_POOL_ADDITIONAL_DIAGNOSTICS_ENABLED = "threadPool.additionalDiagnostics.enabled";

    public static boolean pollForEvent(@Nonnull Callable<Boolean> callable, long l, @Nonnegative long l2) throws RuntimeExecutionException, InterruptedException {
        long l3;
        long l4;
        Boolean bl;
        Preconditions.checkNotNull(callable, (Object)"event is null");
        Preconditions.checkArgument((l2 > 0L ? 1 : 0) != 0, (Object)"pollIntervalInMillis must be positive");
        try {
            bl = callable.call();
        }
        catch (Exception exception) {
            throw new RuntimeExecutionException("Event check failed", exception);
        }
        if (bl == null) {
            return false;
        }
        if (Boolean.TRUE.equals(bl)) {
            return true;
        }
        long l5 = l4 = l > 0L ? System.currentTimeMillis() + l : Long.MAX_VALUE;
        while ((l3 = l4 - System.currentTimeMillis()) > 0L) {
            long l6 = Math.min(l2, l3);
            Thread.sleep(l6);
            try {
                bl = callable.call();
            }
            catch (Exception exception) {
                throw new RuntimeExecutionException("Event check failed", exception);
            }
            if (bl == null) {
                return false;
            }
            if (!Boolean.TRUE.equals(bl)) continue;
            return true;
        }
        return false;
    }
}

