/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.concurrent.DiagnosticExecutorService;
import com.vmware.vise.util.concurrent.TaskDescriptor;
import com.vmware.vise.util.internal.Config;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiagnosticThreadPoolExecutor
extends ThreadPoolExecutor
implements DiagnosticExecutorService {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Set<TaskDescriptor> _currentTasks;
    private volatile boolean _isLoggingOfAdditionalDiagnosticsEnabled = true;
    private final long _queueWaitTimeThresholdNanos;
    private final int _delayedTaskStepSizeForLoggingAdditionalDiagnostics;
    private final int _rejectedTaskStepSizeForLoggingAdditionalDiagnostics;
    private final long _minNanosApartForLoggingAdditionalDiagnostics;
    private final AtomicLong _rejectedTasksCounter = new AtomicLong(0L);
    private final AtomicLong _delayedTasksCounter = new AtomicLong(0L);
    private final AtomicLong _nanoTimeOfLatestLoggingOfAdditionalDiagnostics = new AtomicLong(Long.MIN_VALUE);
    private final TaskDelayedListener _taskDelayedListener;
    private final TaskRejectedListener _taskRejectedListener;

    private DiagnosticThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, @Nullable ConfigurationService configurationService, long l2, int n3, int n4, long l3, @Nullable TaskDelayedListener taskDelayedListener, @Nullable TaskRejectedListener taskRejectedListener) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory);
        this.setRejectedExecutionHandler(new LogDiagnosticsAndAbortPolicy());
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        this._currentTasks = Collections.newSetFromMap(concurrentHashMap);
        if (configurationService != null) {
            this.doUseConfigurationService(configurationService);
        }
        this._queueWaitTimeThresholdNanos = l2;
        this._delayedTaskStepSizeForLoggingAdditionalDiagnostics = n3;
        this._rejectedTaskStepSizeForLoggingAdditionalDiagnostics = n4;
        this._minNanosApartForLoggingAdditionalDiagnostics = l3;
        this._taskDelayedListener = taskDelayedListener;
        this._taskRejectedListener = taskRejectedListener;
    }

    public void useConfigurationService(ConfigurationService configurationService) {
        this.doUseConfigurationService(configurationService);
    }

    private void doUseConfigurationService(ConfigurationService configurationService) {
        this._isLoggingOfAdditionalDiagnosticsEnabled = configurationService != null ? PropertyUtil.getBooleanProperty(configurationService, "threadPool.additionalDiagnostics.enabled", true) : true;
    }

    public void setLoggingOfAdditionalDiagnostics(boolean bl) {
        this._isLoggingOfAdditionalDiagnosticsEnabled = bl;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        this._currentTasks.add(new TaskDescriptor(runnable, System.nanoTime()));
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        this._currentTasks.remove(new TaskDescriptor(runnable, -1L));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return new DiagnosticFutureTask<T>(runnable, t);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new DiagnosticFutureTask<T>(callable);
    }

    @Override
    public void execute(Runnable runnable) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Executing task: " + runnable));
        }
        runnable = new DiagnosticRunnableTask(runnable);
        super.execute(runnable);
    }

    @Override
    public Collection<TaskDescriptor> getCurrentlyExecutingTasks() {
        return new ArrayList<TaskDescriptor>(this._currentTasks);
    }

    public long getRejectedTasksCount() {
        long l = this._rejectedTasksCounter.get();
        return l;
    }

    public long getDelayedTasksCount() {
        long l = this._delayedTasksCounter.get();
        return l;
    }

    private void appendAdditionalDiagnosticsIfNotTooSoon(StringBuilder stringBuilder) {
        block2: {
            long l;
            long l2;
            boolean bl;
            if (this._minNanosApartForLoggingAdditionalDiagnostics < 0L) {
                return;
            }
            do {
                l2 = this._nanoTimeOfLatestLoggingOfAdditionalDiagnostics.get();
                l = System.nanoTime();
                if (l < l2 + this._minNanosApartForLoggingAdditionalDiagnostics) break block2;
            } while (!(bl = this._nanoTimeOfLatestLoggingOfAdditionalDiagnostics.compareAndSet(l2, l)));
            Collection<TaskDescriptor> collection = this.getCurrentlyExecutingTasks();
            stringBuilder.append("\nCurrently executing tasks: ").append(collection);
        }
    }

    private void handleStartOfTaskExecution(long l, Runnable runnable, Callable<?> callable) {
        try {
            long l2 = System.nanoTime() - l;
            if (this._queueWaitTimeThresholdNanos > 0L && l2 > this._queueWaitTimeThresholdNanos) {
                long l3 = this._delayedTasksCounter.getAndIncrement();
                StringBuilder stringBuilder = new StringBuilder(100);
                stringBuilder.append("A task waited too long to be executed: ").append(TimeUnit.NANOSECONDS.toMillis(l2)).append(" ms. Task: ");
                if (runnable != null) {
                    stringBuilder.append(runnable.toString());
                } else if (callable != null) {
                    stringBuilder.append(callable.toString());
                }
                if (this._isLoggingOfAdditionalDiagnosticsEnabled && Config.THREAD_POOL_LOG_CURR_EXEC_TASKS_ENABLED && this._delayedTaskStepSizeForLoggingAdditionalDiagnostics > 0 && l3 % (long)this._delayedTaskStepSizeForLoggingAdditionalDiagnostics == 0L) {
                    this.appendAdditionalDiagnosticsIfNotTooSoon(stringBuilder);
                }
                String string = stringBuilder.toString();
                _logger.warn((Object)string);
                if (this._taskDelayedListener != null) {
                    if (runnable != null) {
                        this._taskDelayedListener.taskDelayed(runnable, string);
                    } else if (callable != null) {
                        this._taskDelayedListener.taskDelayed(callable, string);
                    }
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to log diagnostics for task " + this.toString()), (Throwable)exception);
        }
    }

    public static Builder builder(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        return new Builder(n, n2, l, timeUnit, blockingQueue, threadFactory);
    }

    public static class Builder {
        private int _corePoolSize;
        private int _maximumPoolSize;
        private long _keepAliveTime;
        private TimeUnit _timeUnit;
        private BlockingQueue<Runnable> _workQueue;
        private ThreadFactory _threadFactory;
        private ConfigurationService _configurationService;
        private long _queueWaitTimeThresholdNanos = -1L;
        private int _rejectedTaskStepSizeForLoggingAdditionalDiagnostics = -1;
        private int _delayedTaskStepSizeForLoggingAdditionalDiagnostics = -1;
        private long _minNanosApartForLoggingAdditionalDiagnostics = -1L;
        private TaskDelayedListener _taskDelayedListener;
        private TaskRejectedListener _taskRejectedListener;

        public Builder(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
            this._corePoolSize = n;
            this._maximumPoolSize = n2;
            this._keepAliveTime = l;
            this._timeUnit = timeUnit;
            this._workQueue = blockingQueue;
            this._threadFactory = threadFactory;
        }

        public Builder configurationService(ConfigurationService configurationService) {
            this._configurationService = configurationService;
            return this;
        }

        public Builder queueWaitTimeThreshold(long l, TimeUnit timeUnit) {
            this._queueWaitTimeThresholdNanos = timeUnit.toNanos(l);
            return this;
        }

        public Builder delayedTaskStepSizeForLoggingAdditionalDiagnostics(int n) {
            this._delayedTaskStepSizeForLoggingAdditionalDiagnostics = n;
            return this;
        }

        public Builder rejectedTaskStepSizeForLoggingAdditionalDiagnostics(int n) {
            this._rejectedTaskStepSizeForLoggingAdditionalDiagnostics = n;
            return this;
        }

        public Builder minTimeApartForLoggingAdditionalDiagnostics(long l, TimeUnit timeUnit) {
            this._minNanosApartForLoggingAdditionalDiagnostics = timeUnit.toNanos(l);
            return this;
        }

        @VisibleForTesting
        Builder taskDelayedListener(TaskDelayedListener taskDelayedListener) {
            this._taskDelayedListener = taskDelayedListener;
            return this;
        }

        @VisibleForTesting
        Builder taskRejectedListener(TaskRejectedListener taskRejectedListener) {
            this._taskRejectedListener = taskRejectedListener;
            return this;
        }

        public DiagnosticThreadPoolExecutor build() {
            return new DiagnosticThreadPoolExecutor(this._corePoolSize, this._maximumPoolSize, this._keepAliveTime, this._timeUnit, this._workQueue, this._threadFactory, this._configurationService, this._queueWaitTimeThresholdNanos, this._delayedTaskStepSizeForLoggingAdditionalDiagnostics, this._rejectedTaskStepSizeForLoggingAdditionalDiagnostics, this._minNanosApartForLoggingAdditionalDiagnostics, this._taskDelayedListener, this._taskRejectedListener);
        }
    }

    private class LogDiagnosticsAndAbortPolicy
    implements RejectedExecutionHandler {
        private LogDiagnosticsAndAbortPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            long l = DiagnosticThreadPoolExecutor.this._rejectedTasksCounter.getAndIncrement();
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("A task was rejected: ").append(runnable.toString());
            if (DiagnosticThreadPoolExecutor.this._isLoggingOfAdditionalDiagnosticsEnabled && Config.THREAD_POOL_LOG_CURR_EXEC_TASKS_ENABLED && DiagnosticThreadPoolExecutor.this._rejectedTaskStepSizeForLoggingAdditionalDiagnostics > 0 && l % (long)DiagnosticThreadPoolExecutor.this._rejectedTaskStepSizeForLoggingAdditionalDiagnostics == 0L) {
                DiagnosticThreadPoolExecutor.this.appendAdditionalDiagnosticsIfNotTooSoon(stringBuilder);
            }
            String string = stringBuilder.toString();
            _logger.warn((Object)string);
            if (DiagnosticThreadPoolExecutor.this._taskRejectedListener != null) {
                DiagnosticThreadPoolExecutor.this._taskRejectedListener.taskRejected(runnable, string);
            }
            throw new RejectedExecutionException("Task " + runnable.toString() + " rejected from " + threadPoolExecutor.toString());
        }
    }

    private class DiagnosticFutureTask<T>
    extends FutureTask<T> {
        private final Object _originalRunnableOrCallable;

        public DiagnosticFutureTask(Callable<T> callable) {
            super(callable);
            this._originalRunnableOrCallable = callable;
        }

        public DiagnosticFutureTask(Runnable runnable, T t) {
            super(runnable, t);
            this._originalRunnableOrCallable = runnable;
        }

        @Override
        public String toString() {
            return this._originalRunnableOrCallable.toString();
        }
    }

    private class DiagnosticRunnableTask
    implements Runnable {
        private final Runnable _runnable;
        private final long _creationTimeNanos;

        DiagnosticRunnableTask(Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this._runnable = runnable;
            this._creationTimeNanos = System.nanoTime();
        }

        @Override
        public void run() {
            DiagnosticThreadPoolExecutor.this.handleStartOfTaskExecution(this._creationTimeNanos, this._runnable, null);
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("Starting execution of task " + this._runnable));
            }
            this._runnable.run();
        }

        public String toString() {
            return this._runnable.toString();
        }
    }

    @VisibleForTesting
    static interface TaskRejectedListener {
        public void taskRejected(Runnable var1, String var2);
    }

    @VisibleForTesting
    static interface TaskDelayedListener {
        public void taskDelayed(Runnable var1, String var2);

        public void taskDelayed(Callable<?> var1, String var2);
    }
}

