/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.debug;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TimeMonitor {
    private static final Log _logger = LogFactory.getLog(TimeMonitor.class);
    private long _initTime;

    public void init() {
        this._initTime = System.nanoTime();
    }

    public void logTime(String string) {
        long l = System.nanoTime();
        long l2 = l - this._initTime;
        long l3 = TimeUnit.NANOSECONDS.toMillis(l2);
        _logger.info((Object)(string + ": " + l3 + " milliseconds"));
    }

    public void logTimeIfExceeding(@Nonnegative long l, @Nullable String string, @Nonnull Class<?> clazz, @Nonnull Object object) {
        long l2 = System.nanoTime();
        if (l < 0L) {
            throw new IllegalArgumentException("thresholdInNanos is negative");
        }
        long l3 = l2 - this._initTime;
        if (l3 > l) {
            String string2;
            long l4 = TimeUnit.NANOSECONDS.toMillis(l3);
            String string3 = object.getClass().getCanonicalName();
            if (string3 == null) {
                string3 = object.getClass().getName();
            }
            try {
                string2 = object.toString();
            }
            catch (Exception exception) {
                _logger.error((Object)("Can't compute instanceName for an instance of class " + string3), (Throwable)exception);
                string2 = "???";
            }
            _logger.warn((Object)((string != null ? string + ": " : "") + clazz.getSimpleName() + " " + string2 + " took too long: " + l4 + " milliseconds  (" + string3 + ")"));
        }
    }
}

