/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.debug.thread;

import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadUsageDumper {
    private static final Log _logger = LogFactory.getLog(ThreadUsageDumper.class);
    private final long _threadCountStep;
    private final long _fullDumpEveryNIterations;
    private final ReentrantLock _lock = new ReentrantLock();
    @GuardedBy(value="_lock")
    private long _threadCountDumpTrigger;
    @GuardedBy(value="_lock")
    private long _performedThreadDumps;

    public ThreadUsageDumper(@Nonnull ConfigurationService configurationService) {
        this._threadCountStep = PropertyUtil.getLongProperty(configurationService, "ThreadUsageDumper.threadCountStep", -1L);
        this._fullDumpEveryNIterations = PropertyUtil.getLongProperty(configurationService, "ThreadUsageDumper.fullDumpEveryNIterations", -1L);
        this._lock.lock();
        try {
            this._threadCountDumpTrigger = this._threadCountStep < 0L ? Long.MAX_VALUE : 1000L;
            this._performedThreadDumps = 0L;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpThreadsIfNeeded(ThreadMXBean threadMXBean) {
        if (!this._lock.tryLock()) {
            return;
        }
        long l = threadMXBean.getThreadCount();
        if (l < this._threadCountDumpTrigger) {
            return;
        }
        long l2 = System.currentTimeMillis();
        try {
            long l3 = this._threadCountDumpTrigger;
            this._threadCountDumpTrigger += this._threadCountStep;
            ThreadInfosAndComputationStats threadInfosAndComputationStats = this.getThreadInfos(threadMXBean);
            ThreadInfo[] threadInfoArray = threadInfosAndComputationStats.threadInfos;
            String string = threadInfosAndComputationStats.computationStats;
            StringBuilder stringBuilder = new StringBuilder("The limit of " + l3 + " threads reached. ");
            stringBuilder.append("Next limit will be " + this._threadCountDumpTrigger + ". ");
            stringBuilder.append("Dumping all current threads:\n");
            long l4 = 0L;
            for (ThreadInfo threadInfo : threadInfoArray) {
                if (threadInfo == null) continue;
                stringBuilder.append(threadInfo.toString());
                ++l4;
            }
            long l5 = System.currentTimeMillis();
            _logger.info((Object)String.format("------------------- DUMPING BEGIN HERE -------------------\n%s\n------------------- DUMPING END HERE -------------------\nDumping total of %d threads took: %d ms.\n%s", stringBuilder, l4, l5 - l2, string));
            ++this._performedThreadDumps;
        }
        catch (Exception exception) {
            long l6 = System.currentTimeMillis();
            _logger.error((Object)("Dumping threads took: " + (l6 - l2) + " ms. and failed with error."), (Throwable)exception);
        }
        finally {
            this._lock.unlock();
        }
    }

    private ThreadInfosAndComputationStats getThreadInfos(ThreadMXBean threadMXBean) {
        ThreadInfo[] threadInfoArray = null;
        String string = null;
        if (this.isTimeForFullDump()) {
            long l = System.nanoTime();
            threadInfoArray = threadMXBean.dumpAllThreads(false, false);
            long l2 = System.nanoTime() - l;
            string = "Invocation of dumpAllThreads() took " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms";
        } else {
            long l = System.nanoTime();
            long[] lArray = threadMXBean.getAllThreadIds();
            threadInfoArray = threadMXBean.getThreadInfo(lArray);
            long l3 = System.nanoTime() - l;
            string = "Invocation of getAllThreadIds() & getThreadInfo() took " + TimeUnit.NANOSECONDS.toMillis(l3) + " ms";
        }
        return new ThreadInfosAndComputationStats(threadInfoArray, string);
    }

    private boolean isTimeForFullDump() {
        return this._fullDumpEveryNIterations > 0L && this._performedThreadDumps % this._fullDumpEveryNIterations == 0L;
    }

    private class ThreadInfosAndComputationStats {
        public final ThreadInfo[] threadInfos;
        public final String computationStats;

        public ThreadInfosAndComputationStats(ThreadInfo[] threadInfoArray, String string) {
            this.threadInfos = threadInfoArray;
            this.computationStats = string;
        }
    }
}

