/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.feature.impl;

import com.vmware.vise.util.feature.FeatureState;
import com.vmware.vise.util.feature.FeatureStateProvider;
import com.vmware.vise.util.feature.FeatureUtil;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.util.io.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;

public class FileConfigFeatureStateProvider
implements FeatureStateProvider {
    private final File _configFile;

    public FileConfigFeatureStateProvider(String string) {
        this._configFile = new File(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Feature, FeatureState> buildFeatureStateMap() {
        EnumMap<Feature, FeatureState> enumMap;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this._configFile);
            properties.load(fileInputStream);
            EnumMap<Feature, FeatureState> enumMap2 = new EnumMap<Feature, FeatureState>(Feature.class);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Feature feature = FeatureUtil.getFeature(entry.getKey().toString());
                if (feature == null) continue;
                String string = entry.getValue().toString().trim();
                FeatureState featureState = FeatureUtil.parseFeatureState(string);
                enumMap2.put(feature, featureState);
            }
            enumMap = enumMap2;
        }
        catch (IOException iOException) {
            Map<Feature, FeatureState> map;
            try {
                map = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                StreamUtil.close(fileInputStream);
                throw throwable;
            }
            StreamUtil.close(fileInputStream);
            return map;
        }
        StreamUtil.close(fileInputStream);
        return enumMap;
    }

    @Override
    public Map<Feature, FeatureState> getAllFeatures() {
        return this.buildFeatureStateMap();
    }
}

