/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.i18n;

import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.I18nFactory;
import com.vmware.vise.util.i18n.MessageLocalizer;
import com.vmware.vise.util.i18n.ResourceManager;
import com.vmware.vise.util.session.SessionUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourceUtil {
    public static final String RESOURCE_MANAGER_KEY = "resourceManager";
    public static final String APPLICATION_LOCALE_KEY = "applicationLocale";
    private static final String LOCALE_QUERY_PARAM = "locale";
    public static final Locale DEFAULT_LOCALE = new Locale("en", "US");
    private static final String RESOURCE_MANIFEST_URI = "config/resources.xml";
    private static final String LOCALIZATION_KEY_PREFIX = "${";
    private static final String LOCALIZATION_KEY_SUFFIX = "}";
    private static final Log _logger = LogFactory.getLog(ResourceUtil.class);
    private static final DocumentBuilderFactorySource _builderFactorySource = DocumentBuilderFactorySource.INSTANCE;
    private static final AtomicReference<Document> cachedDoc = new AtomicReference<Object>(null);

    public static String getString(String string, String string2, ClassLoader classLoader) {
        ResourceManager resourceManager = ResourceUtil.getResourceManager();
        String string3 = resourceManager.getString(string, string2, classLoader);
        return string3;
    }

    public static String getString(String string, String string2) {
        ResourceManager resourceManager = ResourceUtil.getResourceManager();
        String string3 = resourceManager.getString(string, string2, null);
        return string3;
    }

    public static String getString(String string, String string2, String[] stringArray, ClassLoader classLoader) {
        ResourceManager resourceManager = ResourceUtil.getResourceManager();
        String string3 = resourceManager.getString(string, string2, stringArray, classLoader);
        return string3;
    }

    public static Locale getLocale(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter(LOCALE_QUERY_PARAM);
        if (string != null && !string.isEmpty()) {
            Locale locale = ResourceUtil.parseLocale(string);
            return locale;
        }
        Locale locale = ResourceUtil.getLocale(httpServletRequest.getSession());
        if (locale != null) {
            return locale;
        }
        locale = httpServletRequest.getLocale();
        return locale;
    }

    public static Locale getLocale() {
        Locale locale = ResourceUtil.getLocale((HttpSession)null);
        return locale != null ? locale : DEFAULT_LOCALE;
    }

    private static Locale getLocale(HttpSession httpSession) {
        Locale locale = (Locale)SessionUtil.getData(APPLICATION_LOCALE_KEY, httpSession);
        if (locale != null) {
            return locale;
        }
        if (httpSession == null) {
            httpSession = SessionUtil.getHttpSession();
        }
        if (httpSession != null && (locale = (Locale)httpSession.getAttribute(APPLICATION_LOCALE_KEY)) != null) {
            SessionUtil.setData(APPLICATION_LOCALE_KEY, (Object)locale, httpSession, false);
        }
        return locale;
    }

    public static void extractAndSaveLocale(HttpServletRequest httpServletRequest) {
        Locale locale = ResourceUtil.getLocale(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        SessionUtil.setData(APPLICATION_LOCALE_KEY, (Object)locale, httpSession, false);
        httpSession.setAttribute(APPLICATION_LOCALE_KEY, (Object)locale);
    }

    public static Locale getVerifiedAppLocale(HttpServletRequest httpServletRequest) {
        Locale locale = null;
        Locale locale2 = ResourceUtil.getLocale(httpServletRequest);
        try {
            Document document = ResourceUtil.getLocaleDocument(httpServletRequest);
            NodeList nodeList = document.getElementsByTagName("locales");
            block2: for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    String string;
                    Node node = nodeList2.item(j);
                    if (node.getNodeType() != 1 || (string = node.getTextContent().trim()).isEmpty()) continue;
                    if (locale2.toString().equals(string)) {
                        locale = locale2;
                        continue block2;
                    }
                    if (locale != null) continue;
                    String string2 = null;
                    Node node2 = null;
                    if (node.hasAttributes() && (node2 = node.getAttributes().getNamedItem("lang")) != null) {
                        string2 = node2.getTextContent().trim();
                    } else {
                        Locale locale3 = ResourceUtil.parseLocale(string);
                        string2 = locale3.getLanguage();
                    }
                    if (string2 == null || !string2.equals(locale2.getLanguage())) continue;
                    locale = ResourceUtil.parseLocale(string);
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        return locale;
    }

    private static Document getLocaleDocument(HttpServletRequest httpServletRequest) throws SAXException, IOException {
        Document document = cachedDoc.get();
        if (document == null) {
            DocumentBuilder documentBuilder = _builderFactorySource.createDocumentBuilder();
            document = documentBuilder.parse(httpServletRequest.getServletContext().getResourceAsStream(RESOURCE_MANIFEST_URI));
            cachedDoc.compareAndSet(null, document);
        }
        return document;
    }

    private static ResourceManager getResourceManager() {
        ResourceManager resourceManager = (ResourceManager)SessionUtil.getData(RESOURCE_MANAGER_KEY);
        if (resourceManager == null) {
            Locale locale = ResourceUtil.getLocale();
            resourceManager = I18nFactory.newResourceManager(locale);
            SessionUtil.setData(RESOURCE_MANAGER_KEY, (Object)resourceManager, false);
        }
        return resourceManager;
    }

    public static String localizeString(String string, MessageLocalizer messageLocalizer) throws ParseException {
        if (string == null) {
            return null;
        }
        if (messageLocalizer == null) {
            return string;
        }
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder(n + 50);
        while (n2 < n) {
            n3 = string.indexOf(LOCALIZATION_KEY_PREFIX, n2);
            if (n3 < 0) {
                if (n2 == 0) {
                    return string;
                }
                stringBuilder.append(string.substring(n2));
                break;
            }
            int n5 = n3 + LOCALIZATION_KEY_PREFIX.length();
            n4 = string.indexOf(LOCALIZATION_KEY_SUFFIX, n5);
            if (n4 > 0) {
                if (n4 == n5) {
                    throw new ParseException("Empty key detected at position " + (n3 + 1) + " in: " + string, n3);
                }
                String string2 = string.substring(n5, n4);
                String string3 = messageLocalizer.getMessage(string2);
                if (string3 == null) {
                    string3 = "";
                }
                stringBuilder.append(string.substring(n2, n3)).append(string3);
                n2 = n4 + LOCALIZATION_KEY_SUFFIX.length();
                continue;
            }
            throw new ParseException("Non-terminated message key detected at position " + (n3 + 1) + " in: " + string, n3);
        }
        return stringBuilder.toString();
    }

    public static String wrapIntoLocalizableTags(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            return string;
        }
        String string2 = LOCALIZATION_KEY_PREFIX + string + LOCALIZATION_KEY_SUFFIX;
        return string2;
    }

    public static Locale parseLocale(String string) {
        string = string.replace('_', '-');
        String[] stringArray = string.split("-");
        Locale locale = null;
        locale = stringArray.length == 2 ? new Locale(stringArray[0], stringArray[1]) : new Locale(string);
        return locale;
    }
}

