/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.internal;

import com.vmware.vise.util.Pair;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    private static final String CONFIG_FILE_NAME = "java-util.properties";
    public static final int SIMPLE_HTTP_CLIENT_CONNECT_TIMEOUT;
    public static final int SIMPLE_HTTP_CLIENT_READ_TIMEOUT;
    public static final List<Pair<String, String>> OP_ID_LOGGING_METHODS_TRACE_LEVEL;
    public static final List<Pair<String, String>> OP_ID_LOGGING_METHODS_WHITELIST_SLOW;
    public static final int CUSTOMIZED_HTTP_REQ_RETRY_LOG_AT_WARN_LEVEL_INTERVAL;
    public static final boolean THREAD_POOL_LOG_CURR_EXEC_TASKS_ENABLED;
    public static final boolean OP_ID__LOG_REMOTE_ADDR;
    public static final boolean OP_ID__LOG_LOCAL_ADDR;
    public static final boolean OP_ID__LOG_SERVER_ADDR;

    private static List<Pair<String, String>> parseOpIdLoggingMethodsForTraceLevel(String string) {
        String[] stringArray;
        if (StringUtil.isNullOrWhitespace(string)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>(5);
        for (String string2 : stringArray = string.split(",")) {
            int n = string2.lastIndexOf(".");
            if (n <= 0 || n >= string2.length() - 1) {
                _logger.error((Object)("Invalid TRACE-level method name: " + string2));
                continue;
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            Pair<String, String> pair = new Pair<String, String>(string3, string4, true);
            arrayList.add(pair);
        }
        return arrayList;
    }

    static {
        ClassLoader classLoader = Config.class.getClassLoader();
        Properties properties = PropertyUtil.loadProperties(classLoader, CONFIG_FILE_NAME);
        if (properties == null) {
            _logger.warn((Object)"Properties file not found. Will use System properties or, if they are not specified or not valid, will use defaults.");
        }
        SIMPLE_HTTP_CLIENT_CONNECT_TIMEOUT = PropertyUtil.getIntProperty(properties, "simpleHttpClient.connect.timeout", 10000);
        SIMPLE_HTTP_CLIENT_READ_TIMEOUT = PropertyUtil.getIntProperty(properties, "simpleHttpClient.read.timeout", 30000);
        String string = properties.getProperty("opId.logging.methods.traceLevel");
        OP_ID_LOGGING_METHODS_TRACE_LEVEL = Config.parseOpIdLoggingMethodsForTraceLevel(string);
        string = properties.getProperty("opId.logging.methods.whitelist.slow");
        OP_ID_LOGGING_METHODS_WHITELIST_SLOW = Config.parseOpIdLoggingMethodsForTraceLevel(string);
        CUSTOMIZED_HTTP_REQ_RETRY_LOG_AT_WARN_LEVEL_INTERVAL = PropertyUtil.getIntProperty(properties, "CustomizedDefaultHttpRequestRetryHandler.logAtWarnLevel.interval", 10);
        THREAD_POOL_LOG_CURR_EXEC_TASKS_ENABLED = PropertyUtil.getBooleanProperty(properties, "ThreadPool.log.currentlyExecutingTasks.enabled", true);
        String string2 = "opId.logging.request.addr";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = properties.getProperty(string2);
        if (!StringUtil.isNullOrWhitespace(string3)) {
            String[] stringArray;
            block10: for (String string4 : stringArray = string3.split(",")) {
                if ("".equals(string4 = string4.trim())) continue;
                switch (string4) {
                    case "REMOTE_ADDR": {
                        bl = true;
                        continue block10;
                    }
                    case "LOCAL_ADDR": {
                        bl2 = true;
                        continue block10;
                    }
                    case "SERVER_ADDR": {
                        bl3 = true;
                        continue block10;
                    }
                    default: {
                        String string5 = "Unsupported token for property '" + string2 + "': " + string4;
                        _logger.error((Object)string5);
                        throw new ExceptionInInitializerError(string5);
                    }
                }
            }
        }
        OP_ID__LOG_REMOTE_ADDR = bl;
        OP_ID__LOG_LOCAL_ADDR = bl2;
        OP_ID__LOG_SERVER_ADDR = bl3;
    }
}

