/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.jsp;

import com.vmware.vise.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class JspFilter
extends OncePerRequestFilter {
    private static final Log _logger = LogFactory.getLog(JspFilter.class);
    private static final String NOT_FOUND_PAGE_PATH = "/notfound.jsp";
    private static final Pattern URL_PATTERN = Pattern.compile(Pattern.quote("web-inf") + "|" + Pattern.quote("meta-inf"), 2);

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String string;
        if (_logger.isTraceEnabled()) {
            string = httpServletRequest.getRequestURL().toString();
            _logger.trace((Object)("JspFilter is handling an HTTP request: " + string));
        }
        if (StringUtil.isNullOrEmpty(string = httpServletRequest.getRequestURI())) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (string.contains("*") || string.endsWith(".")) {
            httpServletRequest.getRequestDispatcher(NOT_FOUND_PAGE_PATH).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String string2 = httpServletRequest.getCharacterEncoding();
        if (string2 == null) {
            string2 = "UTF-8";
        }
        try {
            String string3 = URLDecoder.decode(string, string2);
            if (Character.isWhitespace(string3.charAt(string3.length() - 1))) {
                httpServletRequest.getRequestDispatcher(NOT_FOUND_PAGE_PATH).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            httpServletRequest.getRequestDispatcher(NOT_FOUND_PAGE_PATH).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (URL_PATTERN.matcher(string).find()) {
            _logger.error((Object)("The requestUri contains forbidden paths like web-inf or meta-inf - " + string));
            httpServletRequest.setAttribute("javax.servlet.error.request_uri", (Object)string);
            httpServletRequest.getRequestDispatcher(NOT_FOUND_PAGE_PATH).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String string4 = string.substring(n);
        if (!string4.equalsIgnoreCase(".jsp") || string4.equals(".jsp")) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String string5 = string.substring(0, n) + ".jsp";
        httpServletResponse.sendRedirect(string5);
    }
}

