/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.liveupdates;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;

public class LiveUpdatesUtil {
    private static final String RECENT_TASKS_ENABLED = "live.updates.enabled";
    private static final String ALARMS_REFRESH_ENABLED = "live.updates.alarms.enabled";
    private static final String NAV_TREE_REFRESH_ENABLED = "live.updates.navtree.enabled";
    private static final String LISTS_REFRESH_ENABLED = "live.updates.lists.enabled";
    private static final String OBJECT_STATE_REFRESH_ENABLED = "live.updates.objectstate.enabled";
    private static final String _60_UPDATE_PROVIDER = "live.updates.alarms.6.0.provider";
    private static final String _PC_BASED_60_UPDATE = "pc";

    public static boolean recentTasksEnabled(ConfigurationService configurationService) {
        return LiveUpdatesUtil.getBooleanKey(configurationService, RECENT_TASKS_ENABLED, true);
    }

    public static boolean alarmsEnabled(ConfigurationService configurationService) {
        return LiveUpdatesUtil.getBooleanKey(configurationService, ALARMS_REFRESH_ENABLED, false);
    }

    public static boolean alarmsPcBasedUpdateEnabled(ConfigurationService configurationService) {
        try {
            return _PC_BASED_60_UPDATE.equals(configurationService.getProperty(_60_UPDATE_PROVIDER));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean navTreeEnabled(ConfigurationService configurationService) {
        return LiveUpdatesUtil.getBooleanKey(configurationService, NAV_TREE_REFRESH_ENABLED, false);
    }

    public static boolean listsEnabled(ConfigurationService configurationService) {
        return LiveUpdatesUtil.getBooleanKey(configurationService, LISTS_REFRESH_ENABLED, false);
    }

    public static boolean objectStateEnabled(ConfigurationService configurationService) {
        return LiveUpdatesUtil.getBooleanKey(configurationService, OBJECT_STATE_REFRESH_ENABLED, false);
    }

    public static boolean resourceChangesEnabled(ConfigurationService configurationService) {
        return LiveUpdatesUtil.objectStateEnabled(configurationService) || LiveUpdatesUtil.listsEnabled(configurationService) || LiveUpdatesUtil.navTreeEnabled(configurationService);
    }

    public static boolean changeLogEnabled(ConfigurationService configurationService) {
        return LiveUpdatesUtil.resourceChangesEnabled(configurationService) || LiveUpdatesUtil.alarmsEnabled(configurationService);
    }

    private static boolean getBooleanKey(ConfigurationService configurationService, String string, boolean bl) {
        String string2 = configurationService.getProperty(string);
        if (StringUtil.isNullOrEmpty(string2)) {
            return bl;
        }
        try {
            return Boolean.parseBoolean(string2);
        }
        catch (Exception exception) {
            return bl;
        }
    }
}

