/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.net.ssl.impl;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

public class SSLConfigurationProviderImpl
implements SSLConfigurationProvider {
    public static final String DEFAULT_PROTOCOL = "TLSv1.2";
    @Nonnull
    private final String _protocol;
    @Nullable
    private final String[] _enabledProtocols;
    @Nullable
    private final String[] _enabledCipherSuites;

    public SSLConfigurationProviderImpl() {
        this(DEFAULT_PROTOCOL, null, null);
    }

    public SSLConfigurationProviderImpl(@Nullable String string, @Nullable String[] stringArray, @Nullable String[] stringArray2) {
        if (string == null) {
            string = DEFAULT_PROTOCOL;
        } else {
            Validate.isTrue((!StringUtil.isNullOrWhitespace(string) ? 1 : 0) != 0, (String)"'protocol' is empty or whitespace");
        }
        if (stringArray != null) {
            ValidationUtil.noNullOrWhitespaceElements(stringArray, false);
        }
        if (stringArray2 != null) {
            ValidationUtil.noNullOrWhitespaceElements(stringArray2, false);
        }
        this._protocol = string;
        this._enabledProtocols = stringArray;
        this._enabledCipherSuites = stringArray2;
    }

    @Override
    @Nonnull
    public String getProtocol() {
        return this._protocol;
    }

    @Override
    @Nullable
    public String[] getEnabledProtocols() {
        return this._enabledProtocols;
    }

    @Override
    @Nullable
    public String[] getEnabledCipherSuites() {
        return this._enabledCipherSuites;
    }
}

