/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.os;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WindowsRegistryUtils {
    private static final Integer KEY_READ = new Integer(131097);
    private static final Log _logger = LogFactory.getLog(WindowsRegistryUtils.class);
    public static final String SHELL_FOLDERS_REGISTRY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    public static final String COMMON_APP_DATA = "Common AppData";

    public static String getSystemValue(String string, String string2) {
        return WindowsRegistryUtils.getValue(true, string, string2);
    }

    public static String getValue(boolean bl, String string, String string2) {
        _logger.debug((Object)("Retrieving registry value: " + string + "\\" + string2));
        Preferences preferences = bl ? Preferences.systemRoot() : Preferences.userRoot();
        String string3 = null;
        try {
            int n = WindowsRegistryUtils.callOpenKey(string, preferences);
            string3 = WindowsRegistryUtils.callWindowsRegQueryValueEx(n, string2, preferences);
            WindowsRegistryUtils.callCloseKey(n, preferences);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        return string3;
    }

    private static int callOpenKey(String string, Preferences preferences) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = preferences.getClass();
        Class[] classArray = new Class[]{byte[].class, Integer.TYPE, Integer.TYPE};
        Method method = clazz.getDeclaredMethod("openKey", classArray);
        method.setAccessible(true);
        Object[] objectArray = new Object[]{WindowsRegistryUtils.stringToByteArray(string), KEY_READ, KEY_READ};
        int n = (Integer)method.invoke((Object)preferences, objectArray);
        return n;
    }

    private static String callWindowsRegQueryValueEx(int n, String string, Preferences preferences) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = preferences.getClass();
        Class[] classArray = new Class[]{Integer.TYPE, byte[].class};
        Method method = clazz.getDeclaredMethod("WindowsRegQueryValueEx", classArray);
        method.setAccessible(true);
        Object[] objectArray = new Object[]{n, WindowsRegistryUtils.stringToByteArray(string)};
        byte[] byArray = (byte[])method.invoke((Object)preferences, objectArray);
        String string2 = byArray != null ? new String(byArray).trim() : null;
        return string2;
    }

    private static void callCloseKey(int n, Preferences preferences) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = preferences.getClass();
        Class[] classArray = new Class[]{Integer.TYPE};
        Method method = clazz.getDeclaredMethod("closeKey", classArray);
        method.setAccessible(true);
        Object[] objectArray = new Object[]{n};
        method.invoke((Object)preferences, objectArray);
    }

    private static byte[] stringToByteArray(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[string.length()] = 0;
        return byArray;
    }
}

