/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.osgi;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.osgi.OSGIUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.virgo.nano.shim.scope.Scope;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class OSGIServiceRegistry
implements ServiceRegistry {
    private static final Log _logger = LogFactory.getLog(OSGIServiceRegistry.class);
    private final BundleContext _bundleContext;
    private final Map<String, Map<com.vmware.vise.util.service.ServiceListener, ServiceTrackerEx>> _serviceTrackers;
    private final Set<BundleContext> _syntheticBundles;
    private final Set<String> _scopes;
    private final VirgoScopeResolver _scopeResolver;
    private final Object _lock = new Object();

    public OSGIServiceRegistry(BundleContext bundleContext) {
        this(bundleContext, null);
    }

    public OSGIServiceRegistry(BundleContext bundleContext, ScopeFactory scopeFactory) {
        this._bundleContext = bundleContext;
        this._serviceTrackers = new ConcurrentHashMap<String, Map<com.vmware.vise.util.service.ServiceListener, ServiceTrackerEx>>();
        this._syntheticBundles = new CopyOnWriteArraySet<BundleContext>();
        this._scopes = new CopyOnWriteArraySet<String>();
        this._scopeResolver = new VirgoScopeResolver(scopeFactory);
        this._bundleContext.addBundleListener((BundleListener)new SyntheticBundleListener());
    }

    public List<Object> getServices(String string) {
        HashSet hashSet = new HashSet();
        ServiceReference<?>[] serviceReferenceArray = this.getServiceReferences(this._bundleContext, string);
        hashSet.addAll(Arrays.asList(serviceReferenceArray));
        for (BundleContext bundleContext : this._syntheticBundles) {
            ServiceReference<?>[] serviceReferenceArray2 = this.getServiceReferences(bundleContext, string);
            hashSet.addAll(Arrays.asList(serviceReferenceArray2));
        }
        List list = OSGIUtil.getServices(hashSet.toArray(new ServiceReference[0]));
        return list;
    }

    private ServiceReference<?>[] getServiceReferences(BundleContext bundleContext, String string) {
        ServiceReference[] serviceReferenceArray = null;
        try {
            serviceReferenceArray = bundleContext.getAllServiceReferences(string, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            _logger.error((Object)invalidSyntaxException.getLocalizedMessage());
        }
        if (serviceReferenceArray == null) {
            serviceReferenceArray = new ServiceReference[]{};
        }
        return serviceReferenceArray;
    }

    public <T> T getService(String string) {
        T t;
        block1: {
            BundleContext bundleContext;
            t = this.getService(string, this._bundleContext);
            if (t != null) break block1;
            Iterator<BundleContext> iterator = this._syntheticBundles.iterator();
            while (iterator.hasNext() && (t = this.getService(string, bundleContext = iterator.next())) == null) {
            }
        }
        return t;
    }

    private <T> T getService(String string, BundleContext bundleContext) {
        ServiceReference serviceReference = bundleContext.getServiceReference(string);
        if (serviceReference == null) {
            return null;
        }
        Object object = bundleContext.getService(serviceReference);
        bundleContext.ungetService(serviceReference);
        return (T)object;
    }

    @Override
    public void registerService(String string, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServiceListener(String string, com.vmware.vise.util.service.ServiceListener serviceListener) {
        ValidationUtil.paramsNotNull(string, serviceListener);
        Object object = this._lock;
        synchronized (object) {
            Map<com.vmware.vise.util.service.ServiceListener, ServiceTrackerEx> map = this._serviceTrackers.get(string);
            if (map == null) {
                map = new ConcurrentHashMap<com.vmware.vise.util.service.ServiceListener, ServiceTrackerEx>();
                this._serviceTrackers.put(string, map);
            }
            if (!map.containsKey(serviceListener)) {
                ServiceTrackerEx serviceTrackerEx = new ServiceTrackerEx(this._bundleContext, string, serviceListener);
                map.put(serviceListener, serviceTrackerEx);
                this.notifyTrackerForScopedServices(serviceTrackerEx, string);
                serviceTrackerEx.open();
            } else {
                this.logDuplicateListener(string, serviceListener);
            }
        }
    }

    private void logDuplicateListener(String string, com.vmware.vise.util.service.ServiceListener serviceListener) {
        _logger.warn((Object)("The " + com.vmware.vise.util.service.ServiceListener.class.getSimpleName() + " " + serviceListener + " is already registered for interface " + string));
    }

    private void notifyTrackerForScopedServices(ServiceTrackerEx serviceTrackerEx, String string) {
        for (BundleContext bundleContext : this._syntheticBundles) {
            ServiceReference<?>[] serviceReferenceArray;
            for (ServiceReference<?> serviceReference : serviceReferenceArray = this.getServiceReferences(bundleContext, string)) {
                if (!this._scopeResolver.isServiceScoped(serviceReference)) continue;
                serviceTrackerEx.addingService(serviceReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregisterServiceListener(String string, com.vmware.vise.util.service.ServiceListener serviceListener) {
        ValidationUtil.paramsNotNull(string, serviceListener);
        Object object = this._lock;
        synchronized (object) {
            Map<com.vmware.vise.util.service.ServiceListener, ServiceTrackerEx> map = this._serviceTrackers.get(string);
            boolean bl = false;
            if (map != null && map.containsKey(serviceListener)) {
                bl = true;
                ServiceTrackerEx serviceTrackerEx = map.remove(serviceListener);
                serviceTrackerEx.close();
            }
            return bl;
        }
    }

    private static class VirgoScopeResolver {
        private static final String SYNTHETIC_CONTEXT_SUFFIX = "-synthetic.context";
        private final ScopeFactory _scopeFactory;

        public VirgoScopeResolver(ScopeFactory scopeFactory) {
            this._scopeFactory = scopeFactory;
        }

        public <T> boolean isServiceScoped(ServiceReference<T> serviceReference) {
            return this._scopeFactory != null && !this._scopeFactory.getServiceScope(serviceReference).isGlobal();
        }

        public boolean isBundleScoped(Bundle bundle) {
            return this._scopeFactory != null && !this._scopeFactory.getBundleScope(bundle).isGlobal();
        }

        public String getScopeName(Bundle bundle) {
            if (this._scopeFactory == null) {
                return "global";
            }
            Scope scope = this._scopeFactory.getBundleScope(bundle);
            return scope == null ? "global" : scope.getScopeName();
        }

        public boolean isBundleSynthetic(Bundle bundle) {
            if (this._scopeFactory == null) {
                return false;
            }
            Scope scope = this._scopeFactory.getBundleScope(bundle);
            return scope != null && bundle.getSymbolicName().equals(scope.getScopeName() + SYNTHETIC_CONTEXT_SUFFIX);
        }
    }

    class UnregisterScopedServiceListener
    implements ServiceListener {
        UnregisterScopedServiceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent serviceEvent) {
            String[] stringArray;
            ServiceReference serviceReference = serviceEvent.getServiceReference();
            if (OSGIServiceRegistry.this._scopeResolver.isServiceScoped(serviceReference) && serviceEvent.getType() == 4 && (stringArray = (String[])serviceReference.getProperty("objectClass")) != null) {
                Object object = OSGIServiceRegistry.this._bundleContext.getService(serviceReference);
                if (object == null) {
                    _logger.warn((Object)("Detected a null service for the scoped service reference " + serviceReference));
                    return;
                }
                OSGIServiceRegistry.this._bundleContext.ungetService(serviceReference);
                Object object2 = OSGIServiceRegistry.this._lock;
                synchronized (object2) {
                    for (String string : stringArray) {
                        Map map = (Map)OSGIServiceRegistry.this._serviceTrackers.get(string);
                        if (map == null) continue;
                        for (ServiceTrackerEx serviceTrackerEx : map.values()) {
                            serviceTrackerEx.removedService((ServiceReference<String>)serviceReference, object);
                        }
                    }
                }
            }
        }
    }

    class RegisterScopedServiceListener
    implements ServiceListener {
        RegisterScopedServiceListener() {
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            ServiceReference serviceReference = serviceEvent.getServiceReference();
            if (OSGIServiceRegistry.this._scopeResolver.isServiceScoped(serviceReference) && serviceEvent.getType() == 1) {
                String[] stringArray = (String[])serviceReference.getProperty("objectClass");
                if (stringArray == null) {
                    return;
                }
                for (String string : stringArray) {
                    Map map = (Map)OSGIServiceRegistry.this._serviceTrackers.get(string);
                    if (map == null) continue;
                    for (ServiceTrackerEx serviceTrackerEx : map.values()) {
                        serviceTrackerEx.addingService((ServiceReference<String>)serviceReference);
                    }
                }
            }
        }
    }

    private class SyntheticBundleListener
    implements SynchronousBundleListener {
        private SyntheticBundleListener() {
        }

        public void bundleChanged(BundleEvent bundleEvent) {
            Bundle bundle = bundleEvent.getBundle();
            if (OSGIServiceRegistry.this._scopeResolver.isBundleScoped(bundle)) {
                String string = OSGIServiceRegistry.this._scopeResolver.getScopeName(bundle);
                if (bundleEvent.getType() == 128) {
                    BundleContext bundleContext = bundle.getBundleContext();
                    if (!OSGIServiceRegistry.this._scopes.contains(string)) {
                        bundleContext.addServiceListener((ServiceListener)new RegisterScopedServiceListener());
                        OSGIServiceRegistry.this._scopes.add(string);
                    }
                    if (OSGIServiceRegistry.this._scopeResolver.isBundleSynthetic(bundle)) {
                        OSGIServiceRegistry.this._syntheticBundles.add(bundleContext);
                        bundleContext.addServiceListener((ServiceListener)new UnregisterScopedServiceListener());
                    }
                } else if (bundleEvent.getType() == 256) {
                    OSGIServiceRegistry.this._syntheticBundles.remove(bundle.getBundleContext());
                    OSGIServiceRegistry.this._scopes.remove(string);
                }
            }
        }
    }

    private static class ServiceTrackerEx
    extends ServiceTracker<String, Object> {
        private final com.vmware.vise.util.service.ServiceListener _serviceListener;
        private volatile boolean _closing = false;
        private Set<Object> _addedServices;
        private final Object _innerLock = new Object();

        public ServiceTrackerEx(BundleContext bundleContext, String string, com.vmware.vise.util.service.ServiceListener serviceListener) {
            super(bundleContext, string, null);
            ValidationUtil.paramsNotNull(serviceListener);
            this._serviceListener = serviceListener;
            this._addedServices = new HashSet<Object>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference<String> serviceReference) {
            Object object = super.addingService(serviceReference);
            if (object != null) {
                try {
                    Object object2 = this._innerLock;
                    synchronized (object2) {
                        if (!this._closing && !this._addedServices.contains(object)) {
                            this._serviceListener.serviceAdded(object);
                            this._addedServices.add(object);
                        }
                    }
                }
                catch (Exception exception) {
                    _logger.error((Object)(com.vmware.vise.util.service.ServiceListener.class.getSimpleName() + " " + this._serviceListener + " failed when adding reference " + serviceReference), (Throwable)exception);
                }
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<String> serviceReference, Object object) {
            try {
                Object object2 = this._innerLock;
                synchronized (object2) {
                    if (!this._closing && this._addedServices.contains(object)) {
                        this._serviceListener.serviceRemoved(object);
                        this._addedServices.remove(object);
                    }
                }
            }
            catch (Exception exception) {
                _logger.error((Object)(com.vmware.vise.util.service.ServiceListener.class.getSimpleName() + " " + this._serviceListener + " failed when removing reference " + serviceReference), (Throwable)exception);
            }
            super.removedService(serviceReference, object);
        }

        public ServiceReference<String>[] getServiceReferences() {
            return this._closing ? null : super.getServiceReferences();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this._innerLock;
            synchronized (object) {
                this._closing = true;
            }
            super.close();
        }
    }
}

