/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.transform;

import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import com.vmware.vise.util.collection.TreeIterator;
import com.vmware.vise.util.transform.TransformUtil;
import com.vmware.vise.util.transform.TransformationException;
import com.vmware.vise.util.transform.Transformer;

public class TreeTransformer<T>
implements Transformer<Tree<T>> {
    private final Transformer<Node<T>> _transformer;

    public TreeTransformer(Transformer<Node<T>> transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Invalid transformer.");
        }
        this._transformer = transformer;
    }

    @Override
    public Transformer.Result<Tree<T>> transform(Tree<T> tree) {
        boolean bl = false;
        TransformationException transformationException = null;
        TreeIterator<T> treeIterator = tree.iterator();
        while (treeIterator.hasNext()) {
            Node node = (Node)treeIterator.next();
            Transformer.Result<Node<T>> result = this.transformNode(treeIterator, node);
            bl = bl || result.isTransformed();
            transformationException = TransformUtil.getCompositeError(transformationException, result.getError());
        }
        return new Transformer.Result<Tree<T>>(tree, bl, transformationException);
    }

    private Transformer.Result<Node<T>> transformNode(TreeIterator<T> treeIterator, Node<T> node) {
        Transformer.Result<Node<T>> result = this._transformer.transform(node);
        Node<T> node2 = result.getData();
        if (result.isTransformed()) {
            treeIterator.set(node2);
        }
        return result;
    }
}

