/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.xml;

import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class XmlStreamUtils {
    private static final Log _logger = LogFactory.getLog(XmlStreamUtils.class);

    public static String getNodeContentFromXmlStream(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        ValidationUtil.paramsNotNull(xMLStreamReader);
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(stringWriter);
        int n = 0;
        do {
            XmlStreamUtils.processElement(xMLStreamReader, xMLStreamWriter);
            switch (xMLStreamReader.getEventType()) {
                case 1: {
                    ++n;
                    break;
                }
                case 2: {
                    --n;
                    break;
                }
            }
            xMLStreamReader.next();
        } while (n > 0 && xMLStreamReader.hasNext());
        if (n > 0) {
            _logger.debug((Object)"getNodeContentFromXmlStream: matching end tag not found");
        }
        xMLStreamWriter.flush();
        return ((Object)stringWriter).toString();
    }

    public static String printEvent(XMLStreamReader xMLStreamReader) {
        ValidationUtil.paramsNotNull(xMLStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EVENT:[" + xMLStreamReader.getLocation().getLineNumber() + "][" + xMLStreamReader.getLocation().getColumnNumber() + "] ");
        stringBuffer.append(XmlStreamUtils.getName(xMLStreamReader.getEventType()));
        stringBuffer.append(" [");
        switch (xMLStreamReader.getEventType()) {
            case 1: {
                int n;
                stringBuffer.append("<");
                XmlStreamUtils.printName(xMLStreamReader, stringBuffer);
                for (n = 0; n < xMLStreamReader.getNamespaceCount(); ++n) {
                    stringBuffer.append(" ");
                    String string = xMLStreamReader.getNamespacePrefix(n);
                    if ("xmlns".equals(string)) {
                        stringBuffer.append("xmlns=\"" + xMLStreamReader.getNamespaceURI(n) + "\"");
                        continue;
                    }
                    stringBuffer.append("xmlns:" + string);
                    stringBuffer.append("=\"");
                    stringBuffer.append(xMLStreamReader.getNamespaceURI(n));
                    stringBuffer.append("\"");
                }
                for (n = 0; n < xMLStreamReader.getAttributeCount(); ++n) {
                    stringBuffer.append(" ");
                    XmlStreamUtils.printName(xMLStreamReader.getAttributePrefix(n), xMLStreamReader.getAttributeNamespace(n), xMLStreamReader.getAttributeLocalName(n), stringBuffer);
                    stringBuffer.append("=\"");
                    stringBuffer.append(xMLStreamReader.getAttributeValue(n));
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                break;
            }
            case 2: {
                stringBuffer.append("</");
                XmlStreamUtils.printName(xMLStreamReader, stringBuffer);
                for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
                    stringBuffer.append(" ");
                    String string = xMLStreamReader.getNamespacePrefix(i);
                    if ("xmlns".equals(string)) {
                        stringBuffer.append("xmlns=\"" + xMLStreamReader.getNamespaceURI(i) + "\"");
                        continue;
                    }
                    stringBuffer.append("xmlns:" + string);
                    stringBuffer.append("=\"");
                    stringBuffer.append(xMLStreamReader.getNamespaceURI(i));
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                break;
            }
            case 4: 
            case 6: {
                int n = xMLStreamReader.getTextStart();
                int n2 = xMLStreamReader.getTextLength();
                stringBuffer.append(new String(xMLStreamReader.getTextCharacters(), n, n2));
                break;
            }
            case 3: {
                String string;
                String string2 = xMLStreamReader.getPITarget();
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = xMLStreamReader.getPIData()) == null) {
                    string = "";
                }
                stringBuffer.append("<?");
                stringBuffer.append(string2 + " " + string);
                stringBuffer.append("?>");
                break;
            }
            case 12: {
                stringBuffer.append("<![CDATA[");
                if (xMLStreamReader.hasText()) {
                    stringBuffer.append(xMLStreamReader.getText());
                }
                stringBuffer.append("]]&gt;");
                break;
            }
            case 5: {
                stringBuffer.append("<!--");
                if (xMLStreamReader.hasText()) {
                    stringBuffer.append(xMLStreamReader.getText());
                }
                stringBuffer.append("-->");
                break;
            }
            case 9: {
                stringBuffer.append(xMLStreamReader.getLocalName() + "=");
                if (!xMLStreamReader.hasText()) break;
                stringBuffer.append("[" + xMLStreamReader.getText() + "]");
                break;
            }
            case 7: {
                stringBuffer.append("<?xml");
                stringBuffer.append(" version='" + xMLStreamReader.getVersion() + "'");
                stringBuffer.append(" encoding='" + xMLStreamReader.getCharacterEncodingScheme() + "'");
                if (xMLStreamReader.isStandalone()) {
                    stringBuffer.append(" standalone='yes'");
                } else {
                    stringBuffer.append(" standalone='no'");
                }
                stringBuffer.append("?>");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String getName(int n) {
        switch (n) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 6: {
                return "SPACE";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 13: {
                return "NAMESPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE";
    }

    public static int getType(String string) {
        ValidationUtil.paramsNotNull(string);
        if (string.equals("START_ELEMENT")) {
            return 1;
        }
        if (string.equals("SPACE")) {
            return 6;
        }
        if (string.equals("END_ELEMENT")) {
            return 2;
        }
        if (string.equals("PROCESSING_INSTRUCTION")) {
            return 3;
        }
        if (string.equals("CHARACTERS")) {
            return 4;
        }
        if (string.equals("COMMENT")) {
            return 5;
        }
        if (string.equals("START_DOCUMENT")) {
            return 7;
        }
        if (string.equals("END_DOCUMENT")) {
            return 8;
        }
        if (string.equals("ATTRIBUTE")) {
            return 10;
        }
        if (string.equals("DTD")) {
            return 11;
        }
        if (string.equals("CDATA")) {
            return 12;
        }
        if (string.equals("NAMESPACE")) {
            return 13;
        }
        return -1;
    }

    public static String getAttributeValue(XMLStreamReader xMLStreamReader, String string) {
        ValidationUtil.paramsNotNull(xMLStreamReader);
        if (string == null) {
            return null;
        }
        Pair<String, String> pair = StringUtil.removeLastWord(string, ':');
        String string2 = (String)pair.first;
        String string3 = (String)pair.second;
        if (string3.isEmpty()) {
            return null;
        }
        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
            QName qName = xMLStreamReader.getAttributeName(i);
            if (!qName.getLocalPart().equals(string3) || !qName.getPrefix().equals(string2)) continue;
            return xMLStreamReader.getAttributeValue(i);
        }
        return null;
    }

    public static String getAttributeValue(XMLStreamReader xMLStreamReader, QName qName) {
        ValidationUtil.paramsNotNull(xMLStreamReader);
        if (qName == null) {
            return null;
        }
        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
            QName qName2 = xMLStreamReader.getAttributeName(i);
            if (!qName2.equals(qName)) continue;
            return xMLStreamReader.getAttributeValue(i);
        }
        return null;
    }

    private static void writeStartElement(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        assert (xMLStreamReader != null);
        assert (xMLStreamWriter != null);
        String string = xMLStreamReader.getLocalName();
        xMLStreamWriter.writeStartElement(string);
        XmlStreamUtils.writeNamespaces(xMLStreamReader, xMLStreamWriter);
        XmlStreamUtils.writeAttributes(xMLStreamReader, xMLStreamWriter);
    }

    private static void writeNamespaces(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        assert (xMLStreamReader != null);
        assert (xMLStreamWriter != null);
        for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
            String string = xMLStreamReader.getNamespacePrefix(i);
            String string2 = xMLStreamReader.getNamespaceURI(i);
            xMLStreamWriter.writeNamespace(string, string2);
        }
    }

    private static void writeAttributes(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        assert (xMLStreamReader != null);
        assert (xMLStreamWriter != null);
        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
            String string = xMLStreamReader.getAttributePrefix(i);
            String string2 = xMLStreamReader.getAttributeLocalName(i);
            String string3 = xMLStreamReader.getAttributeNamespace(i);
            String string4 = xMLStreamReader.getAttributeValue(i);
            if (!StringUtil.isNullOrEmpty(string) && !StringUtil.isNullOrEmpty(string3)) {
                xMLStreamWriter.writeAttribute(string, string3, string2, string4);
                continue;
            }
            if (!StringUtil.isNullOrEmpty(string3)) {
                xMLStreamWriter.writeAttribute(string3, string2, string4);
                continue;
            }
            xMLStreamWriter.writeAttribute(string2, string4);
        }
    }

    private static void writeProcessingInstruction(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        assert (xMLStreamReader != null);
        assert (xMLStreamWriter != null);
        String string = xMLStreamReader.getPITarget();
        String string2 = xMLStreamReader.getPIData();
        if (string != null && string2 != null) {
            xMLStreamWriter.writeProcessingInstruction(string, string2);
            return;
        }
        if (string != null) {
            xMLStreamWriter.writeProcessingInstruction(string);
            return;
        }
    }

    private static void printName(String string, String string2, String string3, StringBuffer stringBuffer) {
        assert (stringBuffer != null);
        if (string2 != null && !"".equals(string2)) {
            stringBuffer.append("['" + string2 + "']:");
        }
        if (string != null && !"".equals(string)) {
            stringBuffer.append(string + ":");
        }
        if (string3 != null) {
            stringBuffer.append(string3);
        }
    }

    private static void printName(XMLStreamReader xMLStreamReader, StringBuffer stringBuffer) {
        assert (xMLStreamReader != null);
        assert (stringBuffer != null);
        if (xMLStreamReader.hasName()) {
            String string = xMLStreamReader.getPrefix();
            String string2 = xMLStreamReader.getNamespaceURI();
            String string3 = xMLStreamReader.getLocalName();
            XmlStreamUtils.printName(string, string2, string3, stringBuffer);
        }
    }

    private static void processElement(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        assert (xMLStreamReader != null);
        assert (xMLStreamWriter != null);
        int n = xMLStreamReader.getEventType();
        switch (n) {
            case 1: {
                XmlStreamUtils.writeStartElement(xMLStreamReader, xMLStreamWriter);
                return;
            }
            case 2: {
                xMLStreamWriter.writeEndElement();
                return;
            }
            case 3: {
                XmlStreamUtils.writeProcessingInstruction(xMLStreamReader, xMLStreamWriter);
                return;
            }
            case 4: {
                String string = xMLStreamReader.getText();
                xMLStreamWriter.writeCharacters(string);
                return;
            }
            case 5: {
                String string = xMLStreamReader.getText();
                xMLStreamWriter.writeComment(string);
                return;
            }
            case 7: {
                throw new XMLStreamException("Invalid occurence of start doc tag");
            }
            case 8: {
                throw new XMLStreamException("Invalid occurence of end doc tag");
            }
            case 9: {
                String string = xMLStreamReader.getLocalName();
                xMLStreamWriter.writeEntityRef(string);
                return;
            }
            case 10: {
                return;
            }
            case 11: {
                throw new XMLStreamException("Invalid occurence of dtd tag");
            }
            case 12: {
                String string = xMLStreamReader.getText();
                xMLStreamWriter.writeCharacters(string);
                return;
            }
            case 6: {
                String string = xMLStreamReader.getText();
                xMLStreamWriter.writeCharacters(string);
                return;
            }
        }
    }
}

