/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vapi.std.errors.OperationNotFound;
import com.vmware.vcenter.ovf.Capability;
import com.vmware.vcenter.ovf.CapabilityTypes;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.provisioning.model.AnyComputeResourceData;
import com.vmware.vsphere.client.provisioning.model.ResourcePoolData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OvfDeployPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(OvfDeployPropertyProvider.class);
    private static final String RESOURCE_POOL = "resourcePool";
    static final String VAPP_IMPORT_PRIVILEGE_NAME = "VApp.Import";
    private static final String OWNER_RELATIONSHIP = "owner";
    private static final String DRS_ENABLED = "drsEnabled";
    private static final String ENVIRONMENT_BROWSER = "environmentBrowser";
    private final QueryExecutor _queryExecutor;
    private final Capability _ovfCapability;
    private final QueryService _queryService;

    public OvfDeployPropertyProvider(QueryExecutor queryExecutor, Capability ovfCapability, QueryServiceFactory queryServiceFactory) {
        this._queryExecutor = queryExecutor;
        this._ovfCapability = ovfCapability;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @type(value="Folder,ClusterComputeResource,ResourcePool,VirtualApp,Datacenter")
    public boolean getIsDeployOvfAvailable(ManagedObjectReference target) {
        try {
            if (target == null) {
                _logger.debug((Object)"getIsDeployOvfAvailable: target is null!");
                throw MixedUtil.getInvalidEntityFault();
            }
            if (this.isValidContainerType(target)) {
                return true;
            }
            AnyComputeResourceData computeResourceData = this.getComputeResourceData(target);
            if (!computeResourceData.hasAtleastOneHostConnectedInWorkingState()) {
                return false;
            }
            ResourcePoolData resourcePoolData = this.getPropertiesForResourcePool(computeResourceData);
            Boolean isDeployOvfAvailable = resourcePoolData.isImportVappAvailable() != false && resourcePoolData.hasPrivilegeToImportVapp;
            if (!isDeployOvfAvailable.booleanValue()) {
                return false;
            }
            CapabilityTypes.CapabilityInfo capabilityInfo = this.getCapabilitiesForOvf(target);
            return capabilityInfo.getImportOva();
        }
        catch (Exception e) {
            _logger.debug((Object)e.getMessage());
            return false;
        }
    }

    @type(value="VirtualApp,VirtualMachine")
    public boolean getIsExportOvfAvailable(ManagedObjectReference target) {
        CapabilityTypes.CapabilityInfo capabilityInfo = this.getCapabilitiesForOvf(target);
        return capabilityInfo.getImportOva();
    }

    private ResourcePoolData getPropertiesForResourcePool(AnyComputeResourceData computeResourceData) {
        ResultSet rpResult;
        ResourcePoolData resourcePoolData = null;
        if (computeResourceData == null || computeResourceData.resourcePoolMoRef == null) {
            return resourcePoolData;
        }
        String targetResourcePool = "ResourcePool";
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)computeResourceData.resourcePoolMoRef, VirtualApp.class)) {
            targetResourcePool = "VirtualApp";
        }
        if ((rpResult = this._queryService.select(new String[]{"disabledMethod", "grantedPrivileges"}).from(new String[]{targetResourcePool}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)computeResourceData.resourcePoolMoRef).fetch()).getItems().isEmpty()) {
            return resourcePoolData;
        }
        ResourceItem resourcePoolItem = (ResourceItem)rpResult.getItems().get(0);
        resourcePoolData = new ResourcePoolData();
        resourcePoolData.disabledMethod = (String[])resourcePoolItem.get("disabledMethod");
        resourcePoolData.resourcePoolMoRef = computeResourceData.resourcePoolMoRef;
        String[] grantedPrivileges = (String[])resourcePoolItem.get("grantedPrivileges");
        resourcePoolData.hasPrivilegeToImportVapp = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{VAPP_IMPORT_PRIVILEGE_NAME}, (String[])grantedPrivileges);
        return resourcePoolData;
    }

    private CapabilityTypes.CapabilityInfo getCapabilitiesForOvf(ManagedObjectReference serverObjectRef) {
        try {
            return this._ovfCapability.get(serverObjectRef.getServerGuid());
        }
        catch (OperationNotFound ex) {
            _logger.warn((Object)String.format("CLS Capability interface not found on VC: %s\nReturning a CapabilityInfo with all features disabled.", serverObjectRef));
            CapabilityTypes.CapabilityInfo capabilityInfo = new CapabilityTypes.CapabilityInfo();
            capabilityInfo.setImportOva(false);
            capabilityInfo.setExportOva(false);
            return capabilityInfo;
        }
        catch (Exception ex) {
            _logger.warn((Object)String.format("Error: %s, while checking CLS Capability interface on VC: %s\nReturning a CapabilityInfo with all features disabled.", ex.getMessage(), serverObjectRef), (Throwable)ex);
            CapabilityTypes.CapabilityInfo capabilityInfo = new CapabilityTypes.CapabilityInfo();
            capabilityInfo.setImportOva(false);
            capabilityInfo.setExportOva(false);
            return capabilityInfo;
        }
    }

    private boolean isValidContainerType(ManagedObjectReference target) {
        boolean isValidContainerType = false;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, Datacenter.class)) {
            isValidContainerType = true;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, Folder.class)) {
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)target)) {
                isValidContainerType = true;
            }
            if (ManagedObjectUtil.isVmFolder((ManagedObjectReference)target)) {
                isValidContainerType = true;
            }
        }
        return isValidContainerType;
    }

    private AnyComputeResourceData getComputeResourceData(ManagedObjectReference target) throws Exception {
        if (!OvfDeployPropertyProvider.targetIsValidType(target)) {
            _logger.error((Object)"target is of invalid type!");
            throw new IllegalArgumentException("target is of invalid type: " + target.getType() + " !");
        }
        PropertyValue[] values = this.queryProperties(target);
        return this.buildComputeResourceDataObject(target, values);
    }

    private static boolean targetIsValidType(ManagedObjectReference target) {
        return ManagedObjectUtil.isOfType((ManagedObjectReference)target, ClusterComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualApp.class);
    }

    private PropertyValue[] queryProperties(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, ClusterComputeResource.class)) {
            values = this.queryPropertiesForCluster(target);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualApp.class)) {
            values = this.queryPropertiesForResourcePoolOrVapp(target);
        }
        return values;
    }

    private PropertyValue[] queryPropertiesForCluster(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = this._queryExecutor.getProperties((Object)target, new String[]{RESOURCE_POOL, ENVIRONMENT_BROWSER});
        return values;
    }

    private PropertyValue[] queryPropertiesForResourcePoolOrVapp(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = this._queryExecutor.getPropertiesForRelatedObjects((Object)target, OWNER_RELATIONSHIP, ComputeResource.class.getSimpleName(), new String[]{RESOURCE_POOL, ENVIRONMENT_BROWSER});
        return values;
    }

    private AnyComputeResourceData buildComputeResourceDataObject(ManagedObjectReference target, PropertyValue[] values) {
        if (values == null) {
            _logger.info((Object)"No ComputeResourceData was extracted with the given MOR!");
            return null;
        }
        AnyComputeResourceData data2 = new AnyComputeResourceData();
        for (PropertyValue propertyValue : values) {
            if (RESOURCE_POOL.equals(propertyValue.propertyName)) {
                data2.resourcePoolMoRef = ManagedObjectUtil.isOfType((ManagedObjectReference)target, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualApp.class) ? target : (ManagedObjectReference)propertyValue.value;
            }
            if (DRS_ENABLED.equals(propertyValue.propertyName)) {
                data2.isClusterDrsEnabled = (Boolean)propertyValue.value;
            }
            if (!ENVIRONMENT_BROWSER.equals(propertyValue.propertyName)) continue;
            data2.environmentBrowser = (ManagedObjectReference)propertyValue.value;
        }
        return data2;
    }
}

