/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.logbundle;

import com.vmware.vim.binding.vim.DiagnosticManager;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.messaging.amf.AmfMessageDeserializer;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.logbundle.LogBundleDownloadSpec;
import com.vmware.vsphere.client.logbundle.SelectedLogsSpec;
import com.vmware.vsphere.client.logbundle.UrlZipEntry;
import com.vmware.vsphere.client.logbundle.exception.ReadIOException;
import com.vmware.vsphere.client.logbundle.exception.WriteIOException;
import com.vmware.vsphere.client.logbundle.helper.DownloadingLogsTask;
import com.vmware.vsphere.client.task.TaskRegistry;
import com.vmware.vsphere.client.task.impl.TaskUtil;
import flex.messaging.MessageBroker;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.Amf3Input;
import flex.messaging.util.Base64;
import flex.messaging.validators.ClassDeserializationValidator;
import flex.messaging.validators.DeserializationValidator;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.util.InetAddressUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class DownloadLogController {
    private static final Log _logger = LogFactory.getLog(DownloadLogController.class);
    private static final Version VERSION_6_0_0 = new Version("6.0.0");
    private static final long FIVE_SECONDS = TimeUnit.SECONDS.toMillis(5L);
    private static final String LOG_SPECS_PARAMETER_KEY = "DownloadLogSpecs";
    private static final String SELECTED_LOGS_SPEC_PARAMETER_NAME = "SelectedLogsSpec";
    private static final String FILE_ID_PARAM_NAME = "FileId";
    private static final String MANIFEST_CHECK = "manifests";
    private static final String FILE_SUFFIX = ".tgz";
    private static final String VMX_SUFFIX = ".vmx";
    private static final boolean INTERRUPT_ON_ERROR = false;
    private static final String TIME_FORMAT = "%1$tY-%1$te-%1$tm@%1$tH-%1$tM-%1$tS";
    private static final String FILENAME_FORMAT = "%s-%s%s%s";
    private static final int MAX_FILENAME_LENGTH = 255;
    private static final String ZIP_RESPONSE_CONTENT_TYPE = "application/zip";
    private static final String NAME_PROPERTY = "name";
    private static final String VERSION_PROPERTY = "summary/config/product/version";
    private static final String THUMBPRINT_PROPERTY = "summary/config/sslThumbprint";
    private static final String HTTPS_URL_PREFIX = "https://";
    private static final String MANIFEST_URL = "/cgi-bin/vm-support.cgi?manifests=";
    private static final String IPV6_HOSTNAME_PREFIX = "[";
    private static final String IPV6_HOSTNAME_SUFFIX = "]";
    private static final int FIFTY_PERCENT_INT = 50;
    private static final int HUNDRED_PERCENT_INT = 100;
    private static final float PERCENTAGE_FOR_VC_LOG_GENERATION_TASK = 0.4f;
    private static final String SPRING_DEFAULT_MESSAGE_BROKER = "_messageBroker";
    private final TaskRegistry _taskRegistry;
    private final QueryExecutor _queryExecutor;
    private final Executor _executor;
    private final KeystoreService _keystoreService;
    private final SSLConfigurationProvider _sslConfigurationProvider;

    public DownloadLogController(TaskRegistry taskRegistry, QueryExecutor queryExecutor, KeystoreService keystoreService, SSLConfigurationProvider sSLConfigurationProvider, Executor executor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{taskRegistry, queryExecutor, keystoreService, sSLConfigurationProvider, executor});
        this._taskRegistry = taskRegistry;
        this._queryExecutor = queryExecutor;
        this._keystoreService = keystoreService;
        this._sslConfigurationProvider = sSLConfigurationProvider;
        this._executor = executor;
    }

    @RequestMapping(method={RequestMethod.POST})
    public void downloadLogBundles(final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse) throws IOException, Exception {
        DownloadingLogsTask downloadingLogsTask;
        final HttpSession httpSession = httpServletRequest.getSession();
        Map map = httpServletRequest.getParameterMap();
        final String string = SessionUtil.getClientId((HttpSession)httpSession);
        if (string == null) {
            _logger.warn((Object)"ClientId is null.");
        }
        final SelectedLogsSpec selectedLogsSpec = this.processSelectedLogsSpecParameter(map);
        final Collection<LogBundleDownloadSpec> collection = this.processLogBundleDownloadSpecs(map);
        if (selectedLogsSpec == null && collection == null) {
            _logger.error((Object)"There is no spec for downloading logs in the request.");
            return;
        }
        ManagedObjectReference managedObjectReference = DownloadingLogsTask.findTaskTarget(selectedLogsSpec, collection);
        if (managedObjectReference != null) {
            int n = this.extractFileIdParam(map);
            downloadingLogsTask = new DownloadingLogsTask(string, managedObjectReference, n, this._queryExecutor, this._taskRegistry);
        } else {
            downloadingLogsTask = null;
        }
        try {
            final ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)httpServletResponse.getOutputStream());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block10: {
                        try {
                            SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
                            SessionUtil.setHttpSession((HttpSession)httpSession);
                            httpServletResponse.setContentType(DownloadLogController.ZIP_RESPONSE_CONTENT_TYPE);
                            if (selectedLogsSpec == null) {
                                KeyStore keyStore = DownloadLogController.this._keystoreService.getKeyStore();
                                Map map = DownloadLogController.this.parseParameters(collection, string, keyStore);
                                DownloadLogController.this.writeZipFile(map, zipOutputStream, string, downloadingLogsTask);
                            } else {
                                if (selectedLogsSpec.vCenterLogsIncluded) {
                                    ManagedObjectReference managedObjectReference = DownloadLogController.this.invokeGenerateLogBundlesTask(selectedLogsSpec.targetObjectReference, string);
                                    DownloadLogController.this.writeVcLogsToStream(zipOutputStream, managedObjectReference, selectedLogsSpec, string, downloadingLogsTask);
                                    DownloadLogController.this.writeHostLogsToStream(zipOutputStream, selectedLogsSpec, string, downloadingLogsTask);
                                } else {
                                    DownloadLogController.this.writeHostLogsToStream(zipOutputStream, selectedLogsSpec, string, downloadingLogsTask);
                                }
                                zipOutputStream.finish();
                            }
                            if (downloadingLogsTask != null) {
                                downloadingLogsTask.updateState(TaskState.SUCCESS, null);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            _logger.info((Object)"Downloading logs task thread was interrupted.");
                            Thread.currentThread().interrupt();
                        }
                        catch (WriteIOException writeIOException) {
                            if (downloadingLogsTask != null) {
                                _logger.info((Object)"Downloading logs is cancelled.");
                                _logger.debug((Object)"Exception in downloading logs: ", (Throwable)writeIOException);
                                downloadingLogsTask.updateState(TaskState.CANCELED, null);
                            }
                        }
                        catch (Exception exception) {
                            TaskState taskState;
                            _logger.error((Object)"Error downloading logs.", (Throwable)exception);
                            if (downloadingLogsTask == null || TaskState.CANCELED.equals((Object)(taskState = downloadingLogsTask.getState()))) break block10;
                            downloadingLogsTask.updateState(TaskState.ERROR, exception);
                        }
                    }
                }
            };
            FutureTask<Object> futureTask = new FutureTask<Object>(runnable, null);
            if (downloadingLogsTask != null) {
                TaskUtil.addClientTaskKeyFutureCloseablePair((String)downloadingLogsTask.getKey(), futureTask, (Closeable)zipOutputStream);
            }
            try {
                ExecutorUtil.executeTasks(Collections.singleton(futureTask), (Executor)this._executor);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (downloadingLogsTask != null) {
                TaskUtil.removeClientTaskKeyFromMap((String)downloadingLogsTask.getKey());
            }
        }
        catch (Exception exception) {
            if (downloadingLogsTask != null && TaskState.RUNNING == downloadingLogsTask.getClientTaskInfo().state) {
                downloadingLogsTask.updateState(TaskState.ERROR, exception);
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVcLogsToStream(ZipOutputStream zipOutputStream, ManagedObjectReference managedObjectReference, SelectedLogsSpec selectedLogsSpec, String string, DownloadingLogsTask downloadingLogsTask) throws Exception {
        TaskInfo taskInfo = this.monitorTask(managedObjectReference, string);
        if (taskInfo == null || taskInfo.result == null) {
            _logger.error((Object)"Generate log bundles task returned null result.");
            return;
        }
        DiagnosticManager.BundleInfo[] bundleInfoArray = (DiagnosticManager.BundleInfo[])taskInfo.result;
        boolean bl = ArrayUtil.isNullOrEmpty((Object[])selectedLogsSpec.selectedHosts);
        int n = bl ? 100 : 50;
        int n2 = (int)(0.4f * (float)n);
        if (downloadingLogsTask != null) {
            downloadingLogsTask.updateProgress(n2);
        }
        for (DiagnosticManager.BundleInfo bundleInfo : bundleInfoArray) {
            LogBundleDownloadSpec logBundleDownloadSpec = new LogBundleDownloadSpec();
            logBundleDownloadSpec.vcReference = selectedLogsSpec.targetObjectReference;
            logBundleDownloadSpec.serviceUuid = logBundleDownloadSpec.vcReference.getServerGuid();
            String string2 = DownloadLogController.getVcHostName(logBundleDownloadSpec.vcReference, string);
            logBundleDownloadSpec.bundleUrl = DownloadLogController.translateAsterisk(bundleInfo.url, string2);
            String string3 = DownloadLogController.getZipFileName(logBundleDownloadSpec.bundleUrl);
            UrlZipEntry urlZipEntry = UrlZipEntry.getInstance(logBundleDownloadSpec, null, this._sslConfigurationProvider);
            ZipEntry zipEntry = new ZipEntry(string3);
            try {
                zipOutputStream.putNextEntry(zipEntry);
                urlZipEntry.write(zipOutputStream, string, downloadingLogsTask, n - n2);
            }
            catch (ReadIOException readIOException) {
                _logger.error((Object)("Error writing zip entry from URL: " + bundleInfo.url), (Throwable)readIOException);
            }
            finally {
                zipOutputStream.closeEntry();
            }
        }
    }

    private TaskInfo monitorTask(ManagedObjectReference managedObjectReference, String string) throws Exception {
        Task task = (Task)ManagedObjectUtil.getManagedObjectByClientId((ManagedObjectReference)managedObjectReference, (String)string);
        TaskInfo taskInfo = task.getInfo();
        while (taskInfo != null && (taskInfo.state == TaskInfo.State.queued || taskInfo.state == TaskInfo.State.running)) {
            Thread.sleep(FIVE_SECONDS);
            taskInfo = task.getInfo();
        }
        return taskInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHostLogsToStream(ZipOutputStream zipOutputStream, SelectedLogsSpec selectedLogsSpec, String string, DownloadingLogsTask downloadingLogsTask) throws Exception {
        ZipEntry zipEntry;
        Object object;
        Object object2;
        if (ArrayUtil.isNullOrEmpty((Object[])selectedLogsSpec.selectedHosts)) {
            _logger.error((Object)"Empty list of hosts.");
            return;
        }
        Map<ManagedObjectReference, Map<String, Object>> map = this.getHostsProperties(selectedLogsSpec.selectedHosts);
        ArrayList<LogBundleDownloadSpec> arrayList = new ArrayList<LogBundleDownloadSpec>();
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> entry : map.entrySet()) {
            ManagedObjectReference managedObjectReference = entry.getKey();
            Map<String, Object> object3 = entry.getValue();
            object2 = new LogBundleDownloadSpec();
            object = (String)object3.get(NAME_PROPERTY);
            if (InetAddressUtils.isIPv6Address((String)object)) {
                object = IPV6_HOSTNAME_PREFIX + (String)object + IPV6_HOSTNAME_SUFFIX;
            }
            object2.bundleUrl = HTTPS_URL_PREFIX + (String)object + MANIFEST_URL + selectedLogsSpec.selectedManifestString;
            if (!StringUtil.isNullOrEmpty((String)selectedLogsSpec.encryptPassword)) {
                object2.encryptPassword = selectedLogsSpec.encryptPassword;
            }
            object2.serviceUuid = managedObjectReference.getServerGuid();
            zipEntry = new Version((String)object3.get(VERSION_PROPERTY));
            if (zipEntry.compareTo(VERSION_6_0_0) < 0) {
                object2.thumbprint = (String)object3.get(THUMBPRINT_PROPERTY);
            }
            arrayList.add((LogBundleDownloadSpec)((Object)object2));
        }
        int n = selectedLogsSpec.vCenterLogsIncluded ? 50 : 100;
        int n2 = n / arrayList.size();
        for (LogBundleDownloadSpec logBundleDownloadSpec : arrayList) {
            object2 = DownloadLogController.getZipFileName(logBundleDownloadSpec.bundleUrl);
            object = UrlZipEntry.getInstance(logBundleDownloadSpec, null, this._sslConfigurationProvider);
            zipEntry = new ZipEntry((String)object2);
            try {
                zipOutputStream.putNextEntry(zipEntry);
                ((UrlZipEntry)object).write(zipOutputStream, string, downloadingLogsTask, n2);
            }
            catch (ReadIOException readIOException) {
                _logger.error((Object)("Error writing zip entry from URL: " + logBundleDownloadSpec.bundleUrl), (Throwable)readIOException);
            }
            finally {
                zipOutputStream.closeEntry();
            }
        }
    }

    private Map<ManagedObjectReference, Map<String, Object>> getHostsProperties(ManagedObjectReference[] managedObjectReferenceArray) throws Exception {
        PropertyValue[] propertyValueArray = this._queryExecutor.getProperties((Object[])managedObjectReferenceArray, new String[]{NAME_PROPERTY, VERSION_PROPERTY, THUMBPRINT_PROPERTY});
        HashMap<ManagedObjectReference, Map<String, Object>> hashMap = new HashMap<ManagedObjectReference, Map<String, Object>>();
        for (PropertyValue propertyValue : propertyValueArray) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)propertyValue.resourceObject;
            HashMap<String, Object> hashMap2 = (HashMap<String, Object>)hashMap.get(managedObjectReference);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, Object>();
                hashMap.put(managedObjectReference, hashMap2);
            }
            hashMap2.put(propertyValue.propertyName, propertyValue.value);
        }
        return hashMap;
    }

    private ManagedObjectReference invokeGenerateLogBundlesTask(ManagedObjectReference managedObjectReference, String string) throws Exception {
        if (managedObjectReference == null) {
            throw new Exception("vCenter Server reference is null");
        }
        VcService vcService = VimSessionUtil.getServiceByClientId((String)managedObjectReference.getServerGuid(), (String)string);
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        DiagnosticManager diagnosticManager = (DiagnosticManager)ManagedObjectUtil.getManagedObjectByClientId((ManagedObjectReference)serviceInstanceContent.getDiagnosticManager(), (String)string);
        return diagnosticManager.generateLogBundles(true, null, null);
    }

    private SelectedLogsSpec processSelectedLogsSpecParameter(Map<String, String[]> map) throws IOException {
        Object[] objectArray = map.get(SELECTED_LOGS_SPEC_PARAMETER_NAME);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return null;
        }
        return DownloadLogController.parseSelectedLogsSpec((String)objectArray[0]);
    }

    private int extractFileIdParam(Map<String, String[]> map) {
        Object[] objectArray = map.get(FILE_ID_PARAM_NAME);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            _logger.error((Object)"FileId parameter is empty.");
            return 0;
        }
        try {
            return Integer.parseInt((String)objectArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            _logger.error((Object)"Error parsing FileId param", (Throwable)numberFormatException);
            return 0;
        }
    }

    private Collection<LogBundleDownloadSpec> processLogBundleDownloadSpecs(Map<String, String[]> map) throws IOException {
        Object[] objectArray = map.get(LOG_SPECS_PARAMETER_KEY);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return null;
        }
        ArrayList<LogBundleDownloadSpec> arrayList = new ArrayList<LogBundleDownloadSpec>();
        for (Object object : objectArray) {
            arrayList.addAll(DownloadLogController.parseDownloadSpecs((String)object));
        }
        return arrayList;
    }

    private Map<String, UrlZipEntry> parseParameters(Collection<LogBundleDownloadSpec> collection, String string, KeyStore keyStore) throws IOException {
        LinkedHashMap<String, UrlZipEntry> linkedHashMap = new LinkedHashMap<String, UrlZipEntry>();
        for (LogBundleDownloadSpec logBundleDownloadSpec : collection) {
            String string2;
            if (logBundleDownloadSpec.vcReference != null) {
                string2 = DownloadLogController.getVcHostName(logBundleDownloadSpec.vcReference, string);
                logBundleDownloadSpec.bundleUrl = DownloadLogController.translateAsterisk(logBundleDownloadSpec.bundleUrl, string2);
            }
            string2 = DownloadLogController.getZipFileName(logBundleDownloadSpec.bundleUrl);
            _logger.info((Object)("Add log bundle: " + logBundleDownloadSpec.bundleUrl));
            linkedHashMap.put(string2, UrlZipEntry.getInstance(logBundleDownloadSpec, keyStore, this._sslConfigurationProvider));
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static Collection<LogBundleDownloadSpec> parseDownloadSpecs(String var0) throws IOException {
        var1_1 = new Base64.Decoder();
        var1_1.decode(var0);
        var2_2 = var1_1.flush();
        var3_3 = TypeMarshallingContext.getTypeMarshallingContext().getClassLoader();
        var4_4 = LogBundleDownloadSpec.class.getClassLoader();
        var5_5 = new Amf3Input(DownloadLogController.getAmfSerializationContext(var4_4));
        var5_5.setInputStream((InputStream)new ByteArrayInputStream(var2_2));
        var6_6 = new ArrayList<LogBundleDownloadSpec>();
lbl9:
        // 3 sources

        try {
            while (var5_5.available() > 0) {
                block10: {
                    var7_7 = var5_5.readObject();
                    if (var7_7 instanceof LogBundleDownloadSpec) {
                        var6_6.add((LogBundleDownloadSpec)var7_7);
                        continue;
                    }
                    if (!(var7_7 instanceof Object[])) break block10;
                    for (Object var11_13 : (Object[])var7_7) {
                        if (!(var11_13 instanceof LogBundleDownloadSpec)) continue;
                        var6_6.add((LogBundleDownloadSpec)var11_13);
                    }
                    ** GOTO lbl9
                }
                if (!(var7_7 instanceof Map)) continue;
                for (E var9_11 : ((Map)var7_7).values()) {
                    if (!(var9_11 instanceof LogBundleDownloadSpec)) continue;
                    var6_6.add((LogBundleDownloadSpec)var9_11);
                }
                ** GOTO lbl9
            }
        }
        catch (ClassNotFoundException var7_8) {
            DownloadLogController._logger.warn((Object)"The AMF deserialization fails.", (Throwable)var7_8);
        }
        finally {
            var5_5.close();
            TypeMarshallingContext.getTypeMarshallingContext().setClassLoader(var3_3);
        }
        return var6_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SelectedLogsSpec parseSelectedLogsSpec(String string) throws IOException {
        Base64.Decoder decoder = new Base64.Decoder();
        decoder.decode(string);
        byte[] byArray = decoder.flush();
        ClassLoader classLoader = TypeMarshallingContext.getTypeMarshallingContext().getClassLoader();
        ClassLoader classLoader2 = SelectedLogsSpec.class.getClassLoader();
        Amf3Input amf3Input = new Amf3Input(DownloadLogController.getAmfSerializationContext(classLoader2));
        amf3Input.setInputStream((InputStream)new ByteArrayInputStream(byArray));
        SelectedLogsSpec selectedLogsSpec = null;
        try {
            while (amf3Input.available() > 0) {
                Object object = amf3Input.readObject();
                if (object instanceof SelectedLogsSpec) {
                    selectedLogsSpec = (SelectedLogsSpec)((Object)object);
                } else if (object instanceof Object[]) {
                    for (Object object2 : (Object[])object) {
                        if (!(object2 instanceof SelectedLogsSpec)) continue;
                        selectedLogsSpec = (SelectedLogsSpec)((Object)object2);
                        break;
                    }
                } else if (object instanceof Map) {
                    for (Object e : ((Map)object).values()) {
                        if (!(e instanceof SelectedLogsSpec)) continue;
                        selectedLogsSpec = (SelectedLogsSpec)((Object)e);
                        break;
                    }
                }
                if (selectedLogsSpec == null) continue;
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            _logger.warn((Object)"The AMF deserialization fails.", (Throwable)classNotFoundException);
        }
        finally {
            amf3Input.close();
            TypeMarshallingContext.getTypeMarshallingContext().setClassLoader(classLoader);
        }
        return selectedLogsSpec;
    }

    private static SerializationContext getAmfSerializationContext(ClassLoader classLoader) {
        TypeMarshallingContext.getTypeMarshallingContext().setClassLoader(classLoader);
        SerializationContext serializationContext = SerializationContext.getSerializationContext();
        serializationContext.setDeserializerClass(AmfMessageDeserializer.class);
        MessageBroker messageBroker = MessageBroker.getMessageBroker((String)SPRING_DEFAULT_MESSAGE_BROKER);
        ClassDeserializationValidator classDeserializationValidator = (ClassDeserializationValidator)messageBroker.getDeserializationValidator();
        serializationContext.setDeserializationValidator((DeserializationValidator)classDeserializationValidator);
        return serializationContext;
    }

    private static String getZipFileName(String string) throws MalformedURLException {
        String string2 = DownloadLogController.getBundleName(string);
        String string3 = DownloadLogController.getHostName(string);
        if (StringUtil.isNullOrEmpty((String)string3)) {
            string3 = DownloadLogController.getHostNameOrIp();
        }
        String string4 = DownloadLogController.getBundlePrefix(string2);
        String string5 = DownloadLogController.getBundleSuffix(string);
        String string6 = DownloadLogController.getCurrentTimestamp();
        String string7 = String.format(FILENAME_FORMAT, string3, string4, string6, string5);
        int n = string7.length() - 255;
        if (n > 0) {
            if (string4.length() > n) {
                string4 = string4.substring(0, string4.length() - n);
            } else {
                int n2 = string4.length();
                string4 = "";
                int n3 = n - n2;
                string3 = string3.substring(0, string3.length() - n3);
            }
            string7 = String.format(FILENAME_FORMAT, string3, string4, string6, string5);
        }
        return string7;
    }

    private static String getBundleName(String string) {
        int n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        String string2 = string.substring(n + 1);
        return string2;
    }

    private static String getBundlePrefix(String string) {
        boolean bl;
        int n = string.indexOf(63);
        int n2 = string.indexOf(45);
        boolean bl2 = n != -1;
        boolean bl3 = bl = n2 != -1;
        int n3 = bl2 && bl ? Math.min(n, n2) : (bl2 || bl ? Math.max(n, n2) : 0);
        return string.substring(0, n3);
    }

    private static String getBundleSuffix(String string) {
        String string2;
        int n = string.lastIndexOf("?");
        if (n != -1 && (string2 = string.substring(n + 1)).contains(MANIFEST_CHECK)) {
            return FILE_SUFFIX;
        }
        string2 = string;
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        String string3 = "";
        int n2 = string2.lastIndexOf(".");
        if (n2 > -1 && (string3 = string2.substring(n2)).contains(MANIFEST_CHECK)) {
            string3 = FILE_SUFFIX;
        }
        return string3;
    }

    private static String getCurrentTimestamp() {
        return String.format(TIME_FORMAT, Calendar.getInstance());
    }

    private static String translateAsterisk(String string, String string2) {
        return string.replace("*", string2);
    }

    private static String getVcHostName(ManagedObjectReference managedObjectReference, String string) throws MalformedURLException {
        VcService vcService = VimSessionUtil.getServiceByClientId((String)managedObjectReference.getServerGuid(), (String)string);
        for (ServiceEndpointEx serviceEndpointEx : vcService.getServiceEndPoints()) {
            if (serviceEndpointEx == null || !ServiceDirectory.ServiceProtocol.vimApi.name().equalsIgnoreCase(serviceEndpointEx.getProtocol()) || !serviceEndpointEx.getVcGuid().equals(managedObjectReference.getServerGuid())) continue;
            return serviceEndpointEx.instanceName;
        }
        _logger.warn((Object)"Unable to find VIM endpoint for VC service, resorting to service URL for retrieving the hostname.");
        return DownloadLogController.getHostName(vcService.getServiceUrl());
    }

    private static String getHostName(String string) throws MalformedURLException {
        return new URL(string).getHost();
    }

    private static String getHostNameOrIp() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            String string = "The localhost has no IP address configured.";
            _logger.error((Object)string);
            throw new IllegalStateException(string, unknownHostException);
        }
        String string = inetAddress.getHostName();
        if (StringUtil.isNullOrEmpty((String)string)) {
            string = inetAddress.getHostAddress();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipFile(Map<String, UrlZipEntry> map, ZipOutputStream zipOutputStream, String string, DownloadingLogsTask downloadingLogsTask) throws IOException, Exception {
        int n = 100 / map.size();
        for (Map.Entry<String, UrlZipEntry> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (string2.endsWith(VMX_SUFFIX)) {
                string2 = string2.substring(0, string2.length() - VMX_SUFFIX.length()) + FILE_SUFFIX;
            }
            ZipEntry zipEntry = new ZipEntry(string2);
            try {
                zipOutputStream.putNextEntry(zipEntry);
                entry.getValue().write(zipOutputStream, string, downloadingLogsTask, n);
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug((Object)("Zip entry " + string2 + " has been successfully written."));
            }
            catch (IOException iOException) {
                _logger.warn((Object)("The zip data under '" + string2 + "' will be invalid."), (Throwable)iOException);
            }
            finally {
                zipOutputStream.closeEntry();
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"The zip writing process has finished.");
        }
        zipOutputStream.finish();
    }
}

