/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.logbundle;

import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreUtil;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.logbundle.LogBundleDownloadSpec;
import com.vmware.vsphere.client.logbundle.UrlZipEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.HashMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpZipEntry
extends UrlZipEntry {
    private static Log _logger = LogFactory.getLog(HttpZipEntry.class);
    private static final String MANIFEST_CHECK = "manifests";
    private static final String AUTH_COOKIE_PREFIX = "vmware_cgi_ticket=";
    private static final String VM_PARAM_NAME = "vm";
    private static final String ENCRYPT_PASSWORD_PARAM = "password";
    private final String _serviceUuid;
    private final KeyStore _keyStore;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final String _thumbprint;
    private String _vmPath = null;
    private String _encryptPassword = null;

    public HttpZipEntry(URI uRI, LogBundleDownloadSpec logBundleDownloadSpec, KeyStore keyStore, SSLConfigurationProvider sSLConfigurationProvider) {
        super(uRI);
        Validate.notNull((Object)sSLConfigurationProvider);
        this._serviceUuid = logBundleDownloadSpec.serviceUuid;
        this._keyStore = keyStore;
        this._sslConfigurationProvider = sSLConfigurationProvider;
        if (logBundleDownloadSpec.vcReference != null && StringUtil.isNullOrEmpty((String)logBundleDownloadSpec.thumbprint)) {
            ManagedObjectReference managedObjectReference = logBundleDownloadSpec.vcReference;
            if (VcServiceUtil.is60VcOrLater((String)managedObjectReference.getServerGuid())) {
                this._thumbprint = null;
                return;
            }
            VcService vcService = VimSessionUtil.getService((String)managedObjectReference.getServerGuid());
            this._thumbprint = vcService.getThumbprint();
        } else {
            this._thumbprint = logBundleDownloadSpec.thumbprint;
        }
    }

    public void setVmPath(String string) {
        this._vmPath = string;
    }

    public void setEncryptPassword(String string) {
        this._encryptPassword = string;
    }

    @Override
    protected InputStream connect(String string) throws IOException, Exception {
        Object object;
        SessionManager.GenericServiceTicket genericServiceTicket;
        String string2 = this.url.toString();
        HashMap<String, String> hashMap = null;
        HashMap<String, String> hashMap2 = null;
        if (string2.contains(MANIFEST_CHECK)) {
            _logger.debug((Object)"Building up authorization headers for HTTP connection");
            genericServiceTicket = VcServiceUtil.acquireGenericServiceTicketByClientId((String)string, (String)string2, (String)this._serviceUuid);
            hashMap2 = new HashMap<String, String>();
            hashMap2.put("Cookie", AUTH_COOKIE_PREFIX + genericServiceTicket.getId());
            hashMap = new HashMap<String, String>();
            if (this._vmPath != null) {
                hashMap.put(VM_PARAM_NAME, this._vmPath);
            }
            if (this._encryptPassword != null) {
                hashMap.put(ENCRYPT_PASSWORD_PARAM, this._encryptPassword);
            }
            hashMap.put("http.protocol.cookie-policy", "rfc2109");
        }
        genericServiceTicket = null;
        if (StringUtil.isNullOrEmpty((String)this._thumbprint)) {
            object = this._keyStore;
            if (object == null) {
                object = KeystoreUtil.getKeyStore();
            }
            genericServiceTicket = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).addTrustStore((KeyStore)object).socketReadTimeout(0).buildHttpClientIgnoreErrors();
        } else {
            genericServiceTicket = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).thumbprint(this._thumbprint).socketReadTimeout(0).buildHttpClientIgnoreErrors();
        }
        object = genericServiceTicket.executeMethodResponseAsStream(string2, hashMap, hashMap2);
        this.contentLength = genericServiceTicket.getContentLength();
        return object;
    }
}

