/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.i18n;

import com.vmware.vise.util.Pair;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.vim.commons.i18n.CatalogEntry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CatalogFileUtil {
    private static final String FILE_EXTENSION = ".vmsg";
    private static final String VALIDATION_KEY = "signature";
    private static final String VALIDATION_VALUE = "sIgNaTuRe";
    private static final Log _logger = LogFactory.getLog(CatalogFileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, CatalogEntry> loadCatalog(String string) {
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        HashMap<String, CatalogEntry> hashMap;
        block8: {
            Pair<String, String> pair;
            hashMap = new HashMap<String, CatalogEntry>();
            if (!string.endsWith(FILE_EXTENSION)) {
                _logger.error((Object)("The message file " + string + " doesn't have a valid extension, vmsg"));
                return null;
            }
            fileInputStream = null;
            inputStreamReader = null;
            bufferedReader = null;
            try {
                File file = new File(string);
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = null;
                boolean bl = false;
                while ((string2 = bufferedReader.readLine()) != null) {
                    pair = CatalogFileUtil.convertLineToPair(string2 = CatalogFileUtil.processLineWrapping(string2, bufferedReader));
                    if (pair == null) continue;
                    if (VALIDATION_KEY.equals(pair.first)) {
                        if (!VALIDATION_VALUE.equals(pair.second)) {
                            bl = false;
                            break;
                        }
                        bl = true;
                        continue;
                    }
                    if (hashMap.containsKey(pair.first)) continue;
                    CatalogEntry catalogEntry = new CatalogEntry((String)pair.first, (String)pair.second);
                    hashMap.put((String)pair.first, catalogEntry);
                }
                if (bl) break block8;
                _logger.error((Object)("Failed to load message file " + string + " due to missing signature."));
                pair = null;
            }
            catch (Exception exception) {
                Map<String, CatalogEntry> map;
                try {
                    _logger.error((Object)("Error when parsing vmsg file: " + string), (Throwable)exception);
                    map = null;
                }
                catch (Throwable throwable) {
                    StreamUtil.close(bufferedReader);
                    StreamUtil.close(inputStreamReader);
                    StreamUtil.close(fileInputStream);
                    throw throwable;
                }
                StreamUtil.close(bufferedReader);
                StreamUtil.close((Closeable)inputStreamReader);
                StreamUtil.close((Closeable)fileInputStream);
                return map;
            }
            StreamUtil.close((Closeable)bufferedReader);
            StreamUtil.close((Closeable)inputStreamReader);
            StreamUtil.close((Closeable)fileInputStream);
            return pair;
        }
        StreamUtil.close((Closeable)bufferedReader);
        StreamUtil.close((Closeable)inputStreamReader);
        StreamUtil.close((Closeable)fileInputStream);
        return hashMap;
    }

    private static Pair<String, String> convertLineToPair(String string) {
        if ((string = string.trim()).length() == 0 || string.startsWith("#")) {
            return null;
        }
        int n = string.indexOf(61);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        string2 = string2.trim();
        if ((string3 = string3.trim()).startsWith("\"") && string3.endsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        string3 = string3.replace("\\n", "\n");
        Pair pair = new Pair((Object)string2, (Object)string3);
        return pair;
    }

    private static String processLineWrapping(String string, BufferedReader bufferedReader) throws IOException {
        if (!string.endsWith("\\")) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(0, string.length() - 1));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#")) continue;
            int n = string2.length();
            boolean bl = string2.endsWith("\\");
            if (bl) {
                --n;
            }
            stringBuilder.append(string2.substring(0, n));
            if (bl) continue;
            break;
        }
        return stringBuilder.toString();
    }
}

